/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseWriterConfig;
import org.apache.maven.plugin.eclipse.writers.MonitoredResource;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public abstract class EclipseLaunchConfigurationWriter
extends AbstractEclipseWriter {
    public static final String FILE_DOT_EXTERNAL_TOOL_BUILDERS = ".externalToolBuilders/";
    private String filename;
    private boolean initialized;

    protected EclipseWriter init(Log log, EclipseWriterConfig config, String filename) {
        this.filename = filename;
        this.initialized = true;
        return super.init(log, config);
    }

    @Override
    public void write() throws MojoExecutionException {
        OutputStreamWriter w;
        if (!this.initialized) {
            throw new MojoExecutionException("Not initialized");
        }
        try {
            File extToolsDir = new File(this.config.getEclipseProjectDirectory(), FILE_DOT_EXTERNAL_TOOL_BUILDERS);
            if (!extToolsDir.exists() && !extToolsDir.mkdir()) {
                throw new MojoExecutionException("Error creating directory " + extToolsDir);
            }
            w = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(extToolsDir, this.filename)), "UTF-8");
        }
        catch (IOException ex) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.erroropeningfile"), (Exception)ex);
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, "UTF-8", null);
        writer.startElement("launchConfiguration");
        writer.addAttribute("type", this.getLaunchConfigurationType());
        EclipseLaunchConfigurationWriter.writeAttribute((XMLWriter)writer, "org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", this.isLaunchInBackground());
        EclipseLaunchConfigurationWriter.writeAttribute((XMLWriter)writer, "org.eclipse.ui.externaltools.ATTR_RUN_BUILD_KINDS", StringUtils.join((Object[])this.getRunBuildKinds(), (String)","));
        EclipseLaunchConfigurationWriter.writeAttribute((XMLWriter)writer, "org.eclipse.ui.externaltools.ATTR_TRIGGERS_CONFIGURED", true);
        EclipseLaunchConfigurationWriter.writeAttribute((XMLWriter)writer, "org.eclipse.debug.core.appendEnvironmentVariables", this.isAppendEnvironmentVariables());
        EclipseLaunchConfigurationWriter.writeAttribute((XMLWriter)writer, "org.eclipse.jdt.launching.PROJECT_ATTR", this.config.getEclipseProjectName());
        EclipseLaunchConfigurationWriter.writeAttribute((XMLWriter)writer, "org.eclipse.jdt.launching.DEFAULT_CLASSPATH", true);
        EclipseLaunchConfigurationWriter.writeAttribute((XMLWriter)writer, "org.eclipse.ui.externaltools.ATTR_LOCATION", this.getBuilderLocation());
        if (this.getWorkingDirectory() != null) {
            EclipseLaunchConfigurationWriter.writeAttribute((XMLWriter)writer, "org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", this.getWorkingDirectory());
        }
        if (this.getRefreshScope() != null) {
            EclipseLaunchConfigurationWriter.writeAttribute((XMLWriter)writer, "org.eclipse.debug.core.ATTR_REFRESH_SCOPE", this.getRefreshScope());
        }
        EclipseLaunchConfigurationWriter.writeAttribute((XMLWriter)writer, "org.eclipse.debug.core.capture_output", this.isCaptureOutput());
        String workingSet = "<?xml version='1.0'?><launchConfigurationWorkingSet editPageId='org.eclipse.ui.resourceWorkingSetPage' factoryID='org.eclipse.ui.internal.WorkingSetFactory' label='workingSet' name='workingSet'>";
        for (Object o : this.getMonitoredResources()) {
            MonitoredResource monitoredResource = (MonitoredResource)o;
            workingSet = workingSet + monitoredResource.print();
        }
        workingSet = workingSet + "</launchConfigurationWorkingSet>";
        EclipseLaunchConfigurationWriter.writeAttribute((XMLWriter)writer, "org.eclipse.ui.externaltools.ATTR_BUILD_SCOPE", "${working_set:" + workingSet + "}");
        this.addAttributes((XMLWriter)writer);
        writer.endElement();
        IOUtil.close((Writer)w);
    }

    protected List getMonitoredResources() {
        return Collections.singletonList(new MonitoredResource(this.config.getEclipseProjectName(), 4));
    }

    protected abstract void addAttributes(XMLWriter var1);

    private boolean isCaptureOutput() {
        return false;
    }

    private String getWorkingDirectory() {
        return "${build_project}";
    }

    protected String getRefreshScope() {
        return "${project}";
    }

    protected abstract String getBuilderLocation();

    protected String[] getRunBuildKinds() {
        return new String[]{"full", "incremental", "auto", "clean"};
    }

    protected boolean isAppendEnvironmentVariables() {
        return true;
    }

    protected boolean isLaunchInBackground() {
        return false;
    }

    protected abstract String getLaunchConfigurationType();

    protected static void writeAttribute(XMLWriter writer, String key, String value) {
        writer.startElement("stringAttribute");
        writer.addAttribute("key", key);
        writer.addAttribute("value", value);
        writer.endElement();
    }

    protected static void writeAttribute(XMLWriter writer, String key, boolean value) {
        writer.startElement("booleanAttribute");
        writer.addAttribute("key", key);
        writer.addAttribute("value", "" + value);
        writer.endElement();
    }

    protected static void writeAttribute(XMLWriter writer, String key, String[] values) {
        writer.startElement("listAttribute");
        writer.addAttribute("key", key);
        for (String value : values) {
            writer.startElement("listEntry");
            writer.addAttribute("value", value);
            writer.endElement();
        }
        writer.endElement();
    }
}

