/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers.workspace;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.WorkspaceConfiguration;
import org.apache.maven.plugin.eclipse.writers.workspace.EclipseCodeFormatterProfile;
import org.apache.maven.plugin.eclipse.writers.workspace.WorkspaceWriter;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.IOUtil;

public class EclipseWorkspaceWriter
implements WorkspaceWriter {
    public static final String ECLIPSE_PLUGINS_METADATA_DIR = ".metadata/.plugins";
    public static final String ECLIPSE_CORE_RUNTIME_SETTINGS_DIR = ".metadata/.plugins/org.eclipse.core.runtime/.settings";
    public static final String DIR_DOT_SETTINGS = ".settings";
    public static final String ECLIPSE_JDT_CORE_PREFS_FILE = "org.eclipse.jdt.core.prefs";
    public static final String CLASSPATH_VARIABLE_M2_REPO = "org.eclipse.jdt.core.classpathVariable.M2_REPO";
    public static final String ECLIPSE_JDT_UI_PREFS_FILE = "org.eclipse.jdt.ui.prefs";
    private WorkspaceConfiguration config;
    private Log logger;
    private File workDir;

    @Override
    public WorkspaceWriter init(Log logger, WorkspaceConfiguration config) {
        this.logger = logger;
        this.config = config;
        this.workDir = new File(config.getWorkspaceDirectory(), ECLIPSE_CORE_RUNTIME_SETTINGS_DIR);
        this.workDir.mkdirs();
        return this;
    }

    @Override
    public void write() throws MojoExecutionException {
        this.writeLocalRepositoryConfiguration();
        if (this.config.getCodeStylesURL() != null) {
            this.writeCodeStyleConfiguration();
        }
    }

    private void writeCodeStyleConfiguration() throws MojoExecutionException {
        File f = new File(this.workDir, ECLIPSE_JDT_UI_PREFS_FILE);
        Properties props = EclipseWorkspaceWriter.loadProperties(f);
        EclipseCodeFormatterProfile codeFormatter = new EclipseCodeFormatterProfile().init(this.config.getCodeStylesURL(), this.config.getActiveStyleProfileName());
        if (codeFormatter.getProfileName() != null) {
            this.logger.info((CharSequence)("Set active code style profile name: " + codeFormatter.getProfileName()));
            props.setProperty("formatter_profile", "_" + codeFormatter.getProfileName());
        }
        props.setProperty("org.eclipse.jdt.ui.formatterprofiles", codeFormatter.getContent());
        EclipseWorkspaceWriter.storeProperties(props, f);
    }

    private void writeLocalRepositoryConfiguration() throws MojoExecutionException {
        File f = new File(this.workDir, ECLIPSE_JDT_CORE_PREFS_FILE);
        Properties props = EclipseWorkspaceWriter.loadProperties(f);
        props.put(CLASSPATH_VARIABLE_M2_REPO, this.config.getLocalRepository().getBasedir());
        EclipseWorkspaceWriter.storeProperties(props, f);
    }

    private static Properties loadProperties(File f) throws MojoExecutionException {
        Properties props = new Properties();
        if (f.exists()) {
            try {
                props.load(new FileInputStream(f));
            }
            catch (FileNotFoundException e) {
                throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantreadfile", f.getAbsolutePath()), (Exception)e);
            }
            catch (IOException e) {
                throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantreadfile", f.getAbsolutePath()), (Exception)e);
            }
        }
        return props;
    }

    private static void storeProperties(Properties props, File f) throws MojoExecutionException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(f);
            props.store(os, null);
        }
        catch (IOException ioe) {
            try {
                throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantwritetofile", f.getAbsolutePath()));
            }
            catch (Throwable throwable) {
                IOUtil.close(os);
                throw throwable;
            }
        }
        IOUtil.close((OutputStream)os);
    }
}

