/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers.wtp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.wtp.AbstractWtpResourceWriter;
import org.apache.maven.plugin.ide.IdeUtils;
import org.apache.maven.plugin.ide.JeeUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class EclipseWtpFacetsWriter
extends AbstractWtpResourceWriter {
    private static final String FACET_COM_IBM_WEBSPHERE_COEXISTENCE_EAR = "com.ibm.websphere.coexistence.ear";
    private static final String FACET_COM_IBM_WEBSPHERE_EXTENDED_EAR = "com.ibm.websphere.extended.ear";
    private static final String FACET_JST_EAR = "jst.ear";
    private static final String FACET_JST_UTILITY = "jst.utility";
    private static final String FACET_JST_EJB = "jst.ejb";
    private static final String FACET_JST_WEB = "jst.web";
    private static final String FACET_JST_JAVA = "jst.java";
    private static final String ATTR_VERSION = "version";
    private static final String ELT_INSTALLED = "installed";
    private static final String ATTR_FACET = "facet";
    private static final String ELT_FIXED = "fixed";
    private static final String ELT_FACETED_PROJECT = "faceted-project";
    private static final String DIR_WTP_SETTINGS = ".settings";
    private static final String FILE_FACET_CORE_XML = "org.eclipse.wst.common.project.facet.core.xml";

    @Override
    public void write() throws MojoExecutionException {
        OutputStreamWriter w;
        File settingsDir = new File(this.config.getEclipseProjectDirectory(), DIR_WTP_SETTINGS);
        settingsDir.mkdirs();
        String packaging = this.config.getPackaging();
        try {
            w = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(settingsDir, FILE_FACET_CORE_XML)), "UTF-8");
        }
        catch (IOException ex) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.erroropeningfile"), (Exception)ex);
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, "UTF-8", null);
        this.writeModuleTypeFacetCore((XMLWriter)writer, packaging);
        IOUtil.close((Writer)w);
    }

    private void writeModuleTypeFacetCore(XMLWriter writer, String packaging) {
        writer.startElement(ELT_FACETED_PROJECT);
        if ("war".equalsIgnoreCase(packaging)) {
            this.writeFacetFixedElement(writer, FACET_JST_JAVA);
            this.writeFacetFixedElement(writer, FACET_JST_WEB);
            String servletVersion = this.config.getJeeVersion() != null ? JeeUtils.getJeeDescriptorFromJeeVersion(this.config.getJeeVersion()).getServletVersion() : JeeUtils.resolveServletVersion(this.config.getProject());
            this.writeFacetInstalledElement(writer, FACET_JST_WEB, servletVersion);
            this.writeFacetInstalledElement(writer, FACET_JST_JAVA, IdeUtils.resolveJavaVersion(this.config.getProject()));
        } else if ("ejb".equalsIgnoreCase(packaging)) {
            this.writeFacetFixedElement(writer, FACET_JST_JAVA);
            this.writeFacetFixedElement(writer, FACET_JST_EJB);
            String ejbVersion = this.config.getJeeVersion() != null ? JeeUtils.getJeeDescriptorFromJeeVersion(this.config.getJeeVersion()).getEjbVersion() : JeeUtils.resolveEjbVersion(this.config.getProject());
            this.writeFacetInstalledElement(writer, FACET_JST_EJB, ejbVersion);
            this.writeFacetInstalledElement(writer, FACET_JST_JAVA, IdeUtils.resolveJavaVersion(this.config.getProject()));
        } else if ("ear".equalsIgnoreCase(packaging)) {
            if (this.config.getWorkspaceConfiguration().getWebsphereVersion() != null) {
                writer.startElement("runtime");
                writer.addAttribute("name", this.config.getWorkspaceConfiguration().getDefaultDeployServerName());
                writer.endElement();
                this.writeFacetInstalledElement(writer, FACET_COM_IBM_WEBSPHERE_EXTENDED_EAR, this.config.getWorkspaceConfiguration().getWebsphereVersion());
                this.writeFacetInstalledElement(writer, FACET_COM_IBM_WEBSPHERE_COEXISTENCE_EAR, this.config.getWorkspaceConfiguration().getWebsphereVersion());
            }
            this.writeFacetFixedElement(writer, FACET_JST_EAR);
            String jeeVersion = this.config.getJeeVersion() != null ? JeeUtils.getJeeDescriptorFromJeeVersion(this.config.getJeeVersion()).getJeeVersion() : JeeUtils.resolveJeeVersion(this.config.getProject());
            this.writeFacetInstalledElement(writer, FACET_JST_EAR, jeeVersion);
        } else if ("jar".equalsIgnoreCase(packaging)) {
            this.writeFacetFixedElement(writer, FACET_JST_JAVA);
            this.writeFacetFixedElement(writer, FACET_JST_UTILITY);
            this.writeFacetInstalledElement(writer, FACET_JST_UTILITY, "1.0");
            this.writeFacetInstalledElement(writer, FACET_JST_JAVA, IdeUtils.resolveJavaVersion(this.config.getProject()));
        }
        this.writeAdditionalProjectFacets(writer);
        writer.endElement();
    }

    private void writeFacetFixedElement(XMLWriter writer, String facetName) {
        writer.startElement(ELT_FIXED);
        writer.addAttribute(ATTR_FACET, facetName);
        writer.endElement();
    }

    private void writeFacetInstalledElement(XMLWriter writer, String facetName, String facetVersion) {
        writer.startElement(ELT_INSTALLED);
        writer.addAttribute(ATTR_FACET, facetName);
        writer.addAttribute(ATTR_VERSION, facetVersion);
        writer.endElement();
    }

    private void writeAdditionalProjectFacets(XMLWriter writer) {
        if (this.config.getProjectFacets() == null) {
            return;
        }
        Iterator iterator = this.config.getProjectFacets().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry facetEntry = o = iterator.next();
            writer.startElement(ELT_INSTALLED);
            writer.addAttribute(ATTR_FACET, (String)facetEntry.getKey());
            writer.addAttribute(ATTR_VERSION, (String)facetEntry.getValue());
            writer.endElement();
        }
    }
}

