/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.editor.impl;

import io.wcm.caconfig.editor.ConfigurationCategory;
import io.wcm.caconfig.editor.ConfigurationCategoryProvider;
import io.wcm.sling.commons.caservice.ContextAwareServiceCollectionResolver;
import io.wcm.sling.commons.caservice.ContextAwareServiceResolver;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.spi.metadata.ConfigurationMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.FieldOption;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={ConfigurationCategoryProviderService.class})
public class ConfigurationCategoryProviderService {
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, fieldOption=FieldOption.UPDATE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private SortedSet<ServiceReference<ConfigurationCategoryProvider>> filters = new ConcurrentSkipListSet(Collections.reverseOrder());
    @Reference
    private ContextAwareServiceResolver serviceResolver;
    private ContextAwareServiceCollectionResolver<ConfigurationCategoryProvider, Void> serviceCollectionResolver;

    @Activate
    private void activate() {
        this.serviceCollectionResolver = this.serviceResolver.getCollectionResolver(this.filters);
    }

    @Deactivate
    private void deactivate() {
        this.serviceCollectionResolver.close();
    }

    @Nullable
    public ConfigurationCategory getCategory(@NotNull Resource contextResource, @NotNull ConfigurationMetadata configurationMetadata) {
        String category = this.getCategoryName(contextResource, configurationMetadata);
        if (category == null) {
            return null;
        }
        return this.getCategoryMetadata(contextResource, category);
    }

    @Nullable
    private String getCategoryName(@NotNull Resource contextResource, @NotNull ConfigurationMetadata configurationMetadata) {
        String category = ConfigurationCategoryProviderService.getPropertiesString(configurationMetadata.getProperties(), "category");
        if (StringUtils.isEmpty((CharSequence)category)) {
            category = this.serviceCollectionResolver.resolveAll((Adaptable)contextResource).map(provider -> provider.getCategory(configurationMetadata)).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return category;
    }

    @NotNull
    private ConfigurationCategory getCategoryMetadata(@NotNull Resource contextResource, @NotNull String category) {
        return this.serviceCollectionResolver.resolveAll((Adaptable)contextResource).map(provider -> provider.getCategoryMetadata(category)).filter(Objects::nonNull).findFirst().orElse(new ConfigurationCategory(category));
    }

    @Nullable
    static final ConfigurationCategory getAssignedCategory(@NotNull ConfigurationMetadata configurationMetadata) {
        String category = ConfigurationCategoryProviderService.getPropertiesString(configurationMetadata.getProperties(), "category");
        if (StringUtils.isNotEmpty((CharSequence)category)) {
            return new ConfigurationCategory(category);
        }
        return null;
    }

    private static String getPropertiesString(Map<String, String> properties, String key) {
        if (properties == null) {
            return null;
        }
        return properties.get(key);
    }
}

