/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.editor.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.wcm.caconfig.editor.impl.EditorConfig;
import io.wcm.caconfig.editor.impl.JsonMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Function;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.caconfig.management.ConfigurationManager;
import org.apache.sling.caconfig.spi.ConfigurationCollectionPersistData;
import org.apache.sling.caconfig.spi.ConfigurationPersistData;
import org.apache.sling.caconfig.spi.ConfigurationPersistenceAccessDeniedException;
import org.apache.sling.caconfig.spi.ConfigurationPersistenceException;
import org.apache.sling.caconfig.spi.metadata.ConfigurationMetadata;
import org.apache.sling.caconfig.spi.metadata.PropertyMetadata;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceTypes={"/apps/wcm-io/caconfig/editor/components/page/editor"}, selectors={"configPersist"}, extensions={"json"}, methods={"POST", "DELETE"})
public class ConfigPersistServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 1L;
    public static final String SELECTOR = "configPersist";
    @Reference
    private ConfigurationManager configManager;
    @Reference
    private EditorConfig editorConfig;
    private static Logger log = LoggerFactory.getLogger(ConfigPersistServlet.class);

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if (!this.editorConfig.isEnabled()) {
            this.sendForbiddenWithMessage(response, "Configuration editor is disabled.");
            return;
        }
        String configName = request.getParameter("configName");
        if (StringUtils.isBlank((CharSequence)configName)) {
            response.sendError(404);
            return;
        }
        boolean collection = BooleanUtils.toBoolean((String)request.getParameter("collection"));
        ConfigurationMetadata configMetadata = this.configManager.getConfigurationMetadata(configName);
        if (configMetadata != null && configMetadata.isCollection() != collection) {
            response.sendError(400, "Collection parameter mismatch.");
            return;
        }
        ConfigurationPersistData persistData = null;
        ConfigurationCollectionPersistData collectionPersistData = null;
        try {
            String jsonDataString = IOUtils.toString((InputStream)request.getInputStream(), (Charset)StandardCharsets.UTF_8);
            JsonNode jsonData = JsonMapper.OBJECT_MAPPER.readTree(jsonDataString);
            if (collection) {
                collectionPersistData = this.parseCollectionConfigData(jsonData, configMetadata);
            } else {
                persistData = this.parseConfigData(jsonData, configMetadata);
            }
        }
        catch (IOException ex) {
            response.sendError(400, "Invalid JSON data: " + ex.getMessage());
            return;
        }
        try {
            if (collection) {
                this.configManager.persistConfigurationCollection(request.getResource(), configName, collectionPersistData);
            } else {
                this.configManager.persistConfiguration(request.getResource(), configName, persistData);
            }
        }
        catch (ConfigurationPersistenceAccessDeniedException ex) {
            this.sendForbiddenWithMessage(response, ex.getMessage());
        }
        catch (ConfigurationPersistenceException ex) {
            log.warn("Unable to persist data for " + configName + (collection ? "[col]" : ""), (Throwable)ex);
            response.sendError(500, "Unable to persist data: " + ex.getMessage());
        }
        catch (Exception ex) {
            log.error("Error getting configuration for " + configName + (collection ? "[col]" : ""), (Throwable)ex);
            response.sendError(500, ex.getMessage());
        }
    }

    private ConfigurationCollectionPersistData parseCollectionConfigData(JsonNode jsonData, ConfigurationMetadata configMetadata) {
        ArrayList<ConfigurationPersistData> items = new ArrayList<ConfigurationPersistData>();
        ArrayNode itemsObject = (ArrayNode)jsonData.get("items");
        for (int i = 0; i < itemsObject.size(); ++i) {
            JsonNode item = itemsObject.get(i);
            items.add(this.parseConfigData(item, configMetadata));
        }
        HashMap<String, Object> properties = null;
        JsonNode propertiesObject = jsonData.get("properties");
        if (propertiesObject != null) {
            properties = new HashMap<String, Object>();
            Iterator propertyNames = propertiesObject.fieldNames();
            while (propertyNames.hasNext()) {
                String propertyName = (String)propertyNames.next();
                properties.put(propertyName, this.toSingle(propertiesObject.get(propertyName)));
            }
        }
        return new ConfigurationCollectionPersistData(items).properties(properties);
    }

    private ConfigurationPersistData parseConfigData(JsonNode item, ConfigurationMetadata configMetadata) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        JsonNode properties = item.get("properties");
        Iterator propertyNames = properties.fieldNames();
        while (propertyNames.hasNext()) {
            JsonNode value;
            PropertyMetadata propertyMetadata;
            String propertyName = (String)propertyNames.next();
            Class<?> propertyType = null;
            boolean isArray = false;
            if (configMetadata != null && (propertyMetadata = (PropertyMetadata)configMetadata.getPropertyMetadata().get(propertyName)) != null) {
                isArray = propertyMetadata.getType().isArray();
                propertyType = isArray ? propertyMetadata.getType().getComponentType() : propertyMetadata.getType();
            }
            if (propertyType == ConfigurationMetadata.class || !properties.hasNonNull(propertyName)) continue;
            if (propertyType == null) {
                value = properties.get(propertyName);
                if (value.isArray()) {
                    JsonNode firstValue;
                    ArrayNode arrayValue = (ArrayNode)value;
                    if (arrayValue.size() == 0) {
                        props.put(propertyName, ArrayUtils.EMPTY_STRING_ARRAY);
                    }
                    if ((firstValue = arrayValue.get(0)).canConvertToInt()) {
                        props.put(propertyName, this.toArray(arrayValue, Integer.TYPE));
                        continue;
                    }
                    if (firstValue.canConvertToLong()) {
                        props.put(propertyName, this.toArray(arrayValue, Long.TYPE));
                        continue;
                    }
                    if (firstValue.isDouble()) {
                        props.put(propertyName, this.toArray(arrayValue, Double.TYPE));
                        continue;
                    }
                    if (firstValue.isBoolean()) {
                        props.put(propertyName, this.toArray(arrayValue, Boolean.TYPE));
                        continue;
                    }
                    if (!firstValue.isTextual()) continue;
                    props.put(propertyName, this.toArray(arrayValue, String.class));
                    continue;
                }
                props.put(propertyName, this.toSingle(value));
                continue;
            }
            if (isArray) {
                value = properties.get(propertyName);
                if (!value.isArray()) continue;
                props.put(propertyName, this.toArray((ArrayNode)value, propertyType));
                continue;
            }
            value = properties.get(propertyName);
            props.put(propertyName, this.toSingle(value, propertyType));
        }
        String collectionItemName = null;
        if (configMetadata != null && configMetadata.isCollection()) {
            collectionItemName = item.get("collectionItemName").textValue();
        }
        return new ConfigurationPersistData(props).collectionItemName(collectionItemName);
    }

    private Object toSingle(@NotNull JsonNode value, @NotNull Class<?> propertyType) {
        if (propertyType.equals(String.class)) {
            return this.toString(value);
        }
        if (propertyType.equals(Integer.TYPE)) {
            return this.toInt(value);
        }
        if (propertyType.equals(Long.TYPE)) {
            return this.toLong(value);
        }
        if (propertyType.equals(Double.TYPE)) {
            return this.toDouble(value);
        }
        if (propertyType.equals(Boolean.TYPE)) {
            return this.toBoolean(value);
        }
        throw new IllegalArgumentException("Unexpected type: " + propertyType.getName());
    }

    @Nullable
    private Object toSingle(@NotNull JsonNode value) {
        if (value.isTextual()) {
            return value.asText();
        }
        if (value.canConvertToInt()) {
            return value.asInt();
        }
        if (value.canConvertToLong()) {
            return value.asLong();
        }
        if (value.isDouble()) {
            return value.doubleValue();
        }
        if (value.isBoolean()) {
            return value.booleanValue();
        }
        if (log.isTraceEnabled()) {
            log.trace("Value '{}' has unexpected type: {}", (Object)value, (Object)value.getClass().getName());
        }
        return null;
    }

    @NotNull
    private Object toArray(@NotNull ArrayNode array, @NotNull Class<?> propertyType) {
        if (propertyType.equals(String.class)) {
            String[] values = new String[array.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.toString(array.get(i));
            }
            return values;
        }
        if (propertyType.equals(Integer.TYPE)) {
            int[] values = new int[array.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.toInt(array.get(i));
            }
            return values;
        }
        if (propertyType.equals(Long.TYPE)) {
            long[] values = new long[array.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.toLong(array.get(i));
            }
            return values;
        }
        if (propertyType.equals(Double.TYPE)) {
            double[] values = new double[array.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.toDouble(array.get(i));
            }
            return values;
        }
        if (propertyType.equals(Boolean.TYPE)) {
            boolean[] values = new boolean[array.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.toBoolean(array.get(i));
            }
            return values;
        }
        throw new IllegalArgumentException("Unexpected type: " + propertyType.getName());
    }

    @Nullable
    private String toString(@NotNull JsonNode value) {
        return value.textValue();
    }

    private int toInt(@NotNull JsonNode value) {
        if (value.isTextual()) {
            return this.parseNumericTextValue(value, Integer::parseInt, 0);
        }
        return value.intValue();
    }

    private long toLong(@NotNull JsonNode value) {
        if (value.isTextual()) {
            return this.parseNumericTextValue(value, Long::parseLong, 0L);
        }
        return value.longValue();
    }

    private double toDouble(@NotNull JsonNode value) {
        if (value.isTextual()) {
            return this.parseNumericTextValue(value, Double::parseDouble, 0.0);
        }
        return value.doubleValue();
    }

    private boolean toBoolean(@NotNull JsonNode value) {
        if (value.isTextual()) {
            return Boolean.parseBoolean(value.textValue());
        }
        return value.booleanValue();
    }

    @NotNull
    private <T> T parseNumericTextValue(@NotNull JsonNode value, @NotNull Function<String, T> converter, @NotNull T defaultValue) {
        String textValue = StringUtils.trimToNull((String)value.textValue());
        if (textValue != null) {
            try {
                return converter.apply(textValue);
            }
            catch (NumberFormatException ex) {
                log.trace("Unable to parse numeric value: {}", (Object)textValue);
            }
        }
        return defaultValue;
    }

    protected void doDelete(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        String configName = request.getParameter("configName");
        if (StringUtils.isBlank((CharSequence)configName)) {
            response.sendError(404);
            return;
        }
        try {
            this.configManager.deleteConfiguration(request.getResource(), configName);
        }
        catch (ConfigurationPersistenceAccessDeniedException ex) {
            this.sendForbiddenWithMessage(response, ex.getMessage());
        }
        catch (ConfigurationPersistenceException ex) {
            log.warn("Unable to delete data for " + configName, (Throwable)ex);
            response.sendError(500, "Unable to delete data: " + ex.getMessage());
        }
        catch (Exception ex) {
            log.error("Error deleting configuration for " + configName, (Throwable)ex);
            response.sendError(500, ex.getMessage());
        }
    }

    private void sendForbiddenWithMessage(SlingHttpServletResponse response, String message) throws IOException {
        response.setContentType("text/plain;charset=" + StandardCharsets.UTF_8.name());
        response.getWriter().write(message);
        response.setStatus(403);
    }
}

