/*
 * #%L
 * wcm.io
 * %%
 * Copyright (C) 2016 wcm.io
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package io.wcm.caconfig.editor.impl;

import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

/**
 * Editor configuration
 */
@Component(service = EditorConfig.class)
@Designate(ocd = EditorConfig.Config.class)
public class EditorConfig {

  @ObjectClassDefinition(name = "wcm.io Context-Aware Configuration Editor",
      description = "Configure the Editor for Apache Sling Context-Aware Configuration.")
  @interface Config {

    @AttributeDefinition(description = "Enable the Configuration Editor and HTTP APIs.")
    boolean enabled() default true;

  }

  private boolean enabled;

  @Activate
  private void activate(Config config) {
    this.enabled = config.enabled();
  }

  public boolean isEnabled() {
    return this.enabled;
  }

}
