/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.editor.impl;

import io.wcm.caconfig.editor.ConfigurationCategory;
import io.wcm.caconfig.editor.impl.ConfigurationCategoryProviderService;
import io.wcm.caconfig.editor.impl.ConfigurationEditorFilterService;
import io.wcm.caconfig.editor.impl.EditorConfig;
import io.wcm.caconfig.editor.impl.JsonMapper;
import io.wcm.caconfig.editor.impl.data.confignames.ConfigCategoryItem;
import io.wcm.caconfig.editor.impl.data.confignames.ConfigNameItem;
import io.wcm.caconfig.editor.impl.data.confignames.ConfigNamesResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.caconfig.management.ConfigurationData;
import org.apache.sling.caconfig.management.ConfigurationManager;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.apache.sling.caconfig.spi.metadata.ConfigurationMetadata;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceTypes={"/apps/wcm-io/caconfig/editor/components/page/editor"}, selectors={"configNames"}, extensions={"json"}, methods={"GET"})
public class ConfigNamesServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1L;
    public static final String SELECTOR = "configNames";
    @Reference
    private ConfigurationManager configManager;
    @Reference
    private ConfigurationResourceResolver configurationResourceResolver;
    @Reference
    private EditorConfig editorConfig;
    @Reference(policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    private ConfigurationEditorFilterService configurationEditorFilterService;
    @Reference(policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    private ConfigurationCategoryProviderService configurationCategoryProviderService;

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        if (!this.editorConfig.isEnabled()) {
            response.sendError(403);
            return;
        }
        Resource contextResource = request.getResource();
        ConfigNamesResponse result = new ConfigNamesResponse();
        result.setContextPath(this.getContextPath(contextResource));
        result.setConfigNames(this.getConfigNames(contextResource));
        result.setConfigCategories(this.getCategories(result.getConfigNames()));
        response.setContentType("application/json;charset=" + StandardCharsets.UTF_8.name());
        response.getWriter().write(JsonMapper.OBJECT_MAPPER.writeValueAsString((Object)result));
    }

    private String getContextPath(Resource contextResource) {
        return this.configurationResourceResolver.getContextPath(contextResource);
    }

    private Collection<ConfigNameItem> getConfigNames(Resource contextResource) {
        SortedSet configNames = this.configManager.getConfigurationNames();
        TreeSet<ConfigNameItem> sortedResult = new TreeSet<ConfigNameItem>((o1, o2) -> {
            String label2;
            String label1 = o1.getLabel();
            if (StringUtils.equals((CharSequence)label1, (CharSequence)(label2 = o2.getLabel()))) {
                String configName1 = o1.getConfigName();
                String configName2 = o2.getConfigName();
                return configName1.compareTo(configName2);
            }
            return label1.compareTo(label2);
        });
        for (String configName : configNames) {
            ConfigurationMetadata metadata = this.configManager.getConfigurationMetadata(configName);
            if (metadata == null) continue;
            ConfigNameItem item = new ConfigNameItem();
            item.setConfigName(configName);
            item.setLabel(metadata.getLabel());
            item.setDescription(metadata.getDescription());
            item.setConfigurationCategory(this.getConfigurationCategory(contextResource, metadata));
            item.setCollection(metadata.isCollection());
            ConfigurationState state = this.getConfigurationState(contextResource, configName, metadata.isCollection());
            item.setExists(state.exists);
            item.setInherited(state.inherited);
            item.setOverridden(state.overridden);
            item.setAllowAdd(this.allowAdd(contextResource, configName));
            sortedResult.add(item);
        }
        return sortedResult;
    }

    @Nullable
    private ConfigurationCategory getConfigurationCategory(Resource contextResource, ConfigurationMetadata metadata) {
        if (this.configurationCategoryProviderService == null) {
            return ConfigurationCategoryProviderService.getAssignedCategory(metadata);
        }
        return this.configurationCategoryProviderService.getCategory(contextResource, metadata);
    }

    private Collection<ConfigCategoryItem> getCategories(Collection<ConfigNameItem> configNames) {
        return configNames.stream().map(ConfigNameItem::getConfigurationCategory).filter(Objects::nonNull).distinct().sorted().map(category -> new ConfigCategoryItem(category.getCategory(), category.getLabel())).collect(Collectors.toList());
    }

    private boolean allowAdd(Resource contextResource, String configName) {
        if (this.configurationEditorFilterService == null) {
            return true;
        }
        return this.configurationEditorFilterService.allowAdd(contextResource, configName);
    }

    private ConfigurationState getConfigurationState(Resource contextResource, String configName, boolean collection) {
        ConfigurationState result = new ConfigurationState();
        if (collection) {
            Collection configs = this.configManager.getConfigurationCollection(contextResource, configName).getItems();
            result.exists = !configs.isEmpty();
            result.inherited = configs.stream().anyMatch(ConfigurationData::isInherited);
            result.overridden = configs.stream().anyMatch(ConfigurationData::isOverridden);
        } else {
            ConfigurationData config = this.configManager.getConfiguration(contextResource, configName);
            if (config != null) {
                result.exists = config.getResourcePath() != null || config.isOverridden();
                result.inherited = config.isInherited();
                result.overridden = config.isOverridden();
            }
        }
        return result;
    }

    private static final class ConfigurationState {
        private boolean exists;
        private boolean inherited;
        private boolean overridden;

        private ConfigurationState() {
        }
    }
}

