/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.editor.model;

import com.day.cq.wcm.api.components.ComponentManager;
import io.wcm.caconfig.editor.impl.EditorConfig;
import javax.annotation.PostConstruct;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={HttpServletRequest.class})
@ProviderType
public class EditorConfiguration {
    static final String RT_WCMIO_PATHFIELD = "wcm-io/wcm/ui/granite/components/form/pathfield";
    static final String PATH_PATHFIELD_STANDARD = "/mnt/overlay/granite/ui/content/coral/foundation/form/pathfield";
    static final String PATH_PATHFIELD_WCMIO = "/mnt/overlay/wcm-io/wcm/ui/granite/content/form/pathfield";
    static final String PATH_TAGFIELD_CQ = "/mnt/overlay/cq/gui/content/coral/common/form/tagfield";
    private static final Logger log = LoggerFactory.getLogger(EditorConfiguration.class);
    @SlingObject
    private Resource currentResource;
    @SlingObject
    private SlingHttpServletRequest request;
    @OSGiService
    private ConfigurationResourceResolver configResourceResolver;
    @OSGiService
    private EditorConfig editorConfig;
    private String servletContextPathPrefix;
    private String configNamesUrl;
    private String configDataUrl;
    private String configPersistUrl;
    private String contextPath;
    private String pathfieldContentPath;
    private String tagfieldContentPath;
    private String language;
    private boolean enabled;
    private boolean canReplicate;

    @PostConstruct
    private void activate() {
        this.servletContextPathPrefix = StringUtils.defaultString((String)this.request.getContextPath());
        if (StringUtils.equals((CharSequence)this.servletContextPathPrefix, (CharSequence)"/")) {
            this.servletContextPathPrefix = "";
        }
        this.configNamesUrl = this.buildServletPath("configNames");
        this.configDataUrl = this.buildServletPath("configData");
        this.configPersistUrl = this.buildServletPath("configPersist");
        this.contextPath = this.configResourceResolver.getContextPath(this.currentResource);
        this.pathfieldContentPath = this.buildPathfieldContentPath();
        this.tagfieldContentPath = this.buildTagfieldContentPath();
        this.language = this.request.getLocale().getLanguage();
        this.enabled = this.editorConfig.isEnabled();
        this.canReplicate = this.hasPermission("{http://www.day.com/crx/1.0}replicate");
    }

    private String buildServletPath(String selector) {
        return this.servletContextPathPrefix + this.currentResource.getPath() + "." + selector + ".json";
    }

    private String buildPathfieldContentPath() {
        ComponentManager componentManager = (ComponentManager)this.request.getResourceResolver().adaptTo(ComponentManager.class);
        if (componentManager != null && componentManager.getComponent(RT_WCMIO_PATHFIELD) != null) {
            return this.servletContextPathPrefix + PATH_PATHFIELD_WCMIO;
        }
        return this.servletContextPathPrefix + PATH_PATHFIELD_STANDARD;
    }

    private boolean hasPermission(String privilegeName) {
        Session session = (Session)this.request.getResourceResolver().adaptTo(Session.class);
        if (session != null) {
            try {
                AccessControlManager accessControlManager = session.getAccessControlManager();
                Privilege privilege = accessControlManager.privilegeFromName(privilegeName);
                return accessControlManager.hasPrivileges(this.currentResource.getPath(), new Privilege[]{privilege});
            }
            catch (RepositoryException ex) {
                log.warn("Failed to check permission for {}", (Object)this.currentResource.getPath(), (Object)ex);
            }
        }
        return false;
    }

    private String buildTagfieldContentPath() {
        return this.servletContextPathPrefix + PATH_TAGFIELD_CQ;
    }

    public String getServletContextPathPrefix() {
        return this.servletContextPathPrefix;
    }

    public String getConfigNamesUrl() {
        return this.configNamesUrl;
    }

    public String getConfigDataUrl() {
        return this.configDataUrl;
    }

    public String getConfigPersistUrl() {
        return this.configPersistUrl;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getPathfieldContentPath() {
        return this.pathfieldContentPath;
    }

    public String getTagfieldContentPath() {
        return this.tagfieldContentPath;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isCanReplicate() {
        return this.canReplicate;
    }
}

