/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.editor.impl;

import io.wcm.caconfig.editor.impl.DropdownOptionProviderService;
import io.wcm.caconfig.editor.impl.JsonMapper;
import io.wcm.caconfig.editor.impl.PathBrowserRootPathProviderService;
import io.wcm.caconfig.editor.impl.TagBrowserRootPathProviderService;
import io.wcm.caconfig.editor.impl.data.configdata.ConfigCollectionItem;
import io.wcm.caconfig.editor.impl.data.configdata.ConfigItem;
import io.wcm.caconfig.editor.impl.data.configdata.PropertyItem;
import io.wcm.caconfig.editor.impl.data.configdata.PropertyItemMetadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.management.ConfigurationCollectionData;
import org.apache.sling.caconfig.management.ConfigurationData;
import org.apache.sling.caconfig.management.ConfigurationManager;
import org.apache.sling.caconfig.management.ValueInfo;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationPersistenceStrategyMultiplexer;
import org.apache.sling.caconfig.spi.ConfigurationPersistenceException;
import org.apache.sling.caconfig.spi.metadata.PropertyMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigDataResponseGenerator {
    private static final Pattern JSON_STRING_ARRAY_PATTERN = Pattern.compile("^\\[.*\\]$");
    private static final Pattern JSON_STRING_OBJECT_PATTERN = Pattern.compile("^\\{.*\\}$");
    private final ConfigurationManager configManager;
    private final ConfigurationPersistenceStrategyMultiplexer configurationPersistenceStrategy;
    private final DropdownOptionProviderService dropdownOptionProviderService;
    private final PathBrowserRootPathProviderService pathBrowserRootPathProviderService;
    private final TagBrowserRootPathProviderService tagBrowserRootPathProviderService;
    private AccessControlManager accessControlManager;
    private Privilege jcrWritePrivilege;
    private static Logger log = LoggerFactory.getLogger(ConfigDataResponseGenerator.class);

    ConfigDataResponseGenerator(@NotNull SlingHttpServletRequest request, @NotNull ConfigurationManager configManager, @NotNull ConfigurationPersistenceStrategyMultiplexer configurationPersistenceStrategy, @NotNull DropdownOptionProviderService dropdownOptionProviderService, @NotNull PathBrowserRootPathProviderService pathBrowserRootPathProviderService, @NotNull TagBrowserRootPathProviderService tagBrowserRootPathProviderService) {
        this.configManager = configManager;
        this.configurationPersistenceStrategy = configurationPersistenceStrategy;
        this.dropdownOptionProviderService = dropdownOptionProviderService;
        this.pathBrowserRootPathProviderService = pathBrowserRootPathProviderService;
        this.tagBrowserRootPathProviderService = tagBrowserRootPathProviderService;
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        if (session != null) {
            try {
                this.accessControlManager = session.getAccessControlManager();
                this.jcrWritePrivilege = this.accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}write");
            }
            catch (RepositoryException ex) {
                log.warn("Unable to prepare JCR AccessControlManager.", (Throwable)ex);
            }
        }
    }

    Object getConfiguration(@NotNull Resource contextResource, String configName, boolean collection) {
        Object result;
        if (collection) {
            ConfigurationData newItem = this.configManager.newCollectionItem(contextResource, configName);
            if (newItem == null) {
                throw new ConfigurationPersistenceException("Invalid configuration name: " + configName);
            }
            result = this.fromConfigCollection(contextResource, this.configManager.getConfigurationCollection(contextResource, configName), newItem, configName);
        } else {
            ConfigurationData configData = this.configManager.getConfiguration(contextResource, configName);
            result = configData != null ? this.fromConfig(contextResource, configData, configData.isInherited(), configName) : null;
        }
        return result;
    }

    private ConfigCollectionItem fromConfigCollection(@NotNull Resource contextResource, ConfigurationCollectionData configCollection, ConfigurationData newItem, String fullConfigName) {
        ConfigCollectionItem result = new ConfigCollectionItem();
        result.setConfigName(configCollection.getConfigName());
        result.setConfigSourcePath(configCollection.getResourcePath());
        result.setReadOnly(this.isReadOnly(configCollection.getResourcePath(), false));
        if (!configCollection.getProperties().isEmpty()) {
            TreeMap<String, Object> properties = new TreeMap<String, Object>();
            for (Map.Entry entry : configCollection.getProperties().entrySet()) {
                properties.put((String)entry.getKey(), entry.getValue());
            }
            result.setProperties(properties);
        }
        ArrayList<ConfigItem> items = new ArrayList<ConfigItem>();
        for (ConfigurationData configurationData : configCollection.getItems()) {
            items.add(this.fromConfig(contextResource, configurationData, configurationData.isInherited(), fullConfigName));
        }
        result.setItems(items);
        result.setNewItem(this.fromConfig(contextResource, newItem, null, fullConfigName));
        return result;
    }

    private ConfigItem fromConfig(@NotNull Resource contextResource, ConfigurationData config, Boolean inherited, String fullConfigName) {
        ConfigItem result = new ConfigItem();
        result.setConfigName(config.getConfigName());
        result.setCollectionItemName(config.getCollectionItemName());
        result.setOverridden(config.isOverridden());
        result.setInherited(inherited);
        result.setConfigSourcePath(config.getResourcePath());
        result.setReadOnly(this.isReadOnly(config.getResourcePath(), config.isOverridden()));
        ArrayList<PropertyItem> props = new ArrayList<PropertyItem>();
        for (String propertyName : config.getPropertyNames()) {
            PropertyItemMetadata metadata;
            ValueInfo item = config.getValueInfo(propertyName);
            if (item == null) continue;
            PropertyMetadata itemMetadata = item.getPropertyMetadata();
            PropertyItem prop = new PropertyItem();
            prop.setName(item.getName());
            if (itemMetadata != null && itemMetadata.isNestedConfiguration()) {
                metadata = new PropertyItemMetadata();
                metadata.setLabel(itemMetadata.getLabel());
                metadata.setDescription(itemMetadata.getDescription());
                metadata.setProperties(this.toJsonWithValueConversion(itemMetadata.getProperties(), contextResource));
                prop.setMetadata(metadata);
                if (itemMetadata.getType().isArray()) {
                    ConfigurationData[] configDatas = (ConfigurationData[])item.getValue();
                    if (configDatas != null) {
                        ConfigCollectionItem nestedConfigCollection = new ConfigCollectionItem();
                        StringBuilder collectionConfigName = new StringBuilder();
                        if (config.getCollectionItemName() != null) {
                            collectionConfigName.append(this.configurationPersistenceStrategy.getCollectionItemConfigName(fullConfigName + "/" + config.getCollectionItemName(), config.getResourcePath()));
                        } else {
                            collectionConfigName.append(this.configurationPersistenceStrategy.getConfigName(fullConfigName, config.getResourcePath()));
                        }
                        collectionConfigName.append("/").append(itemMetadata.getConfigurationMetadata().getName());
                        nestedConfigCollection.setConfigName(collectionConfigName.toString());
                        ArrayList<ConfigItem> items = new ArrayList<ConfigItem>();
                        for (ConfigurationData configData : configDatas) {
                            items.add(this.fromConfig(contextResource, configData, false, collectionConfigName.toString()));
                        }
                        nestedConfigCollection.setItems(items);
                        prop.setNestedConfigCollection(nestedConfigCollection);
                    }
                } else {
                    ConfigurationData configData = (ConfigurationData)item.getValue();
                    if (configData != null) {
                        prop.setNestedConfig(this.fromConfig(contextResource, configData, null, fullConfigName + "/" + itemMetadata.getConfigurationMetadata().getName()));
                    }
                }
            } else {
                prop.setValue(item.getValue());
                prop.setEffectiveValue(item.getEffectiveValue());
                prop.setConfigSourcePath(item.getConfigSourcePath());
                prop.setIsDefault(item.isDefault());
                prop.setInherited(item.isInherited());
                prop.setOverridden(item.isOverridden());
                prop.setReadOnly(result.getReadOnly());
                if (itemMetadata != null) {
                    metadata = new PropertyItemMetadata();
                    if (itemMetadata.getType().isArray()) {
                        metadata.setType(ClassUtils.primitiveToWrapper(itemMetadata.getType().getComponentType()).getSimpleName());
                        metadata.setMultivalue(true);
                    } else {
                        metadata.setType(ClassUtils.primitiveToWrapper((Class)itemMetadata.getType()).getSimpleName());
                    }
                    metadata.setDefaultValue(itemMetadata.getDefaultValue());
                    metadata.setLabel(itemMetadata.getLabel());
                    metadata.setDescription(itemMetadata.getDescription());
                    metadata.setProperties(this.toJsonWithValueConversion(itemMetadata.getProperties(), contextResource));
                    prop.setMetadata(metadata);
                }
            }
            props.add(prop);
        }
        result.setProperties(props);
        return result;
    }

    @Nullable
    private Map<String, Object> toJsonWithValueConversion(@Nullable Map<String, String> properties, @NotNull Resource contextResource) {
        Optional<String> dynamicProvider;
        boolean isTagBrowser;
        Optional<String> dynamicProvider2;
        boolean isPathBrowser;
        Optional<String> dynamicProvider3;
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        TreeMap<String, Object> metadataProps = new TreeMap<String, Object>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            metadataProps.put(entry.getKey(), this.tryConvertJsonString(entry.getValue()));
        }
        boolean isDropdown = "dropdown".equals(metadataProps.get("widgetType"));
        if (isDropdown && (dynamicProvider3 = Optional.ofNullable(metadataProps.get("dropdownOptionsProvider")).filter(Objects::nonNull).map(String::valueOf).filter(StringUtils::isNotBlank)).isPresent()) {
            List<Map<String, Object>> items = this.dropdownOptionProviderService.getDropdownOptions(dynamicProvider3.get(), contextResource);
            if (!items.isEmpty()) {
                metadataProps.put("dropdownOptions", items);
            }
            metadataProps.remove("dropdownOptionsProvider");
        }
        if ((isPathBrowser = "pathbrowser".equals(metadataProps.get("widgetType"))) && (dynamicProvider2 = Optional.ofNullable(metadataProps.get("pathbrowserRootPathProvider")).filter(Objects::nonNull).map(String::valueOf).filter(StringUtils::isNotBlank)).isPresent()) {
            String rootPath = this.pathBrowserRootPathProviderService.getRootPath(dynamicProvider2.get(), contextResource);
            if (rootPath != null) {
                metadataProps.put("pathbrowserRootPath", rootPath);
            }
            metadataProps.remove("pathbrowserRootPathProvider");
        }
        if ((isTagBrowser = "tagbrowser".equals(metadataProps.get("widgetType"))) && (dynamicProvider = Optional.ofNullable(metadataProps.get("tagbrowserRootPathProvider")).filter(Objects::nonNull).map(String::valueOf).filter(StringUtils::isNotBlank)).isPresent()) {
            String rootPath = this.tagBrowserRootPathProviderService.getRootPath(dynamicProvider.get(), contextResource);
            if (rootPath != null) {
                metadataProps.put("tagbrowserRootPath", rootPath);
            }
            metadataProps.remove("tagbrowserRootPathProvider");
        }
        return metadataProps;
    }

    @Nullable
    private Object tryConvertJsonString(@Nullable String value) {
        if (value == null) {
            return null;
        }
        if (JSON_STRING_ARRAY_PATTERN.matcher(value).matches()) {
            try {
                return JsonMapper.OBJECT_MAPPER.readValue(value, List.class);
            }
            catch (IOException ex) {
                log.trace("Conversion to JSON array value failed for: {}", (Object)value, (Object)ex);
            }
        }
        if (JSON_STRING_OBJECT_PATTERN.matcher(value).matches()) {
            try {
                return JsonMapper.OBJECT_MAPPER.readValue(value, Map.class);
            }
            catch (IOException ex) {
                log.trace("Conversion to JSON object value failed for: {}", (Object)value, (Object)ex);
            }
        }
        return value;
    }

    @Nullable
    private Boolean isReadOnly(@Nullable String resourcePath, boolean isOverridden) {
        if (this.accessControlManager != null && this.jcrWritePrivilege != null) {
            try {
                if (isOverridden) {
                    return true;
                }
                if (resourcePath != null) {
                    return !this.accessControlManager.hasPrivileges(resourcePath, new Privilege[]{this.jcrWritePrivilege});
                }
            }
            catch (RepositoryException ex) {
                log.warn("Unable to check JCR write privilege for resource: {}", (Object)resourcePath, (Object)ex);
            }
        }
        return null;
    }
}

