/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.editor.impl;

import io.wcm.caconfig.editor.impl.ConfigDataResponseGenerator;
import io.wcm.caconfig.editor.impl.DropdownOptionProviderService;
import io.wcm.caconfig.editor.impl.EditorConfig;
import io.wcm.caconfig.editor.impl.JsonMapper;
import io.wcm.caconfig.editor.impl.PathBrowserRootPathProviderService;
import io.wcm.caconfig.editor.impl.TagBrowserRootPathProviderService;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.caconfig.management.ConfigurationManager;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationPersistenceStrategyMultiplexer;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceTypes={"/apps/wcm-io/caconfig/editor/components/page/editor"}, selectors={"configData"}, extensions={"json"}, methods={"GET"})
public class ConfigDataServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1L;
    public static final String SELECTOR = "configData";
    @Reference
    private ConfigurationManager configManager;
    @Reference
    private ConfigurationPersistenceStrategyMultiplexer configurationPersistenceStrategy;
    @Reference
    private EditorConfig editorConfig;
    @Reference
    private DropdownOptionProviderService dropdownOptionProviderService;
    @Reference
    private PathBrowserRootPathProviderService pathBrowserRootPathProviderService;
    @Reference
    private TagBrowserRootPathProviderService tagBrowserRootPathProviderService;
    private static Logger log = LoggerFactory.getLogger(ConfigDataServlet.class);

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        if (!this.editorConfig.isEnabled()) {
            response.sendError(403);
            return;
        }
        String configName = request.getParameter("configName");
        if (StringUtils.isBlank((CharSequence)configName)) {
            response.sendError(404);
            return;
        }
        boolean collection = BooleanUtils.toBoolean((String)request.getParameter("collection"));
        try {
            ConfigDataResponseGenerator generator = new ConfigDataResponseGenerator(request, this.configManager, this.configurationPersistenceStrategy, this.dropdownOptionProviderService, this.pathBrowserRootPathProviderService, this.tagBrowserRootPathProviderService);
            Object result = generator.getConfiguration(request.getResource(), configName, collection);
            if (result == null) {
                response.sendError(404);
            } else {
                response.setContentType("application/json;charset=" + StandardCharsets.UTF_8.name());
                response.getWriter().write(JsonMapper.OBJECT_MAPPER.writeValueAsString(result));
            }
        }
        catch (Exception ex) {
            log.error("Error getting configuration for " + configName + (collection ? "[col]" : ""), (Throwable)ex);
            response.sendError(500, ex.getMessage());
        }
    }
}

