/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.editor.impl;

import io.wcm.caconfig.editor.impl.EditorConfig;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.caconfig.management.ConfigurationCollectionData;
import org.apache.sling.caconfig.management.ConfigurationData;
import org.apache.sling.caconfig.management.ConfigurationManager;
import org.apache.sling.caconfig.management.ValueInfo;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationPersistenceStrategyMultiplexer;
import org.apache.sling.caconfig.spi.ConfigurationPersistenceException;
import org.apache.sling.caconfig.spi.metadata.PropertyMetadata;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, immediate=true, property={"sling.servlet.resourceTypes=/apps/wcm-io/caconfig/editor/components/page/editor", "sling.servlet.extensions=json", "sling.servlet.selectors=configData", "sling.servlet.methods=GET"})
public class ConfigDataServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1L;
    public static final String SELECTOR = "configData";
    private static final Pattern JSON_STRING_ARRAY_PATTERN = Pattern.compile("^\\[.*\\]$");
    private static final Pattern JSON_STRING_OBJECT_PATTERN = Pattern.compile("^\\{.*\\}$");
    @Reference
    private ConfigurationManager configManager;
    @Reference
    private ConfigurationPersistenceStrategyMultiplexer configurationPersistenceStrategy;
    @Reference
    private EditorConfig editorConfig;
    private static Logger log = LoggerFactory.getLogger(ConfigDataServlet.class);

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        if (!this.editorConfig.isEnabled()) {
            response.sendError(403);
            return;
        }
        String configName = request.getParameter("configName");
        if (StringUtils.isBlank((CharSequence)configName)) {
            response.sendError(404);
            return;
        }
        boolean collection = BooleanUtils.toBoolean((String)request.getParameter("collection"));
        try {
            JSONObject result = this.getConfiguration(request.getResource(), configName, collection);
            if (result == null) {
                response.sendError(404);
            } else {
                response.setContentType("application/json;charset=UTF-8");
                response.getWriter().write(result.toString());
            }
        }
        catch (Exception ex) {
            log.error("Error getting configuration for " + configName + (collection ? "[col]" : ""), (Throwable)ex);
            response.sendError(500, ex.getMessage());
        }
    }

    private JSONObject getConfiguration(Resource contextResource, String configName, boolean collection) throws JSONException {
        JSONObject result;
        if (collection) {
            ConfigurationData newItem = this.configManager.newCollectionItem(contextResource, configName);
            if (newItem == null) {
                throw new ConfigurationPersistenceException("Invalid configuration name: " + configName);
            }
            result = this.toJson(this.configManager.getConfigurationCollection(contextResource, configName), newItem, configName);
        } else {
            ConfigurationData configData = this.configManager.getConfiguration(contextResource, configName);
            result = configData != null ? this.toJson(configData, configData.isInherited(), configName) : null;
        }
        return result;
    }

    private JSONObject toJson(ConfigurationCollectionData configCollection, ConfigurationData newItem, String fullConfigName) throws JSONException {
        JSONObject result = new JSONObject();
        result.putOpt("configName", (Object)configCollection.getConfigName());
        if (!configCollection.getProperties().isEmpty()) {
            JSONObject properties = new JSONObject();
            for (Map.Entry entry : configCollection.getProperties().entrySet()) {
                properties.putOpt((String)entry.getKey(), entry.getValue());
            }
            result.put("properties", (Object)properties);
        }
        JSONArray items = new JSONArray();
        for (ConfigurationData configurationData : configCollection.getItems()) {
            items.put((Object)this.toJson(configurationData, configurationData.isInherited(), fullConfigName));
        }
        result.put("items", (Object)items);
        result.put("newItem", (Object)this.toJson(newItem, null, fullConfigName));
        return result;
    }

    private JSONObject toJson(ConfigurationData config, Boolean inherited, String fullConfigName) throws JSONException {
        JSONObject result = new JSONObject();
        result.putOpt("configName", (Object)config.getConfigName());
        result.putOpt("collectionItemName", (Object)config.getCollectionItemName());
        result.putOpt("overridden", (Object)config.isOverridden());
        if (inherited != null) {
            result.put("inherited", inherited.booleanValue());
        }
        JSONArray props = new JSONArray();
        for (String propertyName : config.getPropertyNames()) {
            JSONObject metadata;
            ValueInfo item = config.getValueInfo(propertyName);
            if (item == null) continue;
            PropertyMetadata itemMetadata = item.getPropertyMetadata();
            JSONObject prop = new JSONObject();
            prop.putOpt("name", (Object)item.getName());
            if (itemMetadata != null && itemMetadata.isNestedConfiguration()) {
                metadata = new JSONObject();
                metadata.putOpt("label", (Object)itemMetadata.getLabel());
                metadata.putOpt("description", (Object)itemMetadata.getDescription());
                metadata.putOpt("properties", (Object)this.toJsonWithValueConversion(itemMetadata.getProperties()));
                prop.put("metadata", (Object)metadata);
                if (itemMetadata.getType().isArray()) {
                    ConfigurationData[] configDatas = (ConfigurationData[])item.getValue();
                    if (configDatas != null) {
                        JSONObject nestedConfigCollection = new JSONObject();
                        StringBuilder collectionConfigName = new StringBuilder();
                        if (config.getCollectionItemName() != null) {
                            collectionConfigName.append(this.configurationPersistenceStrategy.getCollectionItemConfigName(fullConfigName + "/" + config.getCollectionItemName(), config.getResourcePath()));
                        } else {
                            collectionConfigName.append(this.configurationPersistenceStrategy.getConfigName(fullConfigName, config.getResourcePath()));
                        }
                        collectionConfigName.append("/").append(itemMetadata.getConfigurationMetadata().getName());
                        nestedConfigCollection.put("configName", (Object)collectionConfigName.toString());
                        JSONArray items = new JSONArray();
                        for (ConfigurationData configData : configDatas) {
                            items.put((Object)this.toJson(configData, false, collectionConfigName.toString()));
                        }
                        nestedConfigCollection.put("items", (Object)items);
                        prop.put("nestedConfigCollection", (Object)nestedConfigCollection);
                    }
                } else {
                    ConfigurationData configData = (ConfigurationData)item.getValue();
                    if (configData != null) {
                        prop.put("nestedConfig", (Object)this.toJson(configData, null, fullConfigName + "/" + itemMetadata.getConfigurationMetadata().getName()));
                    }
                }
            } else {
                prop.putOpt("value", this.toJsonValue(item.getValue()));
                prop.putOpt("effectiveValue", this.toJsonValue(item.getEffectiveValue()));
                prop.putOpt("configSourcePath", (Object)item.getConfigSourcePath());
                prop.putOpt("default", (Object)item.isDefault());
                prop.putOpt("inherited", (Object)item.isInherited());
                prop.putOpt("overridden", (Object)item.isOverridden());
                if (itemMetadata != null) {
                    metadata = new JSONObject();
                    if (itemMetadata.getType().isArray()) {
                        metadata.put("type", (Object)ClassUtils.primitiveToWrapper(itemMetadata.getType().getComponentType()).getSimpleName());
                        metadata.put("multivalue", true);
                    } else {
                        metadata.put("type", (Object)ClassUtils.primitiveToWrapper((Class)itemMetadata.getType()).getSimpleName());
                    }
                    metadata.putOpt("defaultValue", this.toJsonValue(itemMetadata.getDefaultValue()));
                    metadata.putOpt("label", (Object)itemMetadata.getLabel());
                    metadata.putOpt("description", (Object)itemMetadata.getDescription());
                    metadata.putOpt("properties", (Object)this.toJsonWithValueConversion(itemMetadata.getProperties()));
                    prop.put("metadata", (Object)metadata);
                }
            }
            props.put((Object)prop);
        }
        result.put("properties", (Object)props);
        return result;
    }

    private JSONObject toJsonWithValueConversion(Map<String, String> properties) throws JSONException {
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        JSONObject metadataProps = new JSONObject();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            metadataProps.putOpt(entry.getKey(), this.tryConvertJsonString(entry.getValue()));
        }
        return metadataProps;
    }

    private Object tryConvertJsonString(String value) {
        if (JSON_STRING_ARRAY_PATTERN.matcher(value).matches()) {
            try {
                return new JSONArray(value);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if (JSON_STRING_OBJECT_PATTERN.matcher(value).matches()) {
            try {
                return new JSONObject(value);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return value;
    }

    private Object toJsonValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            JSONArray array = new JSONArray();
            for (int i = 0; i < Array.getLength(value); ++i) {
                array.put(Array.get(value, i));
            }
            return array;
        }
        return value;
    }
}

