/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.editor.model;

import io.wcm.caconfig.editor.impl.EditorConfig;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.osgi.annotation.versioning.ProviderType;

@Model(adaptables={HttpServletRequest.class})
@ProviderType
public class EditorConfiguration {
    @SlingObject
    private Resource currentResource;
    @SlingObject
    private SlingHttpServletRequest request;
    @OSGiService
    private ConfigurationResourceResolver configResourceResolver;
    @OSGiService
    private EditorConfig editorConfig;
    private String servletContextPathPrefix;
    private String configNamesUrl;
    private String configDataUrl;
    private String configPersistUrl;
    private String contextPath;
    private String language;
    private boolean enabled;

    @PostConstruct
    private void activate() {
        this.servletContextPathPrefix = StringUtils.defaultString((String)this.request.getContextPath());
        if (StringUtils.equals((CharSequence)this.servletContextPathPrefix, (CharSequence)"/")) {
            this.servletContextPathPrefix = "";
        }
        this.configNamesUrl = this.servletContextPathPrefix + this.currentResource.getPath() + "." + "configNames" + ".json";
        this.configDataUrl = this.servletContextPathPrefix + this.currentResource.getPath() + "." + "configData" + ".json";
        this.configPersistUrl = this.servletContextPathPrefix + this.currentResource.getPath() + "." + "configPersist" + ".json";
        this.contextPath = this.configResourceResolver.getContextPath(this.currentResource);
        this.language = this.request.getLocale().getLanguage();
        this.enabled = this.editorConfig.isEnabled();
    }

    public String getServletContextPathPrefix() {
        return this.servletContextPathPrefix;
    }

    public String getConfigNamesUrl() {
        return this.configNamesUrl;
    }

    public String getConfigDataUrl() {
        return this.configDataUrl;
    }

    public String getConfigPersistUrl() {
        return this.configPersistUrl;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

