/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.editor.impl;

import io.wcm.caconfig.editor.impl.ConfigurationEditorFilterService;
import io.wcm.caconfig.editor.impl.EditorConfig;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.caconfig.management.ConfigurationData;
import org.apache.sling.caconfig.management.ConfigurationManager;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.apache.sling.caconfig.spi.metadata.ConfigurationMetadata;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={Servlet.class}, immediate=true, property={"sling.servlet.resourceTypes=/apps/wcm-io/caconfig/editor/components/page/editor", "sling.servlet.extensions=json", "sling.servlet.selectors=configNames", "sling.servlet.methods=GET"})
public class ConfigNamesServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1L;
    public static final String SELECTOR = "configNames";
    @Reference
    private ConfigurationManager configManager;
    @Reference
    private ConfigurationResourceResolver configurationResourceResolver;
    @Reference
    private EditorConfig editorConfig;
    @Reference(policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    private ConfigurationEditorFilterService configurationEditorFilterService;

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        if (!this.editorConfig.isEnabled()) {
            response.sendError(403);
            return;
        }
        Resource contextResource = request.getResource();
        try {
            JSONObject result = new JSONObject();
            result.putOpt("contextPath", (Object)this.getContextPath(contextResource));
            result.put(SELECTOR, (Object)this.getConfigNames(contextResource));
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(result.toString());
        }
        catch (JSONException ex) {
            throw new ServletException("Unable to generate JSON.", (Throwable)ex);
        }
    }

    private String getContextPath(Resource contextResource) {
        return this.configurationResourceResolver.getContextPath(contextResource);
    }

    private JSONArray getConfigNames(Resource contextResource) throws JSONException {
        JSONArray output = new JSONArray();
        SortedSet configNames = this.configManager.getConfigurationNames();
        TreeSet<JSONObject> sortedResult = new TreeSet<JSONObject>(new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject o1, JSONObject o2) {
                String label2;
                String label1 = o1.optString("label");
                if (StringUtils.equals((CharSequence)label1, (CharSequence)(label2 = o2.optString("label")))) {
                    String configName1 = o1.optString("configName");
                    String configName2 = o2.optString("configName");
                    return configName1.compareTo(configName2);
                }
                return label1.compareTo(label2);
            }
        });
        for (String configName : configNames) {
            ConfigurationMetadata metadata = this.configManager.getConfigurationMetadata(configName);
            if (metadata == null) continue;
            JSONObject item = new JSONObject();
            item.put("configName", (Object)configName);
            item.putOpt("label", (Object)metadata.getLabel());
            item.putOpt("description", (Object)metadata.getDescription());
            item.put("collection", metadata.isCollection());
            ConfigurationState state = this.getConfigurationState(contextResource, configName, metadata.isCollection());
            item.put("exists", state.exists);
            item.put("inherited", state.inherited);
            item.put("overridden", state.overridden);
            item.put("allowAdd", this.allowAdd(contextResource, configName));
            sortedResult.add(item);
        }
        sortedResult.forEach(arg_0 -> ((JSONArray)output).put(arg_0));
        return output;
    }

    private boolean allowAdd(Resource contextResource, String configName) {
        if (this.configurationEditorFilterService == null) {
            return true;
        }
        return this.configurationEditorFilterService.allowAdd(contextResource, configName);
    }

    private ConfigurationState getConfigurationState(Resource contextResource, String configName, boolean collection) {
        ConfigurationState result = new ConfigurationState();
        if (collection) {
            Collection configs = this.configManager.getConfigurationCollection(contextResource, configName).getItems();
            result.exists = !configs.isEmpty();
            result.inherited = configs.stream().filter(ConfigurationData::isInherited).findAny().isPresent();
            result.overridden = configs.stream().filter(ConfigurationData::isOverridden).findAny().isPresent();
        } else {
            ConfigurationData config = this.configManager.getConfiguration(contextResource, configName);
            if (config != null) {
                result.exists = config.getResourcePath() != null || config.isOverridden();
                result.inherited = config.isInherited();
                result.overridden = config.isOverridden();
            }
        }
        return result;
    }

    private static final class ConfigurationState {
        private boolean exists;
        private boolean inherited;
        private boolean overridden;

        private ConfigurationState() {
        }
    }
}

