/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.editor.impl;

import io.wcm.caconfig.editor.impl.EditorConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.caconfig.management.ConfigurationManager;
import org.apache.sling.caconfig.spi.ConfigurationCollectionPersistData;
import org.apache.sling.caconfig.spi.ConfigurationPersistData;
import org.apache.sling.caconfig.spi.ConfigurationPersistenceAccessDeniedException;
import org.apache.sling.caconfig.spi.ConfigurationPersistenceException;
import org.apache.sling.caconfig.spi.metadata.ConfigurationMetadata;
import org.apache.sling.caconfig.spi.metadata.PropertyMetadata;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, immediate=true, property={"sling.servlet.resourceTypes=/apps/wcm-io/caconfig/editor/components/page/editor", "sling.servlet.extensions=json", "sling.servlet.selectors=configPersist", "sling.servlet.methods=POST", "sling.servlet.methods=DELETE"})
public class ConfigPersistServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 1L;
    public static final String SELECTOR = "configPersist";
    @Reference
    private ConfigurationManager configManager;
    @Reference
    private EditorConfig editorConfig;
    private static Logger log = LoggerFactory.getLogger(ConfigPersistServlet.class);

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if (!this.editorConfig.isEnabled()) {
            this.sendForbiddenWithMessage(response, "Configuration editor is disabled.");
            return;
        }
        String configName = request.getParameter("configName");
        if (StringUtils.isBlank((CharSequence)configName)) {
            response.sendError(404);
            return;
        }
        boolean collection = BooleanUtils.toBoolean((String)request.getParameter("collection"));
        ConfigurationMetadata configMetadata = this.configManager.getConfigurationMetadata(configName);
        if (configMetadata != null && configMetadata.isCollection() != collection) {
            response.sendError(400, "Collection parameter mismatch.");
            return;
        }
        ConfigurationPersistData persistData = null;
        ConfigurationCollectionPersistData collectionPersistData = null;
        try {
            String jsonDataString = IOUtils.toString((InputStream)request.getInputStream(), (String)"UTF-8");
            JSONObject jsonData = new JSONObject(jsonDataString);
            if (collection) {
                collectionPersistData = this.parseCollectionConfigData(jsonData, configMetadata);
            } else {
                persistData = this.parseConfigData(jsonData, configMetadata);
            }
        }
        catch (JSONException ex) {
            response.sendError(400, "Invalid JSON data: " + ex.getMessage());
            return;
        }
        try {
            if (collection) {
                this.configManager.persistConfigurationCollection(request.getResource(), configName, collectionPersistData);
            } else {
                this.configManager.persistConfiguration(request.getResource(), configName, persistData);
            }
        }
        catch (ConfigurationPersistenceAccessDeniedException ex) {
            this.sendForbiddenWithMessage(response, ex.getMessage());
        }
        catch (ConfigurationPersistenceException ex) {
            log.warn("Unable to persist data for " + configName + (collection ? "[col]" : ""), (Throwable)ex);
            response.sendError(500, "Unable to persist data: " + ex.getMessage());
        }
        catch (Exception ex) {
            log.error("Error getting configuration for " + configName + (collection ? "[col]" : ""), (Throwable)ex);
            response.sendError(500, ex.getMessage());
        }
    }

    private ConfigurationCollectionPersistData parseCollectionConfigData(JSONObject jsonData, ConfigurationMetadata configMetadata) throws JSONException {
        ArrayList<ConfigurationPersistData> items = new ArrayList<ConfigurationPersistData>();
        JSONArray itemsObject = jsonData.getJSONArray("items");
        for (int i = 0; i < itemsObject.length(); ++i) {
            JSONObject item = itemsObject.getJSONObject(i);
            items.add(this.parseConfigData(item, configMetadata));
        }
        HashMap<String, Object> properties = null;
        JSONObject propertiesObject = jsonData.optJSONObject("properties");
        if (propertiesObject != null) {
            properties = new HashMap<String, Object>();
            Iterator propertyNames = propertiesObject.keys();
            while (propertyNames.hasNext()) {
                String propertyName = (String)propertyNames.next();
                properties.put(propertyName, propertiesObject.get(propertyName));
            }
        }
        return new ConfigurationCollectionPersistData(items).properties(properties);
    }

    private ConfigurationPersistData parseConfigData(JSONObject item, ConfigurationMetadata configMetadata) throws JSONException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        JSONObject properties = item.getJSONObject("properties");
        Iterator propertyNames = properties.keys();
        while (propertyNames.hasNext()) {
            PropertyMetadata propertyMetadata;
            String propertyName = (String)propertyNames.next();
            Class<?> propertyType = null;
            boolean isArray = false;
            if (configMetadata != null && (propertyMetadata = (PropertyMetadata)configMetadata.getPropertyMetadata().get(propertyName)) != null) {
                isArray = propertyMetadata.getType().isArray();
                propertyType = isArray ? propertyMetadata.getType().getComponentType() : propertyMetadata.getType();
            }
            if (propertyType == ConfigurationMetadata.class || properties.isNull(propertyName)) continue;
            if (propertyType == null) {
                Object value = properties.get(propertyName);
                if (value instanceof JSONArray) {
                    JSONArray values = (JSONArray)value;
                    if (values.length() == 0) {
                        props.put(propertyName, ArrayUtils.EMPTY_STRING_ARRAY);
                        continue;
                    }
                    if (values.get(0) instanceof Integer) {
                        props.put(propertyName, this.toArray(properties, propertyName, Integer.TYPE));
                        continue;
                    }
                    if (values.get(0) instanceof Long) {
                        props.put(propertyName, this.toArray(properties, propertyName, Long.TYPE));
                        continue;
                    }
                    if (values.get(0) instanceof Double) {
                        props.put(propertyName, this.toArray(properties, propertyName, Double.TYPE));
                        continue;
                    }
                    if (values.get(0) instanceof Boolean) {
                        props.put(propertyName, this.toArray(properties, propertyName, Boolean.TYPE));
                        continue;
                    }
                    props.put(propertyName, this.toArray(properties, propertyName, String.class));
                    continue;
                }
                props.put(propertyName, value);
                continue;
            }
            if (isArray) {
                props.put(propertyName, this.toArray(properties, propertyName, propertyType));
                continue;
            }
            props.put(propertyName, this.toSingle(properties, propertyName, propertyType));
        }
        String collectionItemName = null;
        if (configMetadata != null && configMetadata.isCollection()) {
            collectionItemName = item.getString("collectionItemName");
        }
        return new ConfigurationPersistData(props).collectionItemName(collectionItemName);
    }

    private Object toSingle(JSONObject properties, String propertyName, Class propertyType) throws JSONException {
        if (propertyType.equals(String.class)) {
            return properties.getString(propertyName);
        }
        if (propertyType.equals(Integer.TYPE)) {
            return properties.getInt(propertyName);
        }
        if (propertyType.equals(Long.TYPE)) {
            return properties.getLong(propertyName);
        }
        if (propertyType.equals(Double.TYPE)) {
            return properties.getDouble(propertyName);
        }
        if (propertyType.equals(Boolean.TYPE)) {
            return properties.getBoolean(propertyName);
        }
        throw new IllegalArgumentException("Unexpected type: " + propertyType.getName());
    }

    private Object toArray(JSONObject properties, String propertyName, Class propertyType) throws JSONException {
        JSONArray array = properties.getJSONArray(propertyName);
        if (propertyType.equals(String.class)) {
            String[] values = new String[array.length()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = array.getString(i);
            }
            return values;
        }
        if (propertyType.equals(Integer.TYPE)) {
            int[] values = new int[array.length()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = array.getInt(i);
            }
            return values;
        }
        if (propertyType.equals(Long.TYPE)) {
            long[] values = new long[array.length()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = array.getLong(i);
            }
            return values;
        }
        if (propertyType.equals(Double.TYPE)) {
            double[] values = new double[array.length()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = array.getDouble(i);
            }
            return values;
        }
        if (propertyType.equals(Boolean.TYPE)) {
            boolean[] values = new boolean[array.length()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = array.getBoolean(i);
            }
            return values;
        }
        throw new IllegalArgumentException("Unexpected type: " + propertyType.getName());
    }

    protected void doDelete(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        String configName = request.getParameter("configName");
        if (StringUtils.isBlank((CharSequence)configName)) {
            response.sendError(404);
            return;
        }
        try {
            this.configManager.deleteConfiguration(request.getResource(), configName);
        }
        catch (ConfigurationPersistenceAccessDeniedException ex) {
            this.sendForbiddenWithMessage(response, ex.getMessage());
        }
        catch (ConfigurationPersistenceException ex) {
            log.warn("Unable to delete data for " + configName, (Throwable)ex);
            response.sendError(500, "Unable to delete data: " + ex.getMessage());
        }
        catch (Exception ex) {
            log.error("Error deleting configuration for " + configName, (Throwable)ex);
            response.sendError(500, ex.getMessage());
        }
    }

    private void sendForbiddenWithMessage(SlingHttpServletResponse response, String message) throws IOException {
        response.setContentType("text/plain;charset=UTF-8");
        response.getWriter().write(message);
        response.setStatus(403);
    }
}

