angular.module("io.wcm.caconfig.templates", ["addCollectionItemModal.html", "addConfigModal.html", "configTable.html", "deleteConfigModal.html", "descriptionPopup.html", "detailView.html", "errorModal.html", "infoModal.html", "multifield.html", "overviewView.html", "pathbrowser.html", "propertyDropdown.html", "propertyEditLink.html", "propertyInputCheckbox.html", "propertyInputText.html", "propertyInputTextarea.html", "propertyInputTextPreview.html", "propertyRow.html", "propertyRowPreview.html", "saveConfigModal.html"]);

angular.module("addCollectionItemModal.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("addCollectionItemModal.html",
    "<coral-dialog id=\"caconfig-addCollectionItemModal\" closable=\"on\"\n" +
    "     ng-controller=\"AddCollectionItemController as addCollectionItem\"\n" +
    "     bindonce>\n" +
    "  <coral-dialog-header bo-text=\"i18n('modal.addCollectionItem.title')\"></coral-dialog-header>\n" +
    "  <coral-dialog-content>\n" +
    "    <form class=\"coral-Form coral-Form--vertical\" name=\"addCollectionItemForm\" novalidate>\n" +
    "      <section class=\"coral-Form-fieldset\">\n" +
    "        <div class=\"coral-Form-fieldwrapper\">\n" +
    "          <label class=\"coral-Form-fieldlabel\" bo-text=\"i18n('config.name')\"></label>\n" +
    "          <div ng-show=\"addCollectionItem.denylist.indexOf(addCollectionItem.newCollectionName) !== -1\">\n" +
    "            <coral-icon class=\"coral-Form-fielderror\" icon=\"alert\" size=\"S\" id=\"caconfig-error-unique\"></coral-icon>\n" +
    "            <coral-tooltip variant=\"error\" placement=\"left\" target=\"#caconfig-error-unique\" bo-text=\"i18n('modal.tooltip.unique')\"></coral-tooltip>\n" +
    "          </div>\n" +
    "          <div ng-show=\"addCollectionItemForm.collectionItemName.$error.pattern\">\n" +
    "            <coral-icon class=\"coral-Form-fielderror\" icon=\"alert\" size=\"S\" id=\"caconfig-error-allowed\"></coral-icon>\n" +
    "            <coral-tooltip variant=\"error\" placement=\"left\" target=\"#caconfig-error-allowed\" bo-text=\"i18n('modal.tooltip.allowed')\"></coral-tooltip>\n" +
    "          </div>\n" +
    "          <input is=\"coral-textfield\" class=\"coral-Form-field\" placeholder=\"Item Name\"\n" +
    "              ng-class=\"{'ng-dirty ng-invalid' : (addCollectionItem.denylist.indexOf(addCollectionItem.newCollectionName) !== -1)}\"\n" +
    "              id=\"caconfig-collectionItemName\" name=\"collectionItemName\"\n" +
    "              ng-model=\"addCollectionItem.newCollectionName\" ng-pattern=\"addCollectionItem.itemTitleRegex\">\n" +
    "        </div>\n" +
    "      </section>\n" +
    "    </form>\n" +
    "  </coral-dialog-content>\n" +
    "  <coral-dialog-footer>\n" +
    "    <button is=\"coral-button\" coral-close variant=\"primary\"\n" +
    "            ng-disabled=\"!addCollectionItemForm.$valid\n" +
    "                         || addCollectionItem.denylist.indexOf(addCollectionItem.newCollectionName) !== -1\n" +
    "                         || !addCollectionItem.newCollectionName\"\n" +
    "            ng-click=\"addCollectionItem.addItem()\" bo-text=\"i18n('button.ok')\"></button>\n" +
    "    <button is=\"coral-button\" coral-close bo-text=\"i18n('button.cancel')\"></button>\n" +
    "  </coral-dialog-footer>\n" +
    "</coral-dialog>\n" +
    "");
}]);

angular.module("addConfigModal.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("addConfigModal.html",
    "<coral-dialog id=\"caconfig-addConfigModal\" closable=\"on\" ng-controller=\"AddConfigController as addConfig\"\n" +
    "     bindonce>\n" +
    "  <coral-dialog-header bo-text=\"i18n('modal.addConfig.title')\"></coral-dialog-header>\n" +
    "  <coral-dialog-content>\n" +
    "    <form class=\"coral-Form coral-Form--aligned\" name=\"addConfigForm\">\n" +
    "      <section class=\"coral-Form-fieldset\">\n" +
    "        <coral-select bo-attr bo-attr-placeholder=\"i18n('button.choose')\" id=\"caconfig-configurationSelect\">\n" +
    "          <coral-select-item ng-repeat=\"item in addConfig.getConfigNames() | filter:{exists:false}\"\n" +
    "                             bo-value=\"item.configName\"\n" +
    "                             bo-text=\"item.label || item.configName\">\n" +
    "          </coral-select-item>\n" +
    "        </coral-select>\n" +
    "      </section>\n" +
    "    </form>\n" +
    "  </coral-dialog-content>\n" +
    "  <coral-dialog-footer>\n" +
    "    <button is=\"coral-button\" coral-close variant=\"primary\" ng-click=\"addConfig.addConfig()\" bo-text=\"i18n('button.ok')\"></button>\n" +
    "    <button is=\"coral-button\" coral-close bo-text=\"i18n('button.cancel')\"></button>\n" +
    "  </coral-dialog-footer>\n" +
    "</coral-dialog>\n" +
    "");
}]);

angular.module("configTable.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("configTable.html",
    "<table bindonce=\"ctReady\"\n" +
    "       class=\"caconfig-configTable coral-Table coral-Table--hover\"\n" +
    "       ng-cloak>\n" +
    "  <thead>\n" +
    "    <tr class=\"coral-Table-row\">\n" +
    "      <th class=\"coral-Table-headerCell\"  style=\"width: 15%;\">\n" +
    "        <h3 bo-text=\"config.collectionItemName\"></h3>\n" +
    "      </th>\n" +
    "      <th class=\"coral-Table-headerCell\">\n" +
    "        <p class=\"caconfig-if-is-preview\">\n" +
    "          <span class=\"caconfig-edit-config caconfig-link coral-Link\" bo-text=\"i18n('config.edit')\" tabindex=\"0\"></span>\n" +
    "        </p>\n" +
    "        <label class=\"coral-Checkbox caconfig-if-not-preview caconfig-if-config-not-inherited caconfig-if-config-not-overridden\">\n" +
    "          <input class=\"coral-Checkbox-input\" type=\"checkbox\"\n" +
    "                 ng-model=\"configPropertyInherit.value\"\n" +
    "                 ng-change=\"configTable.handleConfigPropertyInheritChange(index)\" />\n" +
    "          <span class=\"coral-Checkbox-checkmark\"></span>\n" +
    "          <span class=\"coral-Checkbox-description\" bo-text=\"i18n('config.inheritance.property')\"></span>\n" +
    "        </label>\n" +
    "        <p class=\"caconfig-if-not-preview caconfig-if-config-inherited\">\n" +
    "          <span class=\"caconfig-if-is-collection\" bo-text=\"i18n('config.inheritance.collectionItem')\"></span>\n" +
    "          <span class=\"caconfig-if-not-collection\" bo-text=\"i18n('config.inheritance.config')\"></span>\n" +
    "          <span ng-click=\"configTable.breakInheritance(config)\" class=\"caconfig-link coral-Link\" bo-text=\"i18n('config.inheritance.break')\"></span>\n" +
    "        </p>\n" +
    "      </th>\n" +
    "      <th class=\"coral-Table-headerCell\" style=\"width: 1%;\"></th>\n" +
    "      <th class=\"coral-Table-headerCell\" style=\"width: 1%;\"></th>\n" +
    "      <th class=\"coral-Table-headerCell\" style=\"width: 1%;\">\n" +
    "        <button is=\"coral-button\" icon=\"delete\" variant=\"quiet\" class=\"caconfig-delete-item caconfig-if-is-collection caconfig-if-config-not-inherited\"\n" +
    "          bo-title=\"i18n('button.deleteItem')\" ng-click=\"configTable.removeCollectionItem(index)\"></button>\n" +
    "      </th>\n" +
    "    </tr>\n" +
    "    <tr class=\"coral-Table-row\">\n" +
    "      <th class=\"coral-Table-headerCell\" bo-text=\"i18n('config.property')\"></th>\n" +
    "      <th class=\"coral-Table-headerCell\" bo-text=\"i18n('config.value')\"></th>\n" +
    "      <th class=\"coral-Table-headerCell\">\n" +
    "        <span class=\"caconfig-if-not-preview\" bo-text=\"i18n('config.description')\"></span>\n" +
    "      </th>\n" +
    "      <th class=\"coral-Table-headerCell\">\n" +
    "        <span class=\"caconfig-if-not-preview\" bo-text=\"i18n('config.inherited')\"></span>\n" +
    "      </th>\n" +
    "      <th class=\"coral-Table-headerCell\">\n" +
    "        <span class=\"caconfig-if-not-preview\" bo-text=\"i18n('config.overridden')\"></span>\n" +
    "      </th>\n" +
    "    </tr>\n" +
    "  </thead>\n" +
    "  <tbody class=\"caconfig-configTableBody\">\n" +
    "    <!-- caconfig-property-row directives dynamically added here -->\n" +
    "  </tbody>\n" +
    "</table>\n" +
    "\n" +
    "");
}]);

angular.module("deleteConfigModal.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("deleteConfigModal.html",
    "<coral-dialog id=\"caconfig-deleteConfigModal\" closable=\"on\" variant=\"warning\"\n" +
    "     ng-controller=\"DeleteConfigController\"\n" +
    "     bindonce>\n" +
    "  <coral-dialog-header bo-text=\"i18n('modal.deleteConfig.title')\"></coral-dialog-header>\n" +
    "  <coral-dialog-content>\n" +
    "    <p bo-text=\"i18n('modal.deleteConfig.message')\"></p>\n" +
    "  </coral-dialog-content>\n" +
    "  <coral-dialog-footer>\n" +
    "    <button is=\"coral-button\" variant=\"warning\" coral-close type=\"button\"\n" +
    "            ng-click=\"deleteConfig()\" bo-text=\"i18n('button.ok')\"></button>\n" +
    "    <button is=\"coral-button\" variant=\"secondary\" coral-close type=\"button\"\n" +
    "            bo-text=\"i18n('button.cancel')\"></button>\n" +
    "  </coral-dialog-footer>\n" +
    "</coral-dialog>\n" +
    "");
}]);

angular.module("descriptionPopup.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("descriptionPopup.html",
    "<div bindonce=\"descriptionPopupReady\">\n" +
    "  <button is=\"coral-button\" bo-id=\"id\" variant=\"minimal\" icon=\"infoCircle\" iconsize=\"M\"></button>\n" +
    "  <coral-popover placement=\"left\" bo-attr bo-attr-target=\"'#' + id\"></coral-popover>\n" +
    "</div>\n" +
    "");
}]);

angular.module("detailView.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("detailView.html",
    "<form class=\"caconfig-detail\"\n" +
    "      name=\"detail.configForm\" novalidate ng-cloak\n" +
    "      bindonce=\"detail.dvReady\"\n" +
    "      bo-class=\"detail.current.isCollection ? 'caconfig-is-collection' : 'caconfig-not-collection'\">\n" +
    "\n" +
    "  <button is=\"coral-button\" icon=\"home\"\n" +
    "          bo-title=\"i18n('button.home')\"\n" +
    "          ng-click=\"(detail.configForm.$dirty && detail.current.contextPath) ? saveWarning() : go()\"\n" +
    "  ></button>\n" +
    "  <button is=\"coral-button\" variant=\"primary\"\n" +
    "          class=\"caconfig-if-form-valid-and-dirty\"\n" +
    "          ng-click=\"detail.saveConfig()\"\n" +
    "          bo-if=\"i18n('button.save') && !!detail.current.contextPath\"\n" +
    "          bo-text=\"i18n('button.save')\"\n" +
    "  ></button>\n" +
    "  <button is=\"coral-button\" variant=\"primary\"\n" +
    "          class=\"caconfig-if-form-invalid-or-pristine\"\n" +
    "          disabled\n" +
    "          bo-if=\"i18n('button.save') && !!detail.current.contextPath\"\n" +
    "          bo-text=\"i18n('button.save')\"\n" +
    "  ></button>\n" +
    "  <button is=\"coral-button\"\n" +
    "          ng-click=\"go(detail.current.parent ? detail.current.parent.configName : '')\"\n" +
    "          bo-if=\"i18n('button.cancel')\"\n" +
    "          bo-text=\"i18n('button.cancel')\"\n" +
    "  ></button>\n" +
    "  <button is=\"coral-button\" icon=\"delete\"\n" +
    "          bo-title=\"detail.current.isCollection ? i18n('button.deleteCollection') : i18n('button.deleteConfig')\"\n" +
    "          ng-show=\"detail.current.configs.length\"\n" +
    "          bo-if=\"detail.current.contextPath\"\n" +
    "          ng-click=\"detail.removeConfig()\"\n" +
    "  ></button>\n" +
    "\n" +
    "  <p class=\"caconfig-contextPath\"\n" +
    "     bo-if=\"detail.current.contextPath\">\n" +
    "     <span bo-text=\"i18n('contextPath')\"></span>: <code bo-text=\"detail.current.contextPath\"></code>\n" +
    "  </p>\n" +
    "  <p class=\"caconfig-contextPath\"\n" +
    "     bo-if=\"!detail.current.contextPath\" bo-text=\"i18n('noContextPath')\">\n" +
    "  </p>\n" +
    "\n" +
    "  <h2>\n" +
    "    <span class=\"caconfig-breadcrumb\" ng-repeat=\"breadcrumb in detail.current.breadcrumbs\">\n" +
    "      <span class=\"coral-Link caconfig-breadcrumb-link\"\n" +
    "            ng-click=\"detail.configForm.$dirty ? saveWarning(breadcrumb.configName) : go(breadcrumb.configName)\"\n" +
    "            bo-text=\"breadcrumb.label\">\n" +
    "      </span> /\n" +
    "      <span bo-if=\"breadcrumb.itemName\" bo-text=\"breadcrumb.itemName + ' / '\"></span>\n" +
    "    </span>\n" +
    "    <span bo-text=\"detail.current.label\"></span>\n" +
    "  </h2>\n" +
    "  <p bo-text=\"detail.current.description\"></p>\n" +
    "\n" +
    "  <p class=\"caconfig-collectionInheritance coral-Well\"\n" +
    "     bo-if=\"detail.current.isCollection\">\n" +
    "    <label class=\"coral-Checkbox\">\n" +
    "      <input class=\"coral-Checkbox-input\" type=\"checkbox\"\n" +
    "             ng-model=\"detail.current.collectionProperties['sling:configCollectionInherit']\">\n" +
    "      <span class=\"coral-Checkbox-checkmark\"></span>\n" +
    "      <span class=\"coral-Checkbox-description\" bo-text=\"i18n('config.inheritance.collection')\"></span>\n" +
    "    </label>\n" +
    "  </p>\n" +
    "\n" +
    "  <p bo-if=\"detail.current.isCollection\">\n" +
    "    <button is=\"coral-button\" variant=\"primary\"\n" +
    "            ng-click=\"detail.addCollectionItem()\"\n" +
    "            bo-if=\"i18n('button.addItem')\"\n" +
    "            bo-text=\"i18n('button.addItem')\"\n" +
    "            title=\"{{detail.current.isLargeCollection && !detail.allConfigsVisible ? i18n('largeCollection.addCollectionItemHint') : i18n('button.addItem')}}\"\n" +
    "    ></button>\n" +
    "    <button is=\"coral-button\" icon=\"arrowDown\"\n" +
    "            bo-if=\"detail.current.isLargeCollection\"\n" +
    "            ng-show=\"detail.allConfigsVisible\"\n" +
    "            bo-title=\"i18n('button.toBottom')\"\n" +
    "            ng-click=\"detail.toBottom()\"\n" +
    "    ></button>\n" +
    "  </p>\n" +
    "\n" +
    "  <p class=\"coral-Well caconfig-largeCollection\" bo-if=\"detail.current.isLargeCollection\">\n" +
    "    <span bo-if=\"i18n('largeCollection.numberInCollection')\"\n" +
    "          bo-text=\"i18n('largeCollection.numberInCollection')\"></span>:\n" +
    "    <strong>{{detail.current.configs.length}}</strong>\n" +
    "    <br>\n" +
    "    <span bo-if=\"i18n('largeCollection.numberInEditor')\"\n" +
    "          bo-text=\"i18n('largeCollection.numberInEditor')\"></span>:\n" +
    "    <strong>{{detail.configLimit}}</strong><br>\n" +
    "    <span bo-if=\"i18n('largeCollection.scrollHint')\"\n" +
    "          bo-text=\"i18n('largeCollection.scrollHint')\"></span>\n" +
    "    <br>\n" +
    "    <span class=\"coral-Link caconfig-link\"\n" +
    "          ng-click=\"detail.showAllConfigs()\"\n" +
    "          bo-if=\"i18n('largeCollection.loadAll')\"\n" +
    "          bo-text=\"i18n('largeCollection.loadAll')\">\n" +
    "    </span>\n" +
    "  </p>\n" +
    "\n" +
    "  <div class=\"caconfig-configurationDetails\"\n" +
    "     bo-class=\"[\n" +
    "       config.inherited ? 'caconfig-config-inherited' : 'caconfig-config-not-inherited',\n" +
    "       config.overridden ? 'caconfig-config-overridden' : 'caconfig-config-not-overridden',\n" +
    "       config.isNewItem ? 'caconfig-is-new-item' : 'caconfig-not-new-item',\n" +
    "       detail.current.isLargeCollection ?  'caconfig-is-preview' : 'caconfig-not-preview'\n" +
    "     ]\"\n" +
    "     ng-repeat=\"config in detail.current.configs | limitTo:detail.configLimit track by config.collectionItemName\"\n" +
    "     caconfig-config-table=\"config\"\n" +
    "     index=\"$index\"\n" +
    "     is-preview=\"detail.current.isLargeCollection\"\n" +
    "     ng-cloak>\n" +
    "  </div>\n" +
    "\n" +
    "  <p bo-if=\"detail.current.isCollection\"\n" +
    "     ng-show=\"detail.current.configs.length && detail.allConfigsVisible\">\n" +
    "\n" +
    "    <button is=\"coral-button\" variant=\"primary\"\n" +
    "        ng-click=\"detail.addCollectionItem()\"\n" +
    "        bo-if=\"i18n('button.addItem')\"\n" +
    "        bo-text=\"i18n('button.addItem')\"\n" +
    "    ></button>\n" +
    "    <button is=\"coral-button\" icon=\"arrowUp\"\n" +
    "            bo-if=\"detail.current.isLargeCollection\"\n" +
    "            bo-title=\"i18n('button.toTop')\"\n" +
    "            ng-click=\"detail.toTop()\"\n" +
    "    ></button>\n" +
    "  </p>\n" +
    "\n" +
    "</form>\n" +
    "");
}]);

angular.module("errorModal.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("errorModal.html",
    "<coral-dialog id=\"caconfig-errorModal\" closable=\"on\" variant=\"error\"\n" +
    "     ng-controller=\"ErrorController as errorModal\"\n" +
    "     bindonce>\n" +
    "  <coral-dialog-header bo-text=\"i18n('title')\"></coral-dialog-header>\n" +
    "  <coral-dialog-content>\n" +
    "    <p>{{errorModal.message}}</p>\n" +
    "  </coral-dialog-content>\n" +
    "  <coral-dialog-footer>\n" +
    "    <button is=\"coral-button\" coral-close bo-text=\"i18n('modal.close')\"></button>\n" +
    "  </coral-dialog-footer>\n" +
    "</coral-dialog>\n" +
    "");
}]);

angular.module("infoModal.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("infoModal.html",
    "<coral-dialog id=\"caconfig-infoModal\" closable=\"on\" variant=\"info\"\n" +
    "     ng-controller=\"InfoController as infoModal\"\n" +
    "     bindonce>\n" +
    "  <coral-dialog-header bo-text=\"i18n('title')\"></coral-dialog-header>\n" +
    "  <coral-dialog-content>\n" +
    "    <p>{{infoModal.message}}</p>\n" +
    "  </coral-dialog-content>\n" +
    "  <coral-dialog-footer>\n" +
    "    <button is=\"coral-button\" coral-close bo-text=\"i18n('modal.close')\"></button>\n" +
    "  </coral-dialog-footer>\n" +
    "</coral-dialog>\n" +
    "");
}]);

angular.module("multifield.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("multifield.html",
    "<div bindonce>\n" +
    "  <div class=\"caconfig-multifield caconfig-multifield--empty caconfig-if-property-not-overridden-and-not-inherited\"\n" +
    "      ng-if=\"!(values.length)\">\n" +
    "    <label class=\"coral-Checkbox\"\n" +
    "           bo-if=\"type==='checkbox'\">\n" +
    "      <input class=\"coral-Checkbox-input\" type=\"checkbox\"\n" +
    "             disabled />\n" +
    "      <span class=\"coral-Checkbox-checkmark\"></span>\n" +
    "    </label>\n" +
    "    <input is=\"coral-textfield\" type=\"type\"\n" +
    "           bo-if=\"type!=='checkbox'\"\n" +
    "           disabled />\n" +
    "    <div class=\"coral-ButtonGroup _coral-ButtonGroup coral3-ButtonGroup caconfig-if-config-inherited\">\n" +
    "      <button class=\"coral-ButtonGroup-item coral3-ButtonGroup-item caconfig-disableable-button\"\n" +
    "              is=\"coral-button\" variant=\"action\" icon=\"add\" disabled></button>\n" +
    "      <button class=\"coral-ButtonGroup-item coral3-ButtonGroup-item caconfig-disableable-button\"\n" +
    "              is=\"coral-button\" variant=\"action\" icon=\"minus\" disabled></button>\n" +
    "    </div>\n" +
    "    <div class=\"coral-ButtonGroup _coral-ButtonGroup coral3-ButtonGroup caconfig-if-config-not-inherited\">\n" +
    "       <button class=\"coral-ButtonGroup-item coral3-ButtonGroup-item caconfig-disableable-button\"\n" +
    "               is=\"coral-button\" variant=\"action\" icon=\"add\" ng-click=\"addNewValue(0)\"></button>\n" +
    "       <button class=\"coral-ButtonGroup-item coral3-ButtonGroup-item caconfig-disableable-button\"\n" +
    "               is=\"coral-button\" variant=\"action\" icon=\"minus\" disabled></button>\n" +
    "     </div>\n" +
    "  </div>\n" +
    "\n" +
    "  <div class=\"caconfig-multifield caconfig-if-property-overridden-or-inherited\"\n" +
    "       ng-repeat=\"effectiveValue in effectiveValues\">\n" +
    "    <label class=\"coral-Checkbox\"\n" +
    "           bo-if=\"type==='checkbox'\">\n" +
    "      <input class=\"coral-Checkbox-input\" type=\"checkbox\"\n" +
    "             disabled\n" +
    "             readonly\n" +
    "             ng-model=\"effectiveValue.value\" />\n" +
    "      <span class=\"coral-Checkbox-checkmark\"></span>\n" +
    "    </label>\n" +
    "    <input is=\"coral-textfield\" type=\"type\"\n" +
    "           bo-if=\"type!=='checkbox'\"\n" +
    "           disabled\n" +
    "           readonly\n" +
    "           ng-model=\"effectiveValue.value\" />\n" +
    "    <div class=\"coral-ButtonGroup _coral-ButtonGroup coral3-ButtonGroup\">\n" +
    "      <button class=\"coral-ButtonGroup-item coral3-ButtonGroup-item caconfig-disableable-button\"\n" +
    "              is=\"coral-button\" variant=\"action\" icon=\"add\" disabled></button>\n" +
    "      <button class=\"coral-ButtonGroup-item coral3-ButtonGroup-item caconfig-disableable-button\"\n" +
    "              is=\"coral-button\" variant=\"action\" icon=\"minus\" disabled></button>\n" +
    "    </div>\n" +
    "  </div>\n" +
    "\n" +
    "  <div class=\"caconfig-multifield caconfig-if-config-inherited caconfig-if-property-not-overridden-and-not-inherited\"\n" +
    "       ng-repeat=\"value in values\">\n" +
    "    <label class=\"coral-Checkbox\"\n" +
    "           bo-if=\"type==='checkbox'\">\n" +
    "      <input class=\"coral-Checkbox-input\" type=\"checkbox\"\n" +
    "             disabled\n" +
    "             readonly\n" +
    "             ng-model=\"value.value\" />\n" +
    "      <span class=\"coral-Checkbox-checkmark\"></span>\n" +
    "    </label>\n" +
    "    <input is=\"coral-textfield\" type=\"type\"\n" +
    "           bo-if=\"type!=='checkbox'\"\n" +
    "           disabled\n" +
    "           readonly\n" +
    "           ng-model=\"value.value\" />\n" +
    "    <div class=\"coral-ButtonGroup _coral-ButtonGroup coral3-ButtonGroup\">\n" +
    "      <button class=\"coral-ButtonGroup-item coral3-ButtonGroup-item caconfig-disableable-button\"\n" +
    "              is=\"coral-button\" variant=\"action\" icon=\"add\"></button>\n" +
    "      <button class=\"coral-ButtonGroup-item coral3-ButtonGroup-item caconfig-disableable-button\"\n" +
    "              is=\"coral-button\" variant=\"action\" icon=\"minus\"></button>\n" +
    "    </div>\n" +
    "  </div>\n" +
    "\n" +
    "  <div class=\"caconfig-multifield caconfig-if-config-not-inherited caconfig-if-property-not-overridden-and-not-inherited\"\n" +
    "       ng-repeat=\"value in values\">\n" +
    "    <label class=\"coral-Checkbox\"\n" +
    "           bo-if=\"type==='checkbox'\">\n" +
    "      <input class=\"coral-Checkbox-input\" type=\"checkbox\"\n" +
    "             ng-model=\"value.value\" />\n" +
    "      <span class=\"coral-Checkbox-checkmark\"></span>\n" +
    "    </label>\n" +
    "    <input is=\"coral-textfield\" type=\"type\"\n" +
    "           bo-if=\"type!=='checkbox'\"\n" +
    "           ng-model=\"value.value\"\n" +
    "           ng-trim=\"false\"\n" +
    "           ng-pattern=\"pattern\" />\n" +
    "    <div class=\"coral-ButtonGroup _coral-ButtonGroup coral3-ButtonGroup\">\n" +
    "      <button class=\"coral-ButtonGroup-item coral3-ButtonGroup-item caconfig-disableable-button\"\n" +
    "              is=\"coral-button\" variant=\"action\" icon=\"add\" ng-click=\"addNewValue($index)\"></button>\n" +
    "      <button class=\"coral-ButtonGroup-item coral3-ButtonGroup-item caconfig-disableable-button\"\n" +
    "              is=\"coral-button\" variant=\"action\" icon=\"minus\" ng-click=\"removeValue($index)\"></button>\n" +
    "    </div>\n" +
    "  </div>\n" +
    "</div>\n" +
    "");
}]);

angular.module("overviewView.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("overviewView.html",
    "<div bindonce=\"overview.ovReady\" class=\"caconfig-overview\" ng-cloak>\n" +
    "  <button is=\"coral-button\" variant=\"primary\"\n" +
    "          bo-disabled=\"!overview.hasNonExistingConfig()\n" +
    "                       || !overview.state.contextPath\"\n" +
    "          ng-click=\"overview.showNonExistingConfigs()\"\n" +
    "          bo-text=\"i18n('button.add')\"></button>\n" +
    "  <button is=\"coral-button\"\n" +
    "          class=\"caconfig-publishButton\"\n" +
    "          ng-click=\"overview.publishPage()\"\n" +
    "          bo-if=\"i18n('button.publish')\"\n" +
    "          bo-text=\"i18n('button.publish')\"></button>\n" +
    "\n" +
    "  <p class=\"caconfig-contextPath\"\n" +
    "     bo-if=\"overview.state.contextPath\">\n" +
    "     <span bo-text=\"i18n('contextPath')\"></span>: <code bo-text=\"overview.state.contextPath\"></code>\n" +
    "  </p>\n" +
    "  <p class=\"caconfig-contextPath\"\n" +
    "     bo-if=\"!overview.state.contextPath\" bo-text=\"i18n('noContextPath')\">\n" +
    "  </p>\n" +
    "\n" +
    "  <table class=\"coral-Table coral-Table--hover\"\n" +
    "         bo-if=\"(overview.state.configNames | filter:{exists:true}).length\" ng-cloak>\n" +
    "    <thead>\n" +
    "      <tr class=\"coral-Table-row\">\n" +
    "        <th class=\"coral-Table-headerCell\" style=\"width:1%\"></th>\n" +
    "        <th class=\"coral-Table-headerCell\" bo-text=\"i18n('config.name')\"></th>\n" +
    "        <th class=\"coral-Table-headerCell\" bo-text=\"i18n('config.description')\"></th>\n" +
    "        <th class=\"coral-Table-headerCell\" style=\"width:1%\"></th>\n" +
    "      </tr>\n" +
    "    </thead>\n" +
    "    <tbody>\n" +
    "      <tr class=\"coral-Table-row\"\n" +
    "          ng-repeat=\"config in overview.state.configNames | filter:{exists:true}\"\n" +
    "          ng-click=\"go(config.configName)\" ng-cloak>\n" +
    "        <td class=\"coral-Table-cell\">\n" +
    "          <coral-icon bo-attr bo-attr-icon=\"config.collection ? 'pages' : 'page'\"></coral-icon>\n" +
    "        </td>\n" +
    "        <td class=\"coral-Table-cell\" bo-text=\"config.label || config.configName\"></td>\n" +
    "        <td class=\"coral-Table-cell\" bo-text=\"config.description\"></td>\n" +
    "        <td class=\"coral-Table-cell\">\n" +
    "          <coral-icon bo-if=\"config.overridden\" icon=\"lockOn\"\n" +
    "             data-init=\"quicktip\" data-quicktip-arrow=\"right\" data-quicktip-type=\"info\" role=\"img\" tabindex=\"0\"\n" +
    "             bo-attr\n" +
    "             bo-attr-data-quicktip-content=\"i18n(config.collection ? 'config.tooltip.overriddenCollection' : 'config.tooltip.overriddenConfig')\"\n" +
    "          ></coral-icon>\n" +
    "          <coral-icon bo-if=\"!config.overridden && config.inherited\" icon=\"link\"\n" +
    "             data-init=\"quicktip\" data-quicktip-arrow=\"right\" data-quicktip-type=\"info\" role=\"img\" tabindex=\"0\"\n" +
    "             bo-attr\n" +
    "             bo-attr-data-quicktip-content=\"i18n(config.collection ? 'config.tooltip.inheritedCollection' : 'config.tooltip.inheritedConfig')\"\n" +
    "          ></coral-icon>\n" +
    "          <coral-icon bo-if=\"!config.overridden && !config.inherited\" icon=\"linkOff\"\n" +
    "             data-init=\"quicktip\" data-quicktip-arrow=\"right\" data-quicktip-type=\"info\" role=\"img\" tabindex=\"0\"\n" +
    "             bo-attr\n" +
    "             bo-attr-data-quicktip-content=\"i18n(config.collection ? 'config.tooltip.notInheritedCollection' : 'config.tooltip.notInheritedConfig')\"\n" +
    "          ></coral-icon>\n" +
    "        </td>\n" +
    "      </tr>\n" +
    "    </tbody>\n" +
    "  </table>\n" +
    "</div>\n" +
    "");
}]);

angular.module("pathbrowser.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("pathbrowser.html",
    "<div bindonce class=\"caconfig-pathbrowser\">\n" +
    "  <div class=\"coral-PathBrowser--disabled caconfig-if-property-overridden-or-inherited\">\n" +
    "    <div class=\"coral-InputGroup\">\n" +
    "      <input class=\"coral-InputGroup-input coral-Textfield\"\n" +
    "             type=\"text\" autocomplete=\"off\"\n" +
    "             disabled\n" +
    "             readonly\n" +
    "             ng-model=\"property.effectiveValue\" />\n" +
    "      <div class=\"coral-InputGroup-button\">\n" +
    "        <button is=\"coral-button\" class=\"coral-Button--square caconfig-disableable-button\"\n" +
    "                type=\"button\" bo-title=\"i18n('button.browse')\" icon=\"folderSearch\" iconsize=\"S\"\n" +
    "                disabled></button>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "  </div>\n" +
    "  <div class=\"coral-PathBrowser caconfig-if-property-not-overridden-and-not-inherited\">\n" +
    "    <div class=\"coral-InputGroup\">\n" +
    "      <input class=\"coral-InputGroup-input coral-Textfield js-coral-pathbrowser-input caconfig-if-config-inherited\"\n" +
    "             type=\"text\" autocomplete=\"off\"\n" +
    "             disabled\n" +
    "             readonly\n" +
    "             ng-model=\"property.value\" />\n" +
    "      <input class=\"coral-InputGroup-input coral-Textfield js-coral-pathbrowser-input caconfig-if-config-not-inherited\"\n" +
    "             type=\"text\" autocomplete=\"off\"\n" +
    "             ng-model=\"property.value\" />\n" +
    "      <div class=\"coral-InputGroup-button caconfig-if-config-inherited\">\n" +
    "        <button is=\"coral-button\" class=\"coral-Button--square js-coral-pathbrowser-button caconfig-disableable-button\"\n" +
    "                type=\"button\" bo-title=\"i18n('button.browse')\"\n" +
    "                disabled></button>\n" +
    "      </div>\n" +
    "      <div class=\"coral-InputGroup-button caconfig-if-not-config-inherited\">\n" +
    "        <button is=\"coral-button\" class=\"coral-Button--square js-coral-pathbrowser-button caconfig-disableable-button\"\n" +
    "                type=\"button\" bo-title=\"i18n('button.browse')\" icon=\"folderSearch\" iconsize=\"S\"></button>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "  </div>\n" +
    "</div>\n" +
    "");
}]);

angular.module("propertyDropdown.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("propertyDropdown.html",
    "<div class=\"caconfig-property-dropdown\" bindonce=\"dropdownReady\" ng-model=\"property.value\">\n" +
    "  <coral-select class=\"caconfig-if-property-not-overridden-and-not-inherited caconfig-if-config-not-inherited\" bo-id=\"id\"\n" +
    "                bo-attr bo-attr-placeholder=\"i18n('button.choose')\">\n" +
    "    <coral-select-item ng-repeat=\"option in dropdownOptions\"\n" +
    "                       bo-value=\"option.value\"\n" +
    "                       bo-text=\"option.description\">\n" +
    "    </coral-select-item>\n" +
    "  </coral-select>\n" +
    "\n" +
    "  <span class=\"coral-Select coral3-Select caconfig-if-property-not-overridden-and-not-inherited caconfig-if-config-inherited\">\n" +
    "    <button class=\"coral3-Button coral3-Button--secondary coral3-Button--block coral3-Select-button\" disabled readonly>\n" +
    "      <coral-icon class=\"coral3-Icon coral3-Select-openIcon coral3-Icon--chevronDown coral3-Icon--sizeXS\" icon=\"chevronDown\" size=\"XS\"></coral-icon>\n" +
    "      <span class=\"coral3-Select-label\" bo-if=\"i18n('button.choose')\" bo-text=\"i18n('button.choose')\"></span>\n" +
    "    </button>\n" +
    "    <coral-taglist class=\"coral3-Select-tagList caconfig-dummy-taglist\"></coral-taglist>\n" +
    "  </span>\n" +
    "\n" +
    "  <span class=\"coral-Select coral3-Select caconfig-if-property-overridden-or-inherited\">\n" +
    "    <button class=\"coral3-Button coral3-Button--secondary coral3-Button--block coral3-Select-button\" disabled readonly>\n" +
    "      <coral-icon class=\"coral3-Icon coral3-Select-openIcon coral3-Icon--chevronDown coral3-Icon--sizeXS\" icon=\"chevronDown\" size=\"XS\"></coral-icon>\n" +
    "      <span class=\"coral3-Select-label\" ng-bind=\"getOptionText(property.effectiveValue)\"></span>\n" +
    "    </button>\n" +
    "    <coral-taglist class=\"coral3-Select-tagList caconfig-dummy-taglist caconfig-dummy-taglist--effective\"></coral-taglist>\n" +
    "  </span>\n" +
    "</div>\n" +
    "");
}]);

angular.module("propertyEditLink.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("propertyEditLink.html",
    "<div bindonce>\n" +
    "  <button is=\"coral-button\" class=\"caconfig-if-config-not-inherited-and-not-new-item\"\n" +
    "          bo-text=\"linkText\" block\n" +
    "          ng-click=\"configForm.$dirty ? saveWarning(configName) : go(configName)\"></button>\n" +
    "  <button is=\"coral-button\" class=\"caconfig-if-config-inherited-or-new-item\"\n" +
    "          bo-text=\"linkText\" block disabled></button>\n" +
    "</div>\n" +
    "");
}]);

angular.module("propertyInputCheckbox.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("propertyInputCheckbox.html",
    "<div>\n" +
    "  <label class=\"coral-Checkbox coral3-Checkbox caconfig-if-property-not-overridden-and-not-inherited caconfig-if-config-not-inherited\">\n" +
    "    <input class=\"coral-Checkbox-input coral3-Checkbox-input\" type=\"checkbox\"\n" +
    "           ng-model=\"property.value\" />\n" +
    "    <span class=\"coral-Checkbox-checkmark coral3-Checkbox-checkmark\"></span>\n" +
    "  </label>\n" +
    "  <label class=\"coral-Checkbox coral3-Checkbox caconfig-if-property-not-overridden-and-not-inherited caconfig-if-config-inherited\">\n" +
    "    <input class=\"coral-Checkbox-input coral3-Checkbox-input\" type=\"checkbox\"\n" +
    "           ng-model=\"property.value\"\n" +
    "           disabled readonly />\n" +
    "    <span class=\"coral-Checkbox-checkmark coral3-Checkbox-checkmark\"></span>\n" +
    "  </label>\n" +
    "  <label class=\"coral-Checkbox coral3-Checkbox caconfig-if-property-overridden-or-inherited\">\n" +
    "    <input class=\"coral-Checkbox-input coral3-Checkbox-input\" type=\"checkbox\"\n" +
    "           ng-model=\"property.effectiveValue\"\n" +
    "           disabled readonly />\n" +
    "    <span class=\"coral-Checkbox-checkmark coral3-Checkbox-checkmark\"></span>\n" +
    "  </label>\n" +
    "</div>\n" +
    "");
}]);

angular.module("propertyInputText.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("propertyInputText.html",
    "<div>\n" +
    "  <input is=\"coral-textfield\" class=\"caconfig-if-property-not-overridden-and-not-inherited caconfig-if-config-not-inherited\"\n" +
    "         ng-model=\"property.value\" ng-trim=\"false\"\n" +
    "         ng-pattern=\"pattern\" />\n" +
    "  <input is=\"coral-textfield\" class=\"caconfig-if-property-not-overridden-and-not-inherited caconfig-if-config-inherited\"\n" +
    "         ng-model=\"property.value\"\n" +
    "         disabled readonly />\n" +
    "  <input is=\"coral-textfield\" class=\"caconfig-if-property-overridden-or-inherited\"\n" +
    "         ng-model=\"property.effectiveValue\"\n" +
    "         disabled readonly />\n" +
    "</div>\n" +
    "");
}]);

angular.module("propertyInputTextarea.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("propertyInputTextarea.html",
    "<div>\n" +
    "  <textarea is=\"coral-textarea\" class=\"caconfig-if-property-not-overridden-and-not-inherited caconfig-if-config-not-inherited\"\n" +
    "            ng-model=\"property.value\" ng-trim=\"false\"/>\n" +
    "  <textarea is=\"coral-textarea\" class=\"caconfig-if-property-not-overridden-and-not-inherited caconfig-if-config-inherited\"\n" +
    "            ng-model=\"property.value\"\n" +
    "            disabled readonly />\n" +
    "  <textarea is=\"coral-textarea\" class=\"caconfig-if-property-overridden-or-inherited\"\n" +
    "            ng-model=\"property.effectiveValue\"\n" +
    "            disabled readonly />\n" +
    "</div>\n" +
    "");
}]);

angular.module("propertyInputTextPreview.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("propertyInputTextPreview.html",
    "<div>\n" +
    "  <input is=\"coral-textfield\" class=\"caconfig-if-property-not-overridden-and-not-inherited caconfig-if-config-not-inherited\"\n" +
    "         bo-value=\"property.value\"/>\n" +
    "  <input is=\"coral-textfield\" class=\"caconfig-if-property-not-overridden-and-not-inherited caconfig-if-config-inherited\"\n" +
    "         bo-value=\"property.value\"\n" +
    "         disabled readonly />\n" +
    "  <input is=\"coral-textfield\" class=\"caconfig-if-property-overridden-or-inherited\"\n" +
    "         bo-value=\"property.effectiveValue\"\n" +
    "         disabled readonly />\n" +
    "</div>\n" +
    "");
}]);

angular.module("propertyRow.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("propertyRow.html",
    "<tr bindonce\n" +
    "    class=\"coral-Table-row\"\n" +
    "    ng-class=\"property.inherited ? 'caconfig-property-inherited' : 'caconfig-property-not-inherited'\"\n" +
    "    bo-class=\"[property.overridden ? 'caconfig-property-overridden' : 'caconfig-property-not-overridden',\n" +
    "              (property.nestedConfig || property.nestedConfigCollection) ? 'caconfig-is-nested' : 'caconfig-not-nested']\"\n" +
    "    bo-title=\"property.name\" ng-cloak>\n" +
    "  <td class=\"coral-Table-cell\" bo-text=\"property.metadata.label || property.name\"></td>\n" +
    "\n" +
    "  <td class=\"coral-Table-cell\" ng-transclude>\n" +
    "    <!-- caconfig-property-input dynamically added here -->\n" +
    "  </td>\n" +
    "\n" +
    "  <td class=\"coral-Table-cell\">\n" +
    "    <div bo-if=\"property.metadata.description\">\n" +
    "      <caconfig-description-popup content=\"property.metadata.description\"></caconfig-description-popup>\n" +
    "    </div>\n" +
    "  </td>\n" +
    "  <td class=\"coral-Table-cell\">\n" +
    "    <label class=\"coral-Checkbox\">\n" +
    "      <input class=\"coral-Checkbox-input\" type=\"checkbox\"\n" +
    "        ng-model=\"property.inherited\"\n" +
    "        ng-disabled=\"!propertyInheritanceEnabled\n" +
    "                     || property.overridden || property.nestedConfig\n" +
    "                     || property.nestedConfigCollection\"\n" +
    "        ng-change=\"propertyRow.handleInheritedChange(property)\">\n" +
    "      <span class=\"coral-Checkbox-checkmark\"></span>\n" +
    "    </label>\n" +
    "  </td>\n" +
    "  <td class=\"coral-Table-cell\">\n" +
    "    <label class=\"coral-Checkbox\">\n" +
    "      <input class=\"coral-Checkbox-input\" type=\"checkbox\"\n" +
    "        ng-model=\"property.overridden\" disabled readonly>\n" +
    "      <span class=\"coral-Checkbox-checkmark\"></span>\n" +
    "    </label>\n" +
    "  </td>\n" +
    "</tr>\n" +
    "");
}]);

angular.module("propertyRowPreview.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("propertyRowPreview.html",
    "<tr bindonce\n" +
    "    class=\"coral-Table-row coral-Table-row--preview\"\n" +
    "    bo-class=\"[property.inherited ? 'caconfig-property-inherited' : 'caconfig-property-not-inherited',\n" +
    "               property.overridden ? 'caconfig-property-overridden' : 'caconfig-property-not-overridden',\n" +
    "              (property.nestedConfig || property.nestedConfigCollection) ? 'caconfig-is-nested' : 'caconfig-not-nested']\"\n" +
    "    bo-title=\"property.name\" ng-cloak>\n" +
    "  <td class=\"coral-Table-cell\" bo-text=\"property.metadata.label || property.name\"></td>\n" +
    "  <td class=\"coral-Table-cell\">\n" +
    "    <span class=\"caconfig-if-property-not-overridden-and-not-inherited caconfig-if-config-not-inherited\" bo-text=\"property.value\"></span>\n" +
    "    <span class=\"caconfig-if-property-not-overridden-and-not-inherited caconfig-if-config-inherited\" bo-text=\"property.value\"></span>\n" +
    "    <span class=\"caconfig-if-property-overridden-or-inherited\" bo-text=\"property.effectiveValue\"></span>\n" +
    "  </td>\n" +
    "  <td class=\"coral-Table-cell\"></td>\n" +
    "  <td class=\"coral-Table-cell\"></td>\n" +
    "  <td class=\"coral-Table-cell\"></td>\n" +
    "</tr>\n" +
    "");
}]);

angular.module("saveConfigModal.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("saveConfigModal.html",
    "<coral-dialog id=\"caconfig-saveConfigModal\" closable=\"on\" variant=\"warning\"\n" +
    "     ng-controller=\"SaveConfigController as saveConfig\"\n" +
    "     bindonce>\n" +
    "  <coral-dialog-header bo-text=\"i18n('modal.saveConfig.title')\"></coral-dialog-header>\n" +
    "  <coral-dialog-content>\n" +
    "    <p bo-text=\"i18n('modal.saveConfig.message')\"></p>\n" +
    "  </coral-dialog-content>\n" +
    "  <coral-dialog-footer>\n" +
    "    <button is=\"coral-button\" variant=\"primary\" coral-close type=\"button\"\n" +
    "            ng-click=\"saveConfig.saveConfigWithRedirect()\"\n" +
    "            bo-text=\"i18n('button.save')\"></button>\n" +
    "    <button is=\"coral-button\" variant=\"secondary\" coral-close type=\"button\"\n" +
    "            ng-click=\"goToRedirectUrl()\"\n" +
    "            bo-text=\"i18n('button.discard')\"></button>\n" +
    "    <button is=\"coral-button\" variant=\"secondary\" coral-close type=\"button\"\n" +
    "            bo-text=\"i18n('button.cancel')\"></button>\n" +
    "  </coral-dialog-footer>\n" +
    "</coral-dialog>\n" +
    "");
}]);
