/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.extensions.contextpath.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.resource.spi.ContextPathStrategy;
import org.apache.sling.caconfig.resource.spi.ContextResource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ContextPathStrategy.class})
@Designate(ocd=Config.class, factory=true)
public class AbsoluteParentContextPathStrategy
implements ContextPathStrategy {
    private Set<Integer> levels;
    private Pattern contextPathRegex;
    private Pattern contextPathBlacklistRegex;
    private String[] configPathPatterns;
    private static final Logger log = LoggerFactory.getLogger(AbsoluteParentContextPathStrategy.class);

    @Activate
    void activate(Config config) {
        this.levels = new TreeSet<Integer>();
        if (config.levels() != null) {
            for (int level : config.levels()) {
                this.levels.add(level);
            }
        }
        try {
            this.contextPathRegex = Pattern.compile(config.contextPathRegex());
        }
        catch (PatternSyntaxException ex) {
            log.warn("Invalid context path regex: " + config.contextPathRegex(), (Throwable)ex);
        }
        if (StringUtils.isNotEmpty((CharSequence)config.contextPathBlacklistRegex())) {
            try {
                this.contextPathBlacklistRegex = Pattern.compile(config.contextPathBlacklistRegex());
            }
            catch (PatternSyntaxException ex) {
                log.warn("Invalid context path blacklist regex: " + config.contextPathBlacklistRegex(), (Throwable)ex);
            }
        }
        this.configPathPatterns = config.configPathPatterns();
    }

    public Iterator<ContextResource> findContextResources(Resource resource) {
        if (!this.isValidConfig()) {
            return Collections.emptyIterator();
        }
        ArrayList<ContextResource> contextResources = new ArrayList<ContextResource>();
        for (int level : this.levels) {
            Resource contextResource;
            String contextPath = this.getAbsoluteParent(resource, level);
            if (!StringUtils.isNotEmpty((CharSequence)contextPath) || (contextResource = resource.getResourceResolver().getResource(contextPath)) == null) continue;
            for (String configPathPattern : this.configPathPatterns) {
                String configRef = this.deriveConfigRef(contextPath, configPathPattern);
                if (configRef == null) continue;
                contextResources.add(new ContextResource(contextResource, configRef));
            }
        }
        Collections.reverse(contextResources);
        return contextResources.iterator();
    }

    private boolean isValidConfig() {
        return !this.levels.isEmpty() && this.contextPathRegex != null && this.configPathPatterns != null && this.configPathPatterns.length > 0;
    }

    private String getAbsoluteParent(Resource resource, int absoluteParent) {
        return Text.getAbsoluteParent((String)resource.getPath(), (int)absoluteParent);
    }

    private String deriveConfigRef(String contextPath, String configPathPattern) {
        Matcher matcher = this.contextPathRegex.matcher(contextPath);
        Matcher blacklistMatcher = null;
        if (this.contextPathBlacklistRegex != null) {
            blacklistMatcher = this.contextPathBlacklistRegex.matcher(contextPath);
        }
        if (matcher.matches() && (blacklistMatcher == null || !blacklistMatcher.matches())) {
            return matcher.replaceAll(configPathPattern);
        }
        return null;
    }

    @ObjectClassDefinition(name="wcm.io Context-Aware Configuration Context Path Strategy: Absolute Parents", description="Detects context paths by absolute parent levels of a context resource.")
    static @interface Config {
        @AttributeDefinition(name="Absolute Levels", description="List of absolute parent levels. Example: Absolute parent level 1 of '/foo/bar/test' is '/foo/bar'.", required=true)
        public int[] levels();

        @AttributeDefinition(name="Context path whitelist", description="Expression to match context paths. Context paths matching this expression are allowed. Use groups to reference them in configPathPatterns.", required=true)
        public String contextPathRegex() default "^/content(/.+)$";

        @AttributeDefinition(name="Context path blacklist", description="Expression to match context paths. Context paths matching this expression are not allowed.", required=true)
        public String contextPathBlacklistRegex() default "^.*/tools(/config)?$";

        @AttributeDefinition(name="Config path patterns", description="Expression to derive the config path from the context path. Regex group references like $1 can be used.", required=true)
        public String[] configPathPatterns() default {"/conf$1"};

        @AttributeDefinition(name="Service Ranking", description="Priority of context path strategy (higher = higher priority).")
        public int service_ranking() default 2000;

        public String webconsole_configurationFactory_nameHint() default "{applicationId} levels={levels}";
    }
}

