/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.extensions.persistence.impl;

import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.caconfig.spi.ConfigurationPersistenceAccessDeniedException;
import org.apache.sling.caconfig.spi.ConfigurationPersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PersistenceUtils {
    private static final String DEFAULT_FOLDER_NODE_TYPE = "sling:Folder";
    private static final Pattern PAGE_PATH_PATTERN = Pattern.compile("^(.*)/" + Pattern.quote("jcr:content") + "(/.*)?$");
    private static final Pattern JCR_CONTENT_PATTERN = Pattern.compile("^(.*/)?" + Pattern.quote("jcr:content") + "(/.*)?$");
    private static final Logger log = LoggerFactory.getLogger(PersistenceUtils.class);

    private PersistenceUtils() {
    }

    public static boolean containsJcrContent(String path) {
        if (path == null) {
            return false;
        }
        return JCR_CONTENT_PATTERN.matcher(path).matches();
    }

    public static void ensureContainingPage(ResourceResolver resolver, String configResourcePath) {
        PersistenceUtils.ensureContainingPage(resolver, configResourcePath, null, null);
    }

    public static void ensureContainingPage(ResourceResolver resolver, String configResourcePath, String template, String parentTemplate) {
        Matcher matcher = PAGE_PATH_PATTERN.matcher(configResourcePath);
        if (!matcher.matches()) {
            return;
        }
        String pagePath = matcher.group(1);
        PersistenceUtils.ensurePage(resolver, pagePath, template, parentTemplate);
    }

    private static Resource ensurePage(ResourceResolver resolver, String pagePath, String template, String parentTemplate) {
        Resource resource = resolver.getResource(pagePath);
        if (resource != null) {
            return resource;
        }
        String parentPath = ResourceUtil.getParent((String)pagePath);
        String pageName = ResourceUtil.getName((String)pagePath);
        Resource parentResource = StringUtils.isNotEmpty((CharSequence)parentTemplate) ? PersistenceUtils.ensurePage(resolver, parentPath, parentTemplate, parentTemplate) : PersistenceUtils.getOrCreateResource(resolver, parentPath, DEFAULT_FOLDER_NODE_TYPE, null);
        return PersistenceUtils.createPage(resolver, parentResource, pageName, template);
    }

    private static Resource createPage(ResourceResolver resolver, Resource parentResource, String pageName, String template) {
        String pagePath = parentResource.getPath() + "/" + pageName;
        log.trace("! Create cq:Page node at {}", (Object)pagePath);
        try {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("jcr:primaryType", "cq:Page");
            Resource pageResource = resolver.create(parentResource, pageName, props);
            props = new HashMap();
            props.put("jcr:primaryType", "cq:PageContent");
            if (StringUtils.isNotEmpty((CharSequence)template)) {
                PersistenceUtils.applyPageTemplate(resolver, props, pageName, template);
            }
            resolver.create(pageResource, "jcr:content", props);
            return pageResource;
        }
        catch (PersistenceException ex) {
            throw PersistenceUtils.convertPersistenceException("Unable to create config page at " + pagePath, ex);
        }
    }

    private static void applyPageTemplate(ResourceResolver resolver, Map<String, Object> props, String pageName, String template) {
        props.put("cq:template", template);
        props.put("jcr:title", pageName);
        Resource templateContentResource = resolver.getResource(template + "/" + "jcr:content");
        if (templateContentResource != null) {
            props.put("sling:resourceType", templateContentResource.getValueMap().get("sling:resourceType", String.class));
        }
    }

    public static Resource getOrCreateResource(ResourceResolver resolver, String path, String defaultNodeType, Map<String, Object> properties) {
        try {
            Resource resource = ResourceUtil.getOrCreateResource((ResourceResolver)resolver, (String)path, (String)defaultNodeType, (String)defaultNodeType, (boolean)false);
            if (properties != null) {
                PersistenceUtils.replaceProperties(resource, properties);
            }
            return resource;
        }
        catch (PersistenceException ex) {
            throw PersistenceUtils.convertPersistenceException("Unable to create resource at " + path, ex);
        }
    }

    public static void deleteChildren(Resource resource) {
        ResourceResolver resolver = resource.getResourceResolver();
        try {
            for (Resource child : resource.getChildren()) {
                resolver.delete(child);
            }
        }
        catch (PersistenceException ex) {
            throw PersistenceUtils.convertPersistenceException("Unable to remove children from " + resource.getPath(), ex);
        }
    }

    public static void replaceProperties(Resource resource, Map<String, Object> properties) {
        ModifiableValueMap modValueMap;
        if (log.isTraceEnabled()) {
            log.trace("! Store properties for resource {}: {}", (Object)resource.getPath(), properties);
        }
        if ((modValueMap = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class)) == null) {
            throw new ConfigurationPersistenceAccessDeniedException("No write access: Unable to store configuration data to " + resource.getPath() + ".");
        }
        for (String propertyName : new HashSet(modValueMap.keySet())) {
            if (StringUtils.startsWith((CharSequence)propertyName, (CharSequence)"jcr:")) continue;
            modValueMap.remove((Object)propertyName);
        }
        modValueMap.putAll(properties);
    }

    public static void updatePageLastMod(ResourceResolver resolver, String configResourcePath) {
        Matcher matcher = PAGE_PATH_PATTERN.matcher(configResourcePath);
        if (!matcher.matches()) {
            return;
        }
        String pagePath = matcher.group(1);
        Resource contentResource = resolver.getResource(pagePath + "/" + "jcr:content");
        if (contentResource != null) {
            ModifiableValueMap contentProps = (ModifiableValueMap)contentResource.adaptTo(ModifiableValueMap.class);
            if (contentProps == null) {
                throw new ConfigurationPersistenceAccessDeniedException("No write access: Unable to update page " + configResourcePath + ".");
            }
            contentProps.put((Object)"jcr:lastModified", (Object)Calendar.getInstance());
            contentProps.put((Object)"jcr:lastModifiedBy", resolver.getAttribute("user.name"));
        }
    }

    public static void commit(ResourceResolver resourceResolver, String relatedResourcePath) {
        try {
            resourceResolver.commit();
        }
        catch (PersistenceException ex) {
            throw PersistenceUtils.convertPersistenceException("Unable to persist configuration changes to " + relatedResourcePath, ex);
        }
    }

    public static ConfigurationPersistenceException convertPersistenceException(String message, PersistenceException ex) {
        if (StringUtils.equals((CharSequence)ex.getCause().getClass().getName(), (CharSequence)"javax.jcr.AccessDeniedException")) {
            return new ConfigurationPersistenceAccessDeniedException("No write access: " + message, (Throwable)ex);
        }
        return new ConfigurationPersistenceException(message, (Throwable)ex);
    }
}

