/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.extensions.contextpath.impl;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.resource.spi.ContextPathStrategy;
import org.apache.sling.caconfig.resource.spi.ContextResource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ContextPathStrategy.class})
@Designate(ocd=Config.class, factory=true)
public class RootTemplateContextPathStrategy
implements ContextPathStrategy {
    private Set<String> templatePaths;
    private int minLevel;
    private int maxLevel;
    private Pattern contextPathRegex;
    private String[] configPathPatterns;
    private static final Logger log = LoggerFactory.getLogger(RootTemplateContextPathStrategy.class);

    @Activate
    void activate(Config config) {
        this.templatePaths = config.templatePaths() != null ? ImmutableSet.copyOf((Object[])config.templatePaths()) : Collections.emptySet();
        this.minLevel = config.minLevel();
        this.maxLevel = config.maxLevel();
        try {
            this.contextPathRegex = Pattern.compile(config.contextPathRegex());
        }
        catch (PatternSyntaxException ex) {
            log.warn("Invalid context path regex: " + config.contextPathRegex(), (Throwable)ex);
        }
        this.configPathPatterns = config.configPathPatterns();
    }

    public Iterator<ContextResource> findContextResources(Resource resource) {
        if (!this.isValidConfig()) {
            return Collections.emptyIterator();
        }
        List<String> contextPathCandidats = this.getContextPathCandidates(resource);
        ArrayList<ContextResource> contextResources = new ArrayList<ContextResource>();
        for (String contextPath : contextPathCandidats) {
            Resource contextResource = resource.getResourceResolver().getResource(contextPath);
            if (contextResource == null) continue;
            for (String configPathPattern : this.configPathPatterns) {
                String configRef = this.deriveConfigRef(contextPath, configPathPattern);
                if (configRef == null) continue;
                contextResources.add(new ContextResource(contextResource, configRef));
            }
        }
        Collections.reverse(contextResources);
        return contextResources.iterator();
    }

    private boolean isValidConfig() {
        return !this.templatePaths.isEmpty() && this.contextPathRegex != null && this.configPathPatterns != null && this.configPathPatterns.length > 0;
    }

    private List<String> getContextPathCandidates(Resource resource) {
        ArrayList<String> candidates = new ArrayList<String>();
        PageManager pageManager = (PageManager)resource.getResourceResolver().adaptTo(PageManager.class);
        Page page = pageManager.getContainingPage(resource);
        if (page != null) {
            for (int level = this.minLevel; level <= this.maxLevel; ++level) {
                String templatePath;
                Page rootPage = page.getAbsoluteParent(level);
                if (rootPage == null || (templatePath = (String)rootPage.getProperties().get("cq:template", String.class)) == null) continue;
                candidates.add(rootPage.getPath());
                if (this.templatePaths.contains(templatePath)) break;
            }
        }
        return candidates;
    }

    private String deriveConfigRef(String contextPath, String configPathPattern) {
        Matcher matcher = this.contextPathRegex.matcher(contextPath);
        if (matcher.matches()) {
            return matcher.replaceAll(configPathPattern);
        }
        return null;
    }

    @ObjectClassDefinition(name="wcm.io Context-Aware Configuration Context Path Strategy: Root Templates", description="Detects context paths by matching parent pages against a list of allowed templates for context root. All page between min and max level up to a page with a page matching the templates are defined as context paths.")
    static @interface Config {
        @AttributeDefinition(name="Templates", description="List of template paths allowed for context root pages.", required=true)
        public String[] templatePaths();

        @AttributeDefinition(name="Min. Level", description="Minimum allowed absolute parent level. Example: Absolute parent level 1 of '/foo/bar/test' is '/foo/bar'.", required=true)
        public int minLevel() default 1;

        @AttributeDefinition(name="Max. Level", description="Maximum allowed absolute parent level. Example: Absolute parent level 1 of '/foo/bar/test' is '/foo/bar'.", required=true)
        public int maxLevel() default 5;

        @AttributeDefinition(name="Context path expression", description="Expression to match context paths. Only context paths matching this expression are allowed. Use groups to reference them in configPathPatterns.", required=true)
        public String contextPathRegex() default "^/content(/.+)$";

        @AttributeDefinition(name="Config path patterns", description="Expression to derive the config path from the context path. Regex group references like $1 can be used.", required=true)
        public String[] configPathPatterns() default {"/conf$1"};

        @AttributeDefinition(name="Service Ranking", description="Priority of context path strategy (higher = higher priority).")
        public int service_ranking() default 2000;

        public String webconsole_configurationFactory_nameHint() default "{applicationId} templates={templatePaths}";
    }
}

