/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.extensions.persistence.impl;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import io.wcm.caconfig.extensions.persistence.impl.PersistenceUtils;
import java.util.Map;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.caconfig.management.ConfigurationManagementSettings;
import org.apache.sling.caconfig.spi.ConfigurationCollectionPersistData;
import org.apache.sling.caconfig.spi.ConfigurationPersistData;
import org.apache.sling.caconfig.spi.ConfigurationPersistenceStrategy2;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ConfigurationPersistenceStrategy2.class})
@Designate(ocd=Config.class)
public class PagePersistenceStrategy
implements ConfigurationPersistenceStrategy2 {
    private static final String DEFAULT_CONFIG_NODE_TYPE = "nt:unstructured";
    private static final Logger log = LoggerFactory.getLogger(PagePersistenceStrategy.class);
    @Reference
    private ConfigurationManagementSettings configurationManagementSettings;
    private boolean enabled;

    @Activate
    void activate(Config value) {
        this.enabled = value.enabled();
    }

    public Resource getResource(Resource resource) {
        if (!this.enabled) {
            return null;
        }
        if (PersistenceUtils.containsJcrContent(resource.getPath())) {
            return resource;
        }
        return resource.getChild("jcr:content");
    }

    public Resource getCollectionParentResource(Resource resource) {
        if (!this.enabled) {
            return null;
        }
        return resource;
    }

    public Resource getCollectionItemResource(Resource resource) {
        return this.getResource(resource);
    }

    public String getResourcePath(String resourcePath) {
        if (!this.enabled) {
            return null;
        }
        if (PersistenceUtils.containsJcrContent(resourcePath)) {
            return resourcePath;
        }
        return resourcePath + "/" + "jcr:content";
    }

    public String getCollectionParentResourcePath(String resourcePath) {
        if (!this.enabled) {
            return null;
        }
        return resourcePath;
    }

    public String getCollectionItemResourcePath(String resourcePath) {
        return this.getResourcePath(resourcePath);
    }

    public String getConfigName(String configName, String relatedConfigPath) {
        if (!this.enabled) {
            return null;
        }
        if (PersistenceUtils.containsJcrContent(configName)) {
            return configName;
        }
        return configName + "/" + "jcr:content";
    }

    public String getCollectionParentConfigName(String configName, String relatedConfigPath) {
        if (!this.enabled) {
            return null;
        }
        return configName;
    }

    public String getCollectionItemConfigName(String configName, String relatedConfigPath) {
        return this.getConfigName(configName, relatedConfigPath);
    }

    public boolean persistConfiguration(ResourceResolver resolver, String configResourcePath, ConfigurationPersistData data) {
        if (!this.enabled) {
            return false;
        }
        String path = this.getResourcePath(configResourcePath);
        PersistenceUtils.ensureContainingPage(resolver, path, this.configurationManagementSettings);
        PersistenceUtils.getOrCreateResource(resolver, path, DEFAULT_CONFIG_NODE_TYPE, data.getProperties(), this.configurationManagementSettings);
        PersistenceUtils.updatePageLastMod(resolver, path);
        PersistenceUtils.commit(resolver, configResourcePath);
        return true;
    }

    public boolean persistConfigurationCollection(ResourceResolver resolver, String configResourceCollectionParentPath, ConfigurationCollectionPersistData data) {
        if (!this.enabled) {
            return false;
        }
        String parentPath = this.getCollectionParentResourcePath(configResourceCollectionParentPath);
        Resource configResourceParent = PersistenceUtils.getOrCreateResource(resolver, parentPath, DEFAULT_CONFIG_NODE_TYPE, (Map<String, Object>)ValueMap.EMPTY, this.configurationManagementSettings);
        PersistenceUtils.deleteChildrenNotInCollection(configResourceParent, data);
        for (ConfigurationPersistData item : data.getItems()) {
            String path = this.getCollectionItemResourcePath(parentPath + "/" + item.getCollectionItemName());
            PersistenceUtils.ensureContainingPage(resolver, path, this.configurationManagementSettings);
            PersistenceUtils.getOrCreateResource(resolver, path, DEFAULT_CONFIG_NODE_TYPE, item.getProperties(), this.configurationManagementSettings);
            PersistenceUtils.updatePageLastMod(resolver, path);
        }
        if (data.getProperties() != null) {
            PersistenceUtils.replaceProperties(configResourceParent, data.getProperties(), this.configurationManagementSettings);
        }
        PersistenceUtils.commit(resolver, configResourceCollectionParentPath);
        return true;
    }

    public boolean deleteConfiguration(ResourceResolver resolver, String configResourcePath) {
        if (!this.enabled) {
            return false;
        }
        Resource configResource = resolver.getResource(configResourcePath);
        if (configResource != null) {
            Page configPage = (Page)configResource.adaptTo(Page.class);
            if (configPage != null) {
                try {
                    log.trace("! Delete page {}", (Object)configPage.getPath());
                    PageManager pageManager = configPage.getPageManager();
                    pageManager.delete(configPage, false);
                }
                catch (WCMException ex) {
                    throw PersistenceUtils.convertWCMException("Unable to delete configuration page at " + configResourcePath, ex);
                }
            }
            try {
                log.trace("! Delete resource {}", (Object)configResource.getPath());
                resolver.delete(configResource);
            }
            catch (PersistenceException ex) {
                throw PersistenceUtils.convertPersistenceException("Unable to delete configuration resource at " + configResourcePath, ex);
            }
        }
        PersistenceUtils.updatePageLastMod(resolver, configResourcePath);
        PersistenceUtils.commit(resolver, configResourcePath);
        return true;
    }

    @ObjectClassDefinition(name="wcm.io Context-Aware Configuration Persistence Strategy: AEM Page", description="Stores Context-Aware Configuration in AEM pages instead of simple resources.")
    static @interface Config {
        @AttributeDefinition(name="Enabled", description="Enable this persistence strategy.")
        public boolean enabled() default false;

        @AttributeDefinition(name="Service Ranking", description="Priority of persistence strategy (higher = higher priority).")
        public int service_ranking() default 1500;
    }
}

