/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.extensions.references.impl;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.reference.ReferenceProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.caconfig.management.ConfigurationManager;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationResourceResolvingStrategyMultiplexer;
import org.apache.sling.caconfig.spi.metadata.ConfigurationMetadata;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ReferenceProvider.class})
@Designate(ocd=Config.class)
public class ConfigurationReferenceProvider
implements ReferenceProvider {
    static final String REFERENCE_TYPE = "caconfig";
    @Reference
    private ConfigurationManager configurationManager;
    @Reference
    private ConfigurationResourceResolvingStrategyMultiplexer configurationResourceResolvingStrategy;
    @Reference
    private ConfigurationAdmin configAdmin;
    private boolean enabled;
    private static final Logger log = LoggerFactory.getLogger(ConfigurationReferenceProvider.class);

    @Activate
    protected void activate(Config config) {
        this.enabled = config.enabled();
    }

    @Deactivate
    protected void deactivate() {
        this.enabled = false;
    }

    public List<com.day.cq.wcm.api.reference.Reference> findReferences(Resource resource) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        SortedSet configurationNames = this.configurationManager.getConfigurationNames();
        ArrayList<com.day.cq.wcm.api.reference.Reference> references = new ArrayList<com.day.cq.wcm.api.reference.Reference>(configurationNames.size());
        Collection<String> configurationBuckets = this.getBucketNames();
        for (String configurationName : configurationNames) {
            ConfigurationMetadata configurationMetadata = this.configurationManager.getConfigurationMetadata(configurationName);
            Iterator configurationInheritanceChain = this.configurationResourceResolvingStrategy.getResourceInheritanceChain(resource, configurationBuckets, configurationName);
            while (configurationInheritanceChain != null && configurationInheritanceChain.hasNext()) {
                Resource configurationResource = (Resource)configurationInheritanceChain.next();
                log.trace("Found configuration reference {} for resource {}", new Object[]{configurationResource.getPath(), configurationName, resource.getPath()});
                references.add(new com.day.cq.wcm.api.reference.Reference(ConfigurationReferenceProvider.getType(), ConfigurationReferenceProvider.getReferenceName(configurationMetadata), configurationResource, ConfigurationReferenceProvider.getLastModifiedOf(configurationResource)));
            }
        }
        log.debug("Found {} references for resource {}", (Object)references.size(), (Object)resource.getPath());
        return references;
    }

    private static String getReferenceName(ConfigurationMetadata configurationMetadata) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)configurationMetadata.getLabel(), (CharSequence)configurationMetadata.getName());
    }

    private static long getLastModifiedOf(Resource configurationResource) {
        Calendar lastModified;
        Page configurationPage = (Page)configurationResource.adaptTo(Page.class);
        if (configurationPage == null && StringUtils.equals((CharSequence)configurationResource.getName(), (CharSequence)"jcr:content")) {
            configurationPage = (Page)configurationResource.getParent().adaptTo(Page.class);
        }
        if (configurationPage != null && configurationPage.getLastModified() != null) {
            lastModified = configurationPage.getLastModified();
        } else {
            ValueMap properties = configurationResource.getValueMap();
            lastModified = (Calendar)properties.get("jcr:lastModified", Calendar.class);
        }
        return lastModified != null ? lastModified.getTimeInMillis() : 0L;
    }

    private static String getType() {
        return REFERENCE_TYPE;
    }

    private Collection<String> getBucketNames() {
        ArrayList<String> bucketNames = new ArrayList<String>();
        bucketNames.add("sling:configs");
        try {
            String[] addtlBucketNames;
            Configuration configResolverConfig = this.configAdmin.getConfiguration("org.apache.sling.caconfig.impl.ConfigurationResolverImpl");
            if (configResolverConfig != null && configResolverConfig.getProperties() != null && (addtlBucketNames = PropertiesUtil.toStringArray(configResolverConfig.getProperties().get("configBucketNames"))) != null && addtlBucketNames.length > 0) {
                bucketNames.addAll(Arrays.asList(addtlBucketNames));
            }
        }
        catch (IOException ex) {
            log.warn("Error accessing OSGi config.", (Throwable)ex);
        }
        return bucketNames;
    }

    @ObjectClassDefinition(name="wcm.io Context-Aware Configuration Reference Provider", description="Allows to resolve references from resources to their Context-Aware configurations, for example during page activation.")
    static @interface Config {
        @AttributeDefinition(name="Enabled", description="Enable this reference provider.")
        public boolean enabled() default true;
    }
}

