/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.extensions.contextpath.impl;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.caconfig.resource.spi.ContextPathStrategy;
import org.apache.sling.caconfig.resource.spi.ContextResource;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wcmiocaconfigextensions.io.wcm.wcm.commons.util.Path;

@Component(service={ContextPathStrategy.class})
@Designate(ocd=Config.class, factory=true)
public class AbsoluteParentContextPathStrategy
implements ContextPathStrategy {
    private Set<Integer> levels;
    private int unlimitedLevelStart;
    private boolean unlimited;
    private Pattern contextPathRegex;
    private Pattern contextPathBlacklistRegex;
    private String[] configPathPatterns;
    private int serviceRanking;
    private Set<String> templatePathsBlacklist;
    private static final Logger log = LoggerFactory.getLogger(AbsoluteParentContextPathStrategy.class);

    @Activate
    void activate(Config config) {
        this.levels = new TreeSet<Integer>();
        if (config.levels() != null) {
            for (int level : config.levels()) {
                this.levels.add(level);
                if (level < this.unlimitedLevelStart) continue;
                this.unlimitedLevelStart = level + 1;
            }
        }
        this.unlimited = config.unlimited();
        try {
            this.contextPathRegex = Pattern.compile(config.contextPathRegex());
        }
        catch (PatternSyntaxException ex) {
            log.warn("Invalid context path regex: " + config.contextPathRegex(), (Throwable)ex);
        }
        if (StringUtils.isNotEmpty((CharSequence)config.contextPathBlacklistRegex())) {
            try {
                this.contextPathBlacklistRegex = Pattern.compile(config.contextPathBlacklistRegex());
            }
            catch (PatternSyntaxException ex) {
                log.warn("Invalid context path blacklist regex: " + config.contextPathBlacklistRegex(), (Throwable)ex);
            }
        }
        this.configPathPatterns = config.configPathPatterns();
        this.serviceRanking = config.service_ranking();
        this.templatePathsBlacklist = config.templatePathsBlacklist() != null ? new HashSet<String>(Arrays.asList(config.templatePathsBlacklist())) : Collections.emptySet();
    }

    @NotNull
    public Iterator<ContextResource> findContextResources(@NotNull Resource resource) {
        if (!this.isValidConfig()) {
            return Collections.emptyIterator();
        }
        ResourceResolver resourceResolver = resource.getResourceResolver();
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        ArrayList<ContextResource> contextResources = new ArrayList<ContextResource>();
        int maxLevel = Path.getAbsoluteLevel(resource.getPath(), resourceResolver);
        for (int level = 0; level <= maxLevel; ++level) {
            Resource contextResource;
            String contextPath;
            if (!this.levels.contains(level) && (!this.unlimited || level < this.unlimitedLevelStart) || !StringUtils.isNotEmpty((CharSequence)(contextPath = Path.getAbsoluteParent(resource.getPath(), level, resourceResolver))) || (contextResource = resource.getResourceResolver().getResource(contextPath)) == null) continue;
            if (this.isResourceBelongingToBlacklistedTemplates(contextResource, pageManager)) {
                log.trace("Resource '{}' is belonging to a page derived from a blacklisted template, skipping level {}", (Object)contextPath, (Object)level);
                break;
            }
            for (String configPathPattern : this.configPathPatterns) {
                String configRef = this.deriveConfigRef(contextPath, configPathPattern, resourceResolver);
                if (configRef == null) continue;
                contextResources.add(new ContextResource(contextResource, configRef, this.serviceRanking));
            }
        }
        Collections.reverse(contextResources);
        return contextResources.iterator();
    }

    private boolean isValidConfig() {
        return !this.levels.isEmpty() && this.contextPathRegex != null && this.configPathPatterns != null && this.configPathPatterns.length > 0;
    }

    private String deriveConfigRef(String contextPath, String configPathPattern, ResourceResolver resourceResolver) {
        Matcher matcher = this.contextPathRegex.matcher(Path.getOriginalPath(contextPath, resourceResolver));
        Matcher blacklistMatcher = null;
        if (this.contextPathBlacklistRegex != null) {
            blacklistMatcher = this.contextPathBlacklistRegex.matcher(contextPath);
        }
        if (matcher.matches() && (blacklistMatcher == null || !blacklistMatcher.matches())) {
            return matcher.replaceAll(configPathPattern);
        }
        return null;
    }

    private boolean isResourceBelongingToBlacklistedTemplates(Resource resource, PageManager pageManager) {
        if (this.templatePathsBlacklist.isEmpty()) {
            return false;
        }
        Page page = pageManager.getContainingPage(resource);
        if (page == null) {
            log.trace("Resource '{}' is not part of page, blacklisted templates are not considered.", (Object)resource.getPath());
            return false;
        }
        String templatePath = (String)page.getProperties().get("cq:template", String.class);
        if (templatePath != null) {
            if (this.templatePathsBlacklist.contains(templatePath)) {
                return true;
            }
        } else {
            log.trace("Resource '{}' is part of page '{}' which doesn't contain any template property, blacklisted templates are not considered.", (Object)resource.getPath(), (Object)page.getPath());
            return false;
        }
        log.trace("Resource '{}' is part of page '{}' but is not based on any of the blacklisted templates.", (Object)resource.getPath(), (Object)page.getPath());
        return false;
    }

    @ObjectClassDefinition(name="wcm.io Context-Aware Configuration Context Path Strategy: Absolute Parents", description="Detects context paths by absolute parent levels of a context resource.")
    static @interface Config {
        @AttributeDefinition(name="Absolute Levels", description="List of absolute parent levels. Example: Absolute parent level 1 of '/foo/bar/test' is '/foo/bar'.", required=true)
        public int[] levels();

        @AttributeDefinition(name="Unlimited levels", description="If set to true, the 'Absolute Levels' define only the minimum levels. Above the highest level number every additional level is accepted as well.")
        public boolean unlimited() default false;

        @AttributeDefinition(name="Context path whitelist", description="Expression to match context paths. Context paths matching this expression are allowed. Use groups to reference them in configPathPatterns.", required=true)
        public String contextPathRegex() default "^/content(/.+)$";

        @AttributeDefinition(name="Context path blacklist", description="Expression to match context paths. Context paths matching this expression are not allowed.", required=true)
        public String contextPathBlacklistRegex() default "^.*/tools(/config(/.+)?)?$";

        @AttributeDefinition(name="Template path blacklist", description="Context paths belonging to a page matching one of the given template paths are not allowed.", required=true)
        public String[] templatePathsBlacklist();

        @AttributeDefinition(name="Config path patterns", description="Expression to derive the config path from the context path. Regex group references like $1 can be used.", required=true)
        public String[] configPathPatterns() default {"/conf$1"};

        @AttributeDefinition(name="Service Ranking", description="Priority of context path strategy (higher = higher priority).")
        public int service_ranking() default 2000;

        public String webconsole_configurationFactory_nameHint() default "levels={levels}, path={contextPathRegex}";
    }
}

