/*
 * Decompiled with CFR 0.152.
 */
package wcmiocaconfigextensions.io.wcm.wcm.commons.util;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.tenant.Tenant;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class Path {
    private static final String VERSION_HISTORY_PATH = "/tmp/versionhistory";
    private static final String LEGACY_VERSION_HISTORY_PATH = "/content/versionhistory";
    private static final String LAUNCHES_PATH = "/content/launches";
    private static final String EXPERIENCE_FRAGMENTS_PATH = "/content/experience-fragments";
    private static final Pattern VERSION_HISTORY_PATTERN = Pattern.compile("/tmp/versionhistory/[^/]+/[^/]+(/.*)?");
    private static final Pattern LEGACY_VERSION_HISTORY_PATTERN = Pattern.compile("/content/versionhistory/[^/]+(/.*)?");
    private static final Pattern LEGACY_VERSION_HISTORY_TENANT_PATTERN = Pattern.compile("/content/versionhistory/[^/]+/[^/]+(/.*)?");
    private static final Pattern LAUNCHES_PATTERN = Pattern.compile("/content/launches/\\d+/\\d+/\\d+/[^/]+(/.*)?");
    private static final Pattern EXPERIENCE_FRAGMENTS_PATTERN = Pattern.compile("^/content/experience-fragments/.*$");

    private Path() {
    }

    public static String getAbsoluteParent(@NotNull String path, int parentLevel, @NotNull ResourceResolver resourceResolver) {
        if (parentLevel < 0) {
            return "";
        }
        int level = parentLevel + Path.getAbsoluteLevelOffset(path, resourceResolver);
        return Text.getAbsoluteParent((String)path, (int)level);
    }

    public static Page getAbsoluteParent(@NotNull Page page, int parentLevel, @NotNull ResourceResolver resourceResolver) {
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        String absoluteParentPath = Path.getAbsoluteParent(page.getPath(), parentLevel, resourceResolver);
        if (StringUtils.isEmpty((CharSequence)absoluteParentPath)) {
            return null;
        }
        return pageManager.getPage(absoluteParentPath);
    }

    public static int getAbsoluteLevel(@NotNull String path, @NotNull ResourceResolver resourceResolver) {
        if (StringUtils.isEmpty((CharSequence)path) || StringUtils.equals((CharSequence)path, (CharSequence)"/")) {
            return -1;
        }
        String originalPath = Path.getOriginalPath(path, resourceResolver);
        return StringUtils.countMatches((CharSequence)originalPath, (CharSequence)"/") - 1;
    }

    public static String getOriginalPath(@NotNull String path, @NotNull ResourceResolver resourceResolver) {
        Matcher launchesMatcher;
        if (StringUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        Matcher versionHistoryMatcher = VERSION_HISTORY_PATTERN.matcher(path);
        if (versionHistoryMatcher.matches()) {
            return "/content" + versionHistoryMatcher.group(1);
        }
        Matcher legacyVersionHistoryMatcher = LEGACY_VERSION_HISTORY_PATTERN.matcher(path);
        if (legacyVersionHistoryMatcher.matches()) {
            if (Path.isTenant(resourceResolver)) {
                legacyVersionHistoryMatcher = LEGACY_VERSION_HISTORY_TENANT_PATTERN.matcher(path);
            }
            if (legacyVersionHistoryMatcher.matches()) {
                return "/content" + legacyVersionHistoryMatcher.group(1);
            }
        }
        if ((launchesMatcher = LAUNCHES_PATTERN.matcher(path)).matches()) {
            return launchesMatcher.group(1);
        }
        return path;
    }

    private static int getAbsoluteLevelOffset(@NotNull String path, @NotNull ResourceResolver resourceResolver) {
        Matcher versionHistoryMatcher = VERSION_HISTORY_PATTERN.matcher(path);
        if (versionHistoryMatcher.matches()) {
            return 3;
        }
        Matcher legacyVersionHistoryMatcher = LEGACY_VERSION_HISTORY_PATTERN.matcher(path);
        if (legacyVersionHistoryMatcher.matches()) {
            if (Path.isTenant(resourceResolver) && (legacyVersionHistoryMatcher = LEGACY_VERSION_HISTORY_TENANT_PATTERN.matcher(path)).matches()) {
                return 3;
            }
            return 2;
        }
        Matcher launchesMatcher = LAUNCHES_PATTERN.matcher(path);
        if (launchesMatcher.matches()) {
            return 6;
        }
        return 0;
    }

    private static boolean isTenant(@NotNull ResourceResolver resourceResolver) {
        Tenant tenant = (Tenant)resourceResolver.adaptTo(Tenant.class);
        return tenant != null;
    }

    public static boolean isExperienceFragmentPath(@NotNull String path) {
        return EXPERIENCE_FRAGMENTS_PATTERN.matcher(path).matches();
    }
}

