/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.extensions.contextpath.impl;

import io.wcm.caconfig.extensions.contextpath.impl.AbsoluteParentContextPathStrategy;
import io.wcm.caconfig.extensions.contextpath.impl.TestUtils;
import io.wcm.testing.mock.aem.junit5.AemContext;
import io.wcm.testing.mock.aem.junit5.AemContextExtension;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.resource.spi.ContextPathStrategy;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extensions;
import org.mockito.junit.jupiter.MockitoExtension;

@Extensions(value={@ExtendWith(value={AemContextExtension.class}), @ExtendWith(value={MockitoExtension.class})})
class AbsoluteParentContextPathStrategyTest {
    final AemContext context = new AemContext();
    protected Resource level1;
    protected Resource level2;
    protected Resource level3;
    protected Resource level4;

    AbsoluteParentContextPathStrategyTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.level1 = (Resource)this.context.create().page("/content/region1").adaptTo(Resource.class);
        this.level2 = (Resource)this.context.create().page("/content/region1/site1").adaptTo(Resource.class);
        this.level3 = (Resource)this.context.create().page("/content/region1/site1/en").adaptTo(Resource.class);
        this.level4 = (Resource)this.context.create().page("/content/region1/site1/en/page1").adaptTo(Resource.class);
    }

    @Test
    void testWithInvalidConfig() {
        ContextPathStrategy underTest = (ContextPathStrategy)this.context.registerInjectActivateService((Object)new AbsoluteParentContextPathStrategy());
        TestUtils.assertNoResult(this.context, underTest.findContextResources(this.level4));
    }

    @Test
    void testWithLevels13() {
        ContextPathStrategy underTest = (ContextPathStrategy)this.context.registerInjectActivateService((Object)new AbsoluteParentContextPathStrategy(), new Object[]{"levels", new int[]{1, 3}});
        TestUtils.assertResult(this.context, underTest.findContextResources(this.level4), "/content/region1/site1/en", "/conf/region1/site1/en", "/content/region1", "/conf/region1");
        TestUtils.assertResult(this.context, underTest.findContextResources(this.level3), "/content/region1/site1/en", "/conf/region1/site1/en", "/content/region1", "/conf/region1");
        TestUtils.assertResult(this.context, underTest.findContextResources(this.level2), "/content/region1", "/conf/region1");
        TestUtils.assertResult(this.context, underTest.findContextResources(this.level1), "/content/region1", "/conf/region1");
    }

    @Test
    void testWithLevels13_Unlimited() {
        ContextPathStrategy underTest = (ContextPathStrategy)this.context.registerInjectActivateService((Object)new AbsoluteParentContextPathStrategy(), new Object[]{"levels", new int[]{1, 3}, "unlimited", true});
        TestUtils.assertResult(this.context, underTest.findContextResources(this.level4), "/content/region1/site1/en/page1", "/conf/region1/site1/en/page1", "/content/region1/site1/en", "/conf/region1/site1/en", "/content/region1", "/conf/region1");
        TestUtils.assertResult(this.context, underTest.findContextResources(this.level3), "/content/region1/site1/en", "/conf/region1/site1/en", "/content/region1", "/conf/region1");
        TestUtils.assertResult(this.context, underTest.findContextResources(this.level2), "/content/region1", "/conf/region1");
        TestUtils.assertResult(this.context, underTest.findContextResources(this.level1), "/content/region1", "/conf/region1");
    }

    @Test
    void testWithLevels1_Unlimited() {
        ContextPathStrategy underTest = (ContextPathStrategy)this.context.registerInjectActivateService((Object)new AbsoluteParentContextPathStrategy(), new Object[]{"levels", new int[]{1}, "unlimited", true});
        TestUtils.assertResult(this.context, underTest.findContextResources(this.level4), "/content/region1/site1/en/page1", "/conf/region1/site1/en/page1", "/content/region1/site1/en", "/conf/region1/site1/en", "/content/region1/site1", "/conf/region1/site1", "/content/region1", "/conf/region1");
        TestUtils.assertResult(this.context, underTest.findContextResources(this.level3), "/content/region1/site1/en", "/conf/region1/site1/en", "/content/region1/site1", "/conf/region1/site1", "/content/region1", "/conf/region1");
        TestUtils.assertResult(this.context, underTest.findContextResources(this.level2), "/content/region1/site1", "/conf/region1/site1", "/content/region1", "/conf/region1");
        TestUtils.assertResult(this.context, underTest.findContextResources(this.level1), "/content/region1", "/conf/region1");
    }

    @Test
    void testWithAlternativePatterns() {
        ContextPathStrategy underTest = (ContextPathStrategy)this.context.registerInjectActivateService((Object)new AbsoluteParentContextPathStrategy(), new Object[]{"levels", new int[]{1, 3}, "contextPathRegex", "^(/content/.+)$", "contextPathBlacklistRegex", "^.*/region\\d+?$", "configPathPatterns", new String[]{"/conf/test1$1", "/conf/test2$1"}});
        TestUtils.assertResult(this.context, underTest.findContextResources(this.level4), "/content/region1/site1/en", "/conf/test2/content/region1/site1/en", "/content/region1/site1/en", "/conf/test1/content/region1/site1/en");
    }

    @Test
    void testWithConfigChildPagesBlacklistedByPath() {
        Resource level1Config = this.context.create().page("/content/region1/config").getContentResource();
        Resource level2Config = this.context.create().page("/content/region1/site1/config").getContentResource();
        Resource level3Config = this.context.create().page("/content/region1/site1/en/config").getContentResource();
        Resource level4Config = this.context.create().page("/content/region1/site1/en/page1/config").getContentResource();
        ContextPathStrategy underTest = (ContextPathStrategy)this.context.registerInjectActivateService((Object)new AbsoluteParentContextPathStrategy(), new Object[]{"levels", new int[]{1, 3}, "contextPathBlacklistRegex", "^.*/config(/.+)?$"});
        TestUtils.assertResult(this.context, underTest.findContextResources(level4Config), "/content/region1/site1/en", "/conf/region1/site1/en", "/content/region1", "/conf/region1");
        TestUtils.assertResult(this.context, underTest.findContextResources(level3Config), "/content/region1/site1/en", "/conf/region1/site1/en", "/content/region1", "/conf/region1");
        TestUtils.assertResult(this.context, underTest.findContextResources(level2Config), "/content/region1", "/conf/region1");
        TestUtils.assertResult(this.context, underTest.findContextResources(level1Config), "/content/region1", "/conf/region1");
    }

    @Test
    void testWithConfigChildPagesBlacklistedByTemplate() {
        Resource level1Config = this.context.create().page("/content/region1/myconfig", "/apps/myapp/templates/caconfig-editor").getContentResource();
        Resource level2Config = this.context.create().page("/content/region1/site1/config", "/apps/myapp/templates/some-other-template").getContentResource();
        Resource level3Config = this.context.create().page("/content/region1/site1/en/other-config", "/apps/myapp/templates/caconfig-editor").getContentResource();
        Resource level4Config = this.context.create().page("/content/region1/site1/en/page1/lastconfig", "/apps/myapp/templates/caconfig-editor").getContentResource();
        ContextPathStrategy underTest = (ContextPathStrategy)this.context.registerInjectActivateService((Object)new AbsoluteParentContextPathStrategy(), new Object[]{"levels", new int[]{1, 3}, "contextPathBlacklistRegex", "^.*/config(/.+)?$", "templatePathsBlacklist", new String[]{"/apps/myapp/templates/caconfig-editor"}});
        TestUtils.assertResult(this.context, underTest.findContextResources(level4Config), "/content/region1/site1/en", "/conf/region1/site1/en", "/content/region1", "/conf/region1");
        TestUtils.assertResult(this.context, underTest.findContextResources(level3Config), "/content/region1/site1/en", "/conf/region1/site1/en", "/content/region1", "/conf/region1");
        TestUtils.assertResult(this.context, underTest.findContextResources(level2Config), "/content/region1", "/conf/region1");
        TestUtils.assertResult(this.context, underTest.findContextResources(level1Config), "/content/region1", "/conf/region1");
    }
}

