/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.extensions.contextpath.impl;

import io.wcm.caconfig.extensions.contextpath.impl.RootTemplateContextPathStrategy;
import io.wcm.caconfig.extensions.contextpath.impl.TestUtils;
import io.wcm.testing.mock.aem.junit5.AemContext;
import io.wcm.testing.mock.aem.junit5.AemContextExtension;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.resource.spi.ContextPathStrategy;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extensions;
import org.mockito.junit.jupiter.MockitoExtension;

@Extensions(value={@ExtendWith(value={AemContextExtension.class}), @ExtendWith(value={MockitoExtension.class})})
class RootTemplateContextPathStrategyTest {
    static final String TEMPLATE_1 = "/apps/app1/templates/template1";
    static final String TEMPLATE_2 = "/apps/app1/templates/template2";
    final AemContext context = new AemContext();
    protected Resource level1;
    protected Resource level2;
    protected Resource level3;
    protected Resource level4;

    RootTemplateContextPathStrategyTest() {
    }

    @BeforeEach
    void setUp() {
        this.level1 = (Resource)this.context.create().page("/content/region1").adaptTo(Resource.class);
        this.level2 = (Resource)this.context.create().page("/content/region1/site1", TEMPLATE_1).adaptTo(Resource.class);
        this.level3 = (Resource)this.context.create().page("/content/region1/site1/en", TEMPLATE_2).adaptTo(Resource.class);
        this.level4 = (Resource)this.context.create().page("/content/region1/site1/en/page1").adaptTo(Resource.class);
    }

    @Test
    void testWithInvalidConfig() {
        ContextPathStrategy underTest = (ContextPathStrategy)this.context.registerInjectActivateService((Object)new RootTemplateContextPathStrategy());
        TestUtils.assertNoResult(this.context, underTest.findContextResources(this.level4));
    }

    @Test
    void testWithTemplate() {
        ContextPathStrategy underTest = (ContextPathStrategy)this.context.registerInjectActivateService((Object)new RootTemplateContextPathStrategy(), new Object[]{"templatePaths", new String[]{TEMPLATE_1}});
        TestUtils.assertResult(this.context, underTest.findContextResources(this.level4), "/content/region1/site1", "/conf/region1/site1", "/content/region1", "/conf/region1");
        TestUtils.assertResult(this.context, underTest.findContextResources(this.level3), "/content/region1/site1", "/conf/region1/site1", "/content/region1", "/conf/region1");
        TestUtils.assertResult(this.context, underTest.findContextResources(this.level2), "/content/region1/site1", "/conf/region1/site1", "/content/region1", "/conf/region1");
        TestUtils.assertResult(this.context, underTest.findContextResources(this.level1), "/content/region1", "/conf/region1");
    }

    @Test
    void testWithAlternativePatterns() {
        ContextPathStrategy underTest = (ContextPathStrategy)this.context.registerInjectActivateService((Object)new RootTemplateContextPathStrategy(), new Object[]{"templatePaths", new String[]{TEMPLATE_1}, "contextPathRegex", "^(/content/.+)$", "configPathPatterns", new String[]{"/conf/test1$1", "/conf/test2$1"}});
        TestUtils.assertResult(this.context, underTest.findContextResources(this.level4), "/content/region1/site1", "/conf/test2/content/region1/site1", "/content/region1/site1", "/conf/test1/content/region1/site1", "/content/region1", "/conf/test2/content/region1", "/content/region1", "/conf/test1/content/region1");
    }

    @Test
    void testWithTemplate_TemplatMatchAllLevels() {
        ContextPathStrategy underTest = (ContextPathStrategy)this.context.registerInjectActivateService((Object)new RootTemplateContextPathStrategy(), new Object[]{"templatePaths", new String[]{TEMPLATE_1, TEMPLATE_2}, "templateMatchAllLevels", true});
        TestUtils.assertResult(this.context, underTest.findContextResources(this.level4), "/content/region1/site1/en", "/conf/region1/site1/en", "/content/region1/site1", "/conf/region1/site1");
        TestUtils.assertResult(this.context, underTest.findContextResources(this.level3), "/content/region1/site1/en", "/conf/region1/site1/en", "/content/region1/site1", "/conf/region1/site1");
        TestUtils.assertResult(this.context, underTest.findContextResources(this.level2), "/content/region1/site1", "/conf/region1/site1");
        TestUtils.assertResult(this.context, underTest.findContextResources(this.level1), new String[0]);
    }
}

