/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.extensions.contextpath.impl;

import com.google.common.collect.ImmutableList;
import io.wcm.testing.mock.aem.junit5.AemContext;
import io.wcm.wcm.commons.util.Path;
import java.util.Iterator;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.caconfig.resource.spi.ContextResource;
import org.junit.jupiter.api.Assertions;

final class TestUtils {
    private TestUtils() {
    }

    public static void assertNoResult(AemContext context, Iterator<ContextResource> result) {
        TestUtils.assertResult(context, result, new String[0]);
    }

    public static void assertResult(AemContext context, Iterator<ContextResource> result, String ... paths) {
        if (paths.length % 2 != 0) {
            throw new IllegalArgumentException("Expected path pairs.");
        }
        ImmutableList resultList = ImmutableList.copyOf(result);
        int expectedSize = paths.length / 2;
        Assertions.assertEquals((int)expectedSize, (int)resultList.size(), (String)"Number of paths");
        for (int i = 0; i < expectedSize / 2; ++i) {
            String expectedContextPath = paths[i * 2];
            String expectedConfigRef = paths[i * 2 + 1];
            Assertions.assertEquals((Object)expectedContextPath, (Object)Path.getOriginalPath((String)((ContextResource)resultList.get(i)).getResource().getPath(), (ResourceResolver)context.resourceResolver()));
            Assertions.assertEquals((Object)expectedConfigRef, (Object)((ContextResource)resultList.get(i)).getConfigRef());
        }
    }
}

