/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.extensions.override.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.wcm.caconfig.extensions.override.impl.RequestHeaderConfigurationOverrideProvider;
import io.wcm.sling.commons.request.RequestContext;
import io.wcm.sling.models.injectors.impl.AemObjectInjector;
import io.wcm.sling.models.injectors.impl.ModelsImplConfiguration;
import io.wcm.sling.models.injectors.impl.SlingObjectOverlayInjector;
import io.wcm.testing.mock.aem.junit5.AemContext;
import io.wcm.testing.mock.aem.junit5.AemContextBuilder;
import io.wcm.testing.mock.aem.junit5.AemContextExtension;
import io.wcm.testing.mock.wcmio.sling.MockRequestContext;
import java.util.Map;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.testing.mock.osgi.context.ContextCallback;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={AemContextExtension.class})
class RequestHeaderConfigurationOverrideProviderTest {
    private static final String HEADER_NAME = "testHeaderName";
    private final AemContext context = new AemContextBuilder().beforeSetUp(new ContextCallback[]{aemContext -> {
        aemContext.registerService(RequestContext.class, (Object)new MockRequestContext());
        aemContext.registerInjectActivateService((Object)new ModelsImplConfiguration(), (Map)ImmutableMap.of((Object)"requestThreadLocal", (Object)true));
        aemContext.registerInjectActivateService((Object)new AemObjectInjector());
        aemContext.registerInjectActivateService((Object)new SlingObjectOverlayInjector());
    }}).build();

    RequestHeaderConfigurationOverrideProviderTest() {
    }

    @BeforeEach
    void setUp() {
        MockRequestContext requestContext = (MockRequestContext)this.context.getService(RequestContext.class);
        requestContext.setRequest((SlingHttpServletRequest)this.context.request());
        this.context.request().addHeader(HEADER_NAME, "param1=value1");
        this.context.request().addHeader(HEADER_NAME, "[/content/path1]param2=value2");
    }

    @Test
    void testEnabled() {
        RequestHeaderConfigurationOverrideProvider provider = (RequestHeaderConfigurationOverrideProvider)this.context.registerInjectActivateService((Object)new RequestHeaderConfigurationOverrideProvider(), new Object[]{"enabled", true, "headerName", HEADER_NAME});
        Assertions.assertEquals((Object)ImmutableList.of((Object)"param1=value1", (Object)"[/content/path1]param2=value2"), (Object)provider.getOverrideStrings());
    }

    @Test
    void testDisabled() {
        RequestHeaderConfigurationOverrideProvider provider = (RequestHeaderConfigurationOverrideProvider)this.context.registerInjectActivateService((Object)new RequestHeaderConfigurationOverrideProvider(), new Object[]{"enabled", false});
        Assertions.assertTrue((boolean)provider.getOverrideStrings().isEmpty());
    }
}

