/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.extensions.persistence.impl;

import com.day.cq.wcm.api.Page;
import com.google.common.collect.ImmutableList;
import io.wcm.caconfig.extensions.persistence.example.ListConfig;
import io.wcm.caconfig.extensions.persistence.example.ListNestedConfig;
import io.wcm.caconfig.extensions.persistence.example.NestedConfig;
import io.wcm.caconfig.extensions.persistence.example.SimpleConfig;
import io.wcm.caconfig.extensions.persistence.example.wcon60.FooterConfig;
import io.wcm.caconfig.extensions.persistence.example.wcon60.MenuConfig;
import io.wcm.caconfig.extensions.persistence.example.wcon60.MenuLinkConfig;
import io.wcm.caconfig.extensions.persistence.impl.PagePersistenceStrategy;
import io.wcm.caconfig.extensions.persistence.testcontext.PersistenceTestUtils;
import io.wcm.sling.commons.resource.ImmutableValueMap;
import io.wcm.testing.mock.aem.junit5.AemContext;
import io.wcm.testing.mock.aem.junit5.AemContextBuilder;
import io.wcm.testing.mock.aem.junit5.AemContextCallback;
import io.wcm.testing.mock.aem.junit5.AemContextExtension;
import java.util.Collection;
import java.util.Map;
import org.apache.sling.caconfig.ConfigurationBuilder;
import org.apache.sling.caconfig.management.ConfigurationManager;
import org.apache.sling.hamcrest.ResourceMatchers;
import org.apache.sling.testing.mock.caconfig.ContextPlugins;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.osgi.context.ContextCallback;
import org.apache.sling.testing.mock.osgi.context.ContextPlugin;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.osgi.framework.BundleContext;

@ExtendWith(value={AemContextExtension.class})
class PagePersistenceStrategyTest {
    final AemContext context = new AemContextBuilder().beforeSetUp(new ContextCallback[]{new AemContextCallback(){

        public void execute(@NotNull AemContext ctx) {
            MockOsgi.setConfigForPid((BundleContext)ctx.bundleContext(), (String)"org.apache.sling.caconfig.resource.impl.def.DefaultContextPathStrategy", (Object[])new Object[]{"configRefResourceNames", new String[]{"jcr:content", "."}});
            MockOsgi.setConfigForPid((BundleContext)ctx.bundleContext(), (String)"org.apache.sling.caconfig.management.impl.ConfigurationManagementSettingsImpl", (Object[])new Object[]{"ignorePropertyNameRegex", new String[]{"^(jcr|cq):.+", "^sling:resourceType$"}, "configCollectionPropertiesResourceNames", new String[]{"jcr:content", "."}});
        }
    }}).plugin(new ContextPlugin[]{ContextPlugins.CACONFIG}).build();
    private Page contentPage;

    PagePersistenceStrategyTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.context.create().resource("/conf");
        this.contentPage = this.context.create().page("/content/test/site1", "/apps/app1/templates/template1", (Map)ImmutableValueMap.of((String)"sling:configRef", (Object)"/conf/test/site1"));
    }

    @Test
    void testSimpleConfig() throws Exception {
        this.context.registerInjectActivateService((Object)new PagePersistenceStrategy(), new Object[]{"enabled", true});
        PersistenceTestUtils.writeConfiguration(this.context, this.contentPage.getPath(), SimpleConfig.class.getName(), "stringParam", "value1", "intParam", 123);
        Page configPage = this.context.pageManager().getPage("/conf/test/site1/sling:configs/" + SimpleConfig.class.getName());
        MatcherAssert.assertThat((Object)configPage.getContentResource(), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value1", "intParam", 123}));
        SimpleConfig config = (SimpleConfig)((ConfigurationBuilder)this.contentPage.getContentResource().adaptTo(ConfigurationBuilder.class)).as(SimpleConfig.class);
        Assertions.assertEquals((Object)"value1", (Object)config.stringParam());
        Assertions.assertEquals((int)123, (int)config.intParam());
        ConfigurationManager configManager = (ConfigurationManager)this.context.getService(ConfigurationManager.class);
        configManager.deleteConfiguration(this.contentPage.getContentResource(), SimpleConfig.class.getName());
        config = (SimpleConfig)((ConfigurationBuilder)this.contentPage.getContentResource().adaptTo(ConfigurationBuilder.class)).as(SimpleConfig.class);
        Assertions.assertNull((Object)config.stringParam());
        Assertions.assertEquals((int)5, (int)config.intParam());
    }

    @Test
    void testSimpleConfig_Disabled() throws Exception {
        this.context.registerInjectActivateService((Object)new PagePersistenceStrategy(), new Object[]{"enabled", false});
        PersistenceTestUtils.writeConfiguration(this.context, this.contentPage.getPath(), SimpleConfig.class.getName(), "stringParam", "value1", "intParam", 123);
        Page configPage = this.context.pageManager().getPage("/conf/test/site1/sling:configs/" + SimpleConfig.class.getName());
        Assertions.assertNull((Object)configPage);
        SimpleConfig config = (SimpleConfig)((ConfigurationBuilder)this.contentPage.getContentResource().adaptTo(ConfigurationBuilder.class)).as(SimpleConfig.class);
        Assertions.assertEquals((Object)"value1", (Object)config.stringParam());
        Assertions.assertEquals((int)123, (int)config.intParam());
    }

    @Test
    void testListConfig() throws Exception {
        this.context.registerInjectActivateService((Object)new PagePersistenceStrategy(), new Object[]{"enabled", true});
        PersistenceTestUtils.writeConfigurationCollection(this.context, this.contentPage.getPath(), ListConfig.class.getName(), (Collection<Map<String, Object>>)ImmutableList.of((Object)ImmutableValueMap.of((String)"stringParam", (Object)"value1", (String)"intParam", (Object)123), (Object)ImmutableValueMap.of((String)"stringParam", (Object)"value2", (String)"intParam", (Object)234)), (Map<String, Object>)ImmutableValueMap.of((String)"sling:configCollectionInherit", (Object)true));
        Page parentPage = this.context.pageManager().getPage("/conf/test/site1/sling:configs/" + ListConfig.class.getName());
        Assertions.assertNotNull((Object)parentPage);
        Assertions.assertTrue((boolean)((Boolean)parentPage.getContentResource().getValueMap().get("sling:configCollectionInherit", (Object)false)));
        Page configPage1 = this.context.pageManager().getPage("/conf/test/site1/sling:configs/" + ListConfig.class.getName() + "/item0");
        MatcherAssert.assertThat((Object)configPage1.getContentResource(), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value1", "intParam", 123}));
        Page configPage2 = this.context.pageManager().getPage("/conf/test/site1/sling:configs/" + ListConfig.class.getName() + "/item1");
        MatcherAssert.assertThat((Object)configPage2.getContentResource(), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value2", "intParam", 234}));
        ImmutableList configs = ImmutableList.copyOf((Collection)((ConfigurationBuilder)this.contentPage.getContentResource().adaptTo(ConfigurationBuilder.class)).asCollection(ListConfig.class));
        Assertions.assertEquals((int)2, (int)configs.size());
        ListConfig config1 = (ListConfig)configs.get(0);
        Assertions.assertEquals((Object)"value1", (Object)config1.stringParam());
        Assertions.assertEquals((int)123, (int)config1.intParam());
        ListConfig config2 = (ListConfig)configs.get(1);
        Assertions.assertEquals((Object)"value2", (Object)config2.stringParam());
        Assertions.assertEquals((int)234, (int)config2.intParam());
    }

    @Test
    void testListConfig_Nested() throws Exception {
        this.context.registerInjectActivateService((Object)new PagePersistenceStrategy(), new Object[]{"enabled", true});
        PersistenceTestUtils.writeConfigurationCollection(this.context, this.contentPage.getPath(), ListNestedConfig.class.getName(), (Collection<Map<String, Object>>)ImmutableList.of((Object)ImmutableValueMap.of((String)"stringParam", (Object)"value1", (String)"intParam", (Object)123), (Object)ImmutableValueMap.of((String)"stringParam", (Object)"value2", (String)"intParam", (Object)234)));
        PersistenceTestUtils.writeConfigurationCollection(this.context, this.contentPage.getPath(), ListNestedConfig.class.getName() + "/item0/jcr:content/subListConfig", (Collection<Map<String, Object>>)ImmutableList.of((Object)ImmutableValueMap.of((String)"stringParam", (Object)"value11"), (Object)ImmutableValueMap.of((String)"stringParam", (Object)"value12")));
        PersistenceTestUtils.writeConfigurationCollection(this.context, this.contentPage.getPath(), ListNestedConfig.class.getName() + "/item1/jcr:content/subListConfig", (Collection<Map<String, Object>>)ImmutableList.of((Object)ImmutableValueMap.of((String)"stringParam", (Object)"value21")));
        Assertions.assertNotNull((Object)this.context.pageManager().getPage("/conf/test/site1/sling:configs/" + ListNestedConfig.class.getName()));
        Page configPage1 = this.context.pageManager().getPage("/conf/test/site1/sling:configs/" + ListNestedConfig.class.getName() + "/item0");
        MatcherAssert.assertThat((Object)configPage1.getContentResource(), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value1", "intParam", 123}));
        MatcherAssert.assertThat((Object)configPage1.getContentResource("subListConfig/item0"), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value11"}));
        MatcherAssert.assertThat((Object)configPage1.getContentResource("subListConfig/item1"), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value12"}));
        Assertions.assertNull((Object)this.context.pageManager().getPage("/conf/test/site1/sling:configs/" + ListNestedConfig.class.getName() + "/item0/jcr:content/subListConfig"));
        Page configPage2 = this.context.pageManager().getPage("/conf/test/site1/sling:configs/" + ListNestedConfig.class.getName() + "/item1");
        MatcherAssert.assertThat((Object)configPage2.getContentResource(), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value2", "intParam", 234}));
        MatcherAssert.assertThat((Object)configPage2.getContentResource("subListConfig/item0"), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value21"}));
        ImmutableList configs = ImmutableList.copyOf((Collection)((ConfigurationBuilder)this.contentPage.getContentResource().adaptTo(ConfigurationBuilder.class)).asCollection(ListNestedConfig.class));
        Assertions.assertEquals((int)2, (int)configs.size());
        ListNestedConfig config1 = (ListNestedConfig)configs.get(0);
        Assertions.assertEquals((Object)"value1", (Object)config1.stringParam());
        Assertions.assertEquals((int)123, (int)config1.intParam());
        Assertions.assertEquals((int)2, (int)config1.subListConfig().length);
        Assertions.assertEquals((Object)"value11", (Object)config1.subListConfig()[0].stringParam());
        Assertions.assertEquals((Object)"value12", (Object)config1.subListConfig()[1].stringParam());
        ListNestedConfig config2 = (ListNestedConfig)configs.get(1);
        Assertions.assertEquals((Object)"value2", (Object)config2.stringParam());
        Assertions.assertEquals((int)234, (int)config2.intParam());
        Assertions.assertEquals((int)1, (int)config2.subListConfig().length);
        Assertions.assertEquals((Object)"value21", (Object)config2.subListConfig()[0].stringParam());
        PersistenceTestUtils.writeConfigurationCollection(this.context, this.contentPage.getPath(), ListNestedConfig.class.getName(), (Collection<Map<String, Object>>)ImmutableList.of((Object)ImmutableValueMap.of((String)"stringParam", (Object)"value1-new", (String)"intParam", (Object)123), (Object)ImmutableValueMap.of((String)"stringParam", (Object)"value2-new", (String)"intParam", (Object)234), (Object)ImmutableValueMap.of((String)"stringParam", (Object)"value3-new", (String)"intParam", (Object)345)));
        configs = ImmutableList.copyOf((Collection)((ConfigurationBuilder)this.contentPage.getContentResource().adaptTo(ConfigurationBuilder.class)).asCollection(ListNestedConfig.class));
        Assertions.assertEquals((int)3, (int)configs.size());
        config1 = (ListNestedConfig)configs.get(0);
        Assertions.assertEquals((Object)"value1-new", (Object)config1.stringParam());
        Assertions.assertEquals((int)123, (int)config1.intParam());
        Assertions.assertEquals((int)2, (int)config1.subListConfig().length);
        Assertions.assertEquals((Object)"value11", (Object)config1.subListConfig()[0].stringParam());
        Assertions.assertEquals((Object)"value12", (Object)config1.subListConfig()[1].stringParam());
        config2 = (ListNestedConfig)configs.get(1);
        Assertions.assertEquals((Object)"value2-new", (Object)config2.stringParam());
        Assertions.assertEquals((int)234, (int)config2.intParam());
        Assertions.assertEquals((int)1, (int)config2.subListConfig().length);
        Assertions.assertEquals((Object)"value21", (Object)config2.subListConfig()[0].stringParam());
        ListNestedConfig config3 = (ListNestedConfig)configs.get(2);
        Assertions.assertEquals((Object)"value3-new", (Object)config3.stringParam());
        Assertions.assertEquals((int)345, (int)config3.intParam());
        Assertions.assertEquals((int)0, (int)config3.subListConfig().length);
    }

    @Test
    void testNestedConfig() throws Exception {
        this.context.registerInjectActivateService((Object)new PagePersistenceStrategy(), new Object[]{"enabled", true});
        PersistenceTestUtils.writeConfiguration(this.context, this.contentPage.getPath(), NestedConfig.class.getName(), "stringParam", "value1");
        PersistenceTestUtils.writeConfiguration(this.context, this.contentPage.getPath(), NestedConfig.class.getName() + "/jcr:content/subConfig", "stringParam", "value2", "intParam", 234);
        PersistenceTestUtils.writeConfigurationCollection(this.context, this.contentPage.getPath(), NestedConfig.class.getName() + "/jcr:content/subListConfig", (Collection<Map<String, Object>>)ImmutableList.of((Object)ImmutableValueMap.of((String)"stringParam", (Object)"value3", (String)"intParam", (Object)345), (Object)ImmutableValueMap.of((String)"stringParam", (Object)"value4", (String)"intParam", (Object)456)));
        Page configPage = this.context.pageManager().getPage("/conf/test/site1/sling:configs/" + NestedConfig.class.getName());
        MatcherAssert.assertThat((Object)configPage.getContentResource(), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value1"}));
        MatcherAssert.assertThat((Object)configPage.getContentResource("subConfig"), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value2", "intParam", 234}));
        MatcherAssert.assertThat((Object)configPage.getContentResource("subListConfig/item0"), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value3", "intParam", 345}));
        MatcherAssert.assertThat((Object)configPage.getContentResource("subListConfig/item1"), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value4", "intParam", 456}));
        NestedConfig config = (NestedConfig)((ConfigurationBuilder)this.contentPage.getContentResource().adaptTo(ConfigurationBuilder.class)).as(NestedConfig.class);
        Assertions.assertEquals((Object)"value1", (Object)config.stringParam());
        SimpleConfig subConfig = config.subConfig();
        Assertions.assertEquals((Object)"value2", (Object)subConfig.stringParam());
        Assertions.assertEquals((int)234, (int)subConfig.intParam());
        ImmutableList subListConfigs = ImmutableList.copyOf((Object[])config.subListConfig());
        Assertions.assertEquals((int)2, (int)subListConfigs.size());
        ListConfig subListConfig1 = (ListConfig)subListConfigs.get(0);
        Assertions.assertEquals((Object)"value3", (Object)subListConfig1.stringParam());
        Assertions.assertEquals((int)345, (int)subListConfig1.intParam());
        ListConfig subListConfig2 = (ListConfig)subListConfigs.get(1);
        Assertions.assertEquals((Object)"value4", (Object)subListConfig2.stringParam());
        Assertions.assertEquals((int)456, (int)subListConfig2.intParam());
    }

    @Test
    void testDeeplyNestedConfig_WCON60() throws Exception {
        this.context.registerInjectActivateService((Object)new PagePersistenceStrategy(), new Object[]{"enabled", true});
        PersistenceTestUtils.writeConfigurationCollection(this.context, this.contentPage.getPath(), FooterConfig.class.getName() + "/jcr:content/menu/menu1/links", (Collection<Map<String, Object>>)ImmutableList.of((Object)ImmutableValueMap.of((String)"linkText", (Object)"text1"), (Object)ImmutableValueMap.of((String)"linkText", (Object)"text2")));
        Page configPage = this.context.pageManager().getPage("/conf/test/site1/sling:configs/" + FooterConfig.class.getName());
        MatcherAssert.assertThat((Object)configPage.getContentResource("menu/menu1/links/item0"), (Matcher)ResourceMatchers.props((Object[])new Object[]{"linkText", "text1"}));
        MatcherAssert.assertThat((Object)configPage.getContentResource("menu/menu1/links/item1"), (Matcher)ResourceMatchers.props((Object[])new Object[]{"linkText", "text2"}));
        FooterConfig config = (FooterConfig)((ConfigurationBuilder)this.contentPage.getContentResource().adaptTo(ConfigurationBuilder.class)).as(FooterConfig.class);
        Assertions.assertEquals((int)1, (int)config.menu().length);
        MenuConfig menu1 = config.menu()[0];
        Assertions.assertEquals((int)2, (int)menu1.links().length);
        MenuLinkConfig link1 = menu1.links()[0];
        Assertions.assertEquals((Object)"text1", (Object)link1.linkText());
        MenuLinkConfig link2 = menu1.links()[1];
        Assertions.assertEquals((Object)"text2", (Object)link2.linkText());
    }

    @Test
    void testSimpleConfig_ResourceType() throws Exception {
        this.context.registerInjectActivateService((Object)new PagePersistenceStrategy(), new Object[]{"enabled", true, "resourceType", "app1/components/page/config"});
        PersistenceTestUtils.writeConfiguration(this.context, this.contentPage.getPath(), SimpleConfig.class.getName(), "stringParam", "value1", "intParam", 123);
        Page configPage = this.context.pageManager().getPage("/conf/test/site1/sling:configs/" + SimpleConfig.class.getName());
        MatcherAssert.assertThat((Object)configPage.getContentResource(), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value1", "intParam", 123, "sling:resourceType", "app1/components/page/config"}));
    }

    @Test
    void testListConfig_ResourceType() throws Exception {
        this.context.registerInjectActivateService((Object)new PagePersistenceStrategy(), new Object[]{"enabled", true, "resourceType", "app1/components/page/config"});
        PersistenceTestUtils.writeConfigurationCollection(this.context, this.contentPage.getPath(), ListConfig.class.getName(), (Collection<Map<String, Object>>)ImmutableList.of((Object)ImmutableValueMap.of((String)"stringParam", (Object)"value1", (String)"intParam", (Object)123), (Object)ImmutableValueMap.of((String)"stringParam", (Object)"value2", (String)"intParam", (Object)234)), (Map<String, Object>)ImmutableValueMap.of((String)"sling:configCollectionInherit", (Object)true));
        Page parentPage = this.context.pageManager().getPage("/conf/test/site1/sling:configs/" + ListConfig.class.getName());
        Assertions.assertNotNull((Object)parentPage);
        Assertions.assertTrue((boolean)((Boolean)parentPage.getContentResource().getValueMap().get("sling:configCollectionInherit", (Object)false)));
        MatcherAssert.assertThat((Object)parentPage.getContentResource(), (Matcher)ResourceMatchers.props((Object[])new Object[]{"sling:resourceType", "app1/components/page/config"}));
        Page configPage1 = this.context.pageManager().getPage("/conf/test/site1/sling:configs/" + ListConfig.class.getName() + "/item0");
        MatcherAssert.assertThat((Object)configPage1.getContentResource(), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value1", "intParam", 123}));
        MatcherAssert.assertThat((Object)configPage1.getContentResource(), (Matcher)ResourceMatchers.props((Object[])new Object[]{"sling:resourceType", "app1/components/page/config"}));
        Page configPage2 = this.context.pageManager().getPage("/conf/test/site1/sling:configs/" + ListConfig.class.getName() + "/item1");
        MatcherAssert.assertThat((Object)configPage2.getContentResource(), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value2", "intParam", 234}));
        MatcherAssert.assertThat((Object)configPage2.getContentResource(), (Matcher)ResourceMatchers.props((Object[])new Object[]{"sling:resourceType", "app1/components/page/config"}));
    }
}

