/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.extensions.persistence.impl;

import com.day.cq.wcm.api.Page;
import com.google.common.collect.ImmutableList;
import io.wcm.caconfig.extensions.contextpath.impl.AbsoluteParentContextPathStrategy;
import io.wcm.caconfig.extensions.persistence.example.ListConfig;
import io.wcm.caconfig.extensions.persistence.example.ListNestedConfig;
import io.wcm.caconfig.extensions.persistence.example.NestedConfig;
import io.wcm.caconfig.extensions.persistence.example.SimpleConfig;
import io.wcm.caconfig.extensions.persistence.impl.PagePersistenceStrategy;
import io.wcm.caconfig.extensions.persistence.impl.ToolsConfigPagePersistenceStrategy;
import io.wcm.caconfig.extensions.persistence.testcontext.PersistenceTestUtils;
import io.wcm.sling.commons.resource.ImmutableValueMap;
import io.wcm.testing.mock.aem.junit5.AemContext;
import io.wcm.testing.mock.aem.junit5.AemContextBuilder;
import io.wcm.testing.mock.aem.junit5.AemContextExtension;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.caconfig.ConfigurationBuilder;
import org.apache.sling.caconfig.management.ConfigurationManager;
import org.apache.sling.hamcrest.ResourceMatchers;
import org.apache.sling.testing.mock.caconfig.ContextPlugins;
import org.apache.sling.testing.mock.osgi.context.ContextPlugin;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={AemContextExtension.class})
class ToolsConfigPagePersistenceStrategyTest {
    final AemContext context = new AemContextBuilder().plugin(new ContextPlugin[]{ContextPlugins.CACONFIG}).build();
    private Page contentPage;

    ToolsConfigPagePersistenceStrategyTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.context.registerInjectActivateService((Object)new AbsoluteParentContextPathStrategy(), new Object[]{"levels", new int[]{1, 3}, "contextPathRegex", "^/content(/.+)$", "configPathPatterns", new String[]{"/conf$1", "/content$1/tools/config/jcr:content"}});
        this.context.registerInjectActivateService((Object)new ToolsConfigPagePersistenceStrategy(), new Object[]{"enabled", true, "configPageTemplate", "/apps/app1/templates/configEditor", "structurePageTemplate", "/apps/app1/templates/structurePage"});
        this.context.create().resource("/apps/app1/templates/configEditor/jcr:content", new Object[]{"sling:resourceType", "app1/components/page/configEditor"});
        this.context.create().page("/content/region1");
        this.context.create().page("/content/region1/site1");
        this.context.create().page("/content/region1/site1/en");
        this.contentPage = this.context.create().page("/content/region1/site1/en/page1");
    }

    @Test
    void testSimpleConfig() throws Exception {
        PersistenceTestUtils.writeConfiguration(this.context, this.contentPage.getPath(), SimpleConfig.class.getName(), "stringParam", "value1", "intParam", 123);
        Page configPage = this.context.pageManager().getPage("/content/region1/site1/en/tools/config");
        MatcherAssert.assertThat((Object)configPage.getContentResource(), (Matcher)ResourceMatchers.props((Object[])new Object[]{"cq:template", "/apps/app1/templates/configEditor", "jcr:title", "config", "sling:resourceType", "app1/components/page/configEditor"}));
        MatcherAssert.assertThat((Object)configPage.getContentResource("sling:configs/" + SimpleConfig.class.getName()), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value1", "intParam", 123}));
        Page toolsPage = this.context.pageManager().getPage("/content/region1/site1/en/tools");
        MatcherAssert.assertThat((Object)toolsPage.getContentResource(), (Matcher)ResourceMatchers.props((Object[])new Object[]{"cq:template", "/apps/app1/templates/structurePage", "jcr:title", "tools", "sling:resourceType", null}));
        SimpleConfig config = (SimpleConfig)((ConfigurationBuilder)this.contentPage.getContentResource().adaptTo(ConfigurationBuilder.class)).as(SimpleConfig.class);
        Assertions.assertEquals((Object)"value1", (Object)config.stringParam());
        Assertions.assertEquals((int)123, (int)config.intParam());
        ConfigurationManager configManager = (ConfigurationManager)this.context.getService(ConfigurationManager.class);
        configManager.deleteConfiguration(this.contentPage.getContentResource(), SimpleConfig.class.getName());
        config = (SimpleConfig)((ConfigurationBuilder)this.contentPage.getContentResource().adaptTo(ConfigurationBuilder.class)).as(SimpleConfig.class);
        Assertions.assertNull((Object)config.stringParam());
        Assertions.assertEquals((int)5, (int)config.intParam());
    }

    @Test
    void testListConfig() throws Exception {
        PersistenceTestUtils.writeConfigurationCollection(this.context, this.contentPage.getPath(), ListConfig.class.getName(), (Collection<Map<String, Object>>)ImmutableList.of((Object)ImmutableValueMap.of((String)"stringParam", (Object)"value1", (String)"intParam", (Object)123), (Object)ImmutableValueMap.of((String)"stringParam", (Object)"value2", (String)"intParam", (Object)234)));
        Page configPage = this.context.pageManager().getPage("/content/region1/site1/en/tools/config");
        MatcherAssert.assertThat((Object)configPage.getContentResource(), (Matcher)ResourceMatchers.props((Object[])new Object[]{"cq:template", "/apps/app1/templates/configEditor", "jcr:title", "config", "sling:resourceType", "app1/components/page/configEditor"}));
        MatcherAssert.assertThat((Object)configPage.getContentResource("sling:configs/" + ListConfig.class.getName() + "/item0"), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value1", "intParam", 123}));
        MatcherAssert.assertThat((Object)configPage.getContentResource("sling:configs/" + ListConfig.class.getName() + "/item1"), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value2", "intParam", 234}));
        Page toolsPage = this.context.pageManager().getPage("/content/region1/site1/en/tools");
        MatcherAssert.assertThat((Object)toolsPage.getContentResource(), (Matcher)ResourceMatchers.props((Object[])new Object[]{"cq:template", "/apps/app1/templates/structurePage", "jcr:title", "tools", "sling:resourceType", null}));
        ImmutableList configs = ImmutableList.copyOf((Collection)((ConfigurationBuilder)this.contentPage.getContentResource().adaptTo(ConfigurationBuilder.class)).asCollection(ListConfig.class));
        Assertions.assertEquals((int)2, (int)configs.size());
        ListConfig config1 = (ListConfig)configs.get(0);
        Assertions.assertEquals((Object)"value1", (Object)config1.stringParam());
        Assertions.assertEquals((int)123, (int)config1.intParam());
        ListConfig config2 = (ListConfig)configs.get(1);
        Assertions.assertEquals((Object)"value2", (Object)config2.stringParam());
        Assertions.assertEquals((int)234, (int)config2.intParam());
    }

    @Test
    void testListConfig_Nested() throws Exception {
        this.context.registerInjectActivateService((Object)new PagePersistenceStrategy(), new Object[]{"enabled", true});
        PersistenceTestUtils.writeConfigurationCollection(this.context, this.contentPage.getPath(), ListNestedConfig.class.getName(), (Collection<Map<String, Object>>)ImmutableList.of((Object)ImmutableValueMap.of((String)"stringParam", (Object)"value1", (String)"intParam", (Object)123), (Object)ImmutableValueMap.of((String)"stringParam", (Object)"value2", (String)"intParam", (Object)234)));
        PersistenceTestUtils.writeConfigurationCollection(this.context, this.contentPage.getPath(), ListNestedConfig.class.getName() + "/item0/subListConfig", (Collection<Map<String, Object>>)ImmutableList.of((Object)ImmutableValueMap.of((String)"stringParam", (Object)"value11"), (Object)ImmutableValueMap.of((String)"stringParam", (Object)"value12")));
        PersistenceTestUtils.writeConfigurationCollection(this.context, this.contentPage.getPath(), ListNestedConfig.class.getName() + "/item1/subListConfig", (Collection<Map<String, Object>>)ImmutableList.of((Object)ImmutableValueMap.of((String)"stringParam", (Object)"value21")));
        Page configPage = this.context.pageManager().getPage("/content/region1/site1/en/tools/config");
        MatcherAssert.assertThat((Object)configPage.getContentResource(), (Matcher)ResourceMatchers.props((Object[])new Object[]{"cq:template", "/apps/app1/templates/configEditor", "jcr:title", "config", "sling:resourceType", "app1/components/page/configEditor"}));
        MatcherAssert.assertThat((Object)configPage.getContentResource("sling:configs/" + ListNestedConfig.class.getName() + "/item0"), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value1", "intParam", 123}));
        MatcherAssert.assertThat((Object)configPage.getContentResource("sling:configs/" + ListNestedConfig.class.getName() + "/item0/subListConfig/item0"), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value11"}));
        MatcherAssert.assertThat((Object)configPage.getContentResource("sling:configs/" + ListNestedConfig.class.getName() + "/item0/subListConfig/item1"), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value12"}));
        MatcherAssert.assertThat((Object)configPage.getContentResource("sling:configs/" + ListNestedConfig.class.getName() + "/item1"), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value2"}));
        MatcherAssert.assertThat((Object)configPage.getContentResource("sling:configs/" + ListNestedConfig.class.getName() + "/item1/subListConfig/item0"), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value21"}));
        ImmutableList configs = ImmutableList.copyOf((Collection)((ConfigurationBuilder)this.contentPage.getContentResource().adaptTo(ConfigurationBuilder.class)).asCollection(ListNestedConfig.class));
        Assertions.assertEquals((int)2, (int)configs.size());
        ListNestedConfig config1 = (ListNestedConfig)configs.get(0);
        Assertions.assertEquals((Object)"value1", (Object)config1.stringParam());
        Assertions.assertEquals((int)123, (int)config1.intParam());
        Assertions.assertEquals((int)2, (int)config1.subListConfig().length);
        Assertions.assertEquals((Object)"value11", (Object)config1.subListConfig()[0].stringParam());
        Assertions.assertEquals((Object)"value12", (Object)config1.subListConfig()[1].stringParam());
        ListNestedConfig config2 = (ListNestedConfig)configs.get(1);
        Assertions.assertEquals((Object)"value2", (Object)config2.stringParam());
        Assertions.assertEquals((int)234, (int)config2.intParam());
        Assertions.assertEquals((int)1, (int)config2.subListConfig().length);
        Assertions.assertEquals((Object)"value21", (Object)config2.subListConfig()[0].stringParam());
        PersistenceTestUtils.writeConfigurationCollection(this.context, this.contentPage.getPath(), ListNestedConfig.class.getName(), (Collection<Map<String, Object>>)ImmutableList.of((Object)ImmutableValueMap.of((String)"stringParam", (Object)"value1-new", (String)"intParam", (Object)123), (Object)ImmutableValueMap.of((String)"stringParam", (Object)"value2-new", (String)"intParam", (Object)234), (Object)ImmutableValueMap.of((String)"stringParam", (Object)"value3-new", (String)"intParam", (Object)345)));
        configs = ImmutableList.copyOf((Collection)((ConfigurationBuilder)this.contentPage.getContentResource().adaptTo(ConfigurationBuilder.class)).asCollection(ListNestedConfig.class));
        Assertions.assertEquals((int)3, (int)configs.size());
        config1 = (ListNestedConfig)configs.get(0);
        Assertions.assertEquals((Object)"value1-new", (Object)config1.stringParam());
        Assertions.assertEquals((int)123, (int)config1.intParam());
        Assertions.assertEquals((int)2, (int)config1.subListConfig().length);
        Assertions.assertEquals((Object)"value11", (Object)config1.subListConfig()[0].stringParam());
        Assertions.assertEquals((Object)"value12", (Object)config1.subListConfig()[1].stringParam());
        config2 = (ListNestedConfig)configs.get(1);
        Assertions.assertEquals((Object)"value2-new", (Object)config2.stringParam());
        Assertions.assertEquals((int)234, (int)config2.intParam());
        Assertions.assertEquals((int)1, (int)config2.subListConfig().length);
        Assertions.assertEquals((Object)"value21", (Object)config2.subListConfig()[0].stringParam());
        ListNestedConfig config3 = (ListNestedConfig)configs.get(2);
        Assertions.assertEquals((Object)"value3-new", (Object)config3.stringParam());
        Assertions.assertEquals((int)345, (int)config3.intParam());
        Assertions.assertEquals((int)0, (int)config3.subListConfig().length);
    }

    @Test
    void testNestedConfig() throws Exception {
        PersistenceTestUtils.writeConfiguration(this.context, this.contentPage.getPath(), NestedConfig.class.getName(), "stringParam", "value1");
        PersistenceTestUtils.writeConfiguration(this.context, this.contentPage.getPath(), NestedConfig.class.getName() + "/subConfig", "stringParam", "value2", "intParam", 234);
        PersistenceTestUtils.writeConfigurationCollection(this.context, this.contentPage.getPath(), NestedConfig.class.getName() + "/subListConfig", (Collection<Map<String, Object>>)ImmutableList.of((Object)ImmutableValueMap.of((String)"stringParam", (Object)"value3", (String)"intParam", (Object)345), (Object)ImmutableValueMap.of((String)"stringParam", (Object)"value4", (String)"intParam", (Object)456)));
        Page configPage = this.context.pageManager().getPage("/content/region1/site1/en/tools/config");
        MatcherAssert.assertThat((Object)configPage.getContentResource("sling:configs/" + NestedConfig.class.getName()), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value1"}));
        MatcherAssert.assertThat((Object)configPage.getContentResource("sling:configs/" + NestedConfig.class.getName() + "/subConfig"), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value2", "intParam", 234}));
        MatcherAssert.assertThat((Object)configPage.getContentResource("sling:configs/" + NestedConfig.class.getName() + "/subListConfig/item0"), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value3", "intParam", 345}));
        MatcherAssert.assertThat((Object)configPage.getContentResource("sling:configs/" + NestedConfig.class.getName() + "/subListConfig/item1"), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value4", "intParam", 456}));
        NestedConfig config = (NestedConfig)((ConfigurationBuilder)this.contentPage.getContentResource().adaptTo(ConfigurationBuilder.class)).as(NestedConfig.class);
        Assertions.assertEquals((Object)"value1", (Object)config.stringParam());
        SimpleConfig subConfig = config.subConfig();
        Assertions.assertEquals((Object)"value2", (Object)subConfig.stringParam());
        Assertions.assertEquals((int)234, (int)subConfig.intParam());
        ImmutableList subListConfigs = ImmutableList.copyOf((Object[])config.subListConfig());
        Assertions.assertEquals((int)2, (int)subListConfigs.size());
        ListConfig subListConfig1 = (ListConfig)subListConfigs.get(0);
        Assertions.assertEquals((Object)"value3", (Object)subListConfig1.stringParam());
        Assertions.assertEquals((int)345, (int)subListConfig1.intParam());
        ListConfig subListConfig2 = (ListConfig)subListConfigs.get(1);
        Assertions.assertEquals((Object)"value4", (Object)subListConfig2.stringParam());
        Assertions.assertEquals((int)456, (int)subListConfig2.intParam());
    }

    @Test
    void testSimpleConfigWithCQLastModified() throws Exception {
        this.context.create().page("/content/region2");
        this.context.create().page("/content/region2/site2");
        this.context.create().page("/content/region2/site2/en");
        this.context.create().page("/content/region2/site2/en/tools");
        Page contentPageWithCQLastModified = this.context.create().page("/content/region2/site2/en/page2");
        Calendar cal = Calendar.getInstance();
        cal.add(10, -1);
        this.context.create().page("/content/region2/site2/en/tools/config", "/apps/app1/templates/configEditor", (Map)ImmutableValueMap.builder().put("cq:lastModified", (Object)cal).build());
        PersistenceTestUtils.writeConfiguration(this.context, contentPageWithCQLastModified.getPath(), SimpleConfig.class.getName(), "stringParam", "value1", "intParam", 123);
        Page configPage = this.context.pageManager().getPage("/content/region2/site2/en/tools/config");
        ValueMap properties = configPage.getContentResource().getValueMap();
        Assertions.assertTrue((boolean)properties.containsKey((Object)"cq:lastModified"));
        Calendar changedDate = (Calendar)properties.get("cq:lastModified", Calendar.class);
        Assertions.assertTrue((boolean)cal.before(changedDate));
        MatcherAssert.assertThat((Object)configPage.getContentResource("sling:configs/" + SimpleConfig.class.getName()), (Matcher)ResourceMatchers.props((Object[])new Object[]{"stringParam", "value1", "intParam", 123}));
        SimpleConfig config = (SimpleConfig)((ConfigurationBuilder)contentPageWithCQLastModified.getContentResource().adaptTo(ConfigurationBuilder.class)).as(SimpleConfig.class);
        Assertions.assertEquals((Object)"value1", (Object)config.stringParam());
        Assertions.assertEquals((int)123, (int)config.intParam());
        ConfigurationManager configManager = (ConfigurationManager)this.context.getService(ConfigurationManager.class);
        configManager.deleteConfiguration(contentPageWithCQLastModified.getContentResource(), SimpleConfig.class.getName());
        config = (SimpleConfig)((ConfigurationBuilder)contentPageWithCQLastModified.getContentResource().adaptTo(ConfigurationBuilder.class)).as(SimpleConfig.class);
        Assertions.assertNull((Object)config.stringParam());
        Assertions.assertEquals((int)5, (int)config.intParam());
    }
}

