/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.extensions.persistence.testcontext;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.testing.mock.aem.junit5.AemContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.management.ConfigurationManager;
import org.apache.sling.caconfig.spi.ConfigurationCollectionPersistData;
import org.apache.sling.caconfig.spi.ConfigurationPersistData;
import org.apache.sling.testing.mock.osgi.MapUtil;

@SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
public final class PersistenceTestUtils {
    private PersistenceTestUtils() {
    }

    public static void writeConfiguration(AemContext context, String contextPath, String configName, Map<String, Object> values) {
        ConfigurationManager configManager = (ConfigurationManager)context.getService(ConfigurationManager.class);
        Resource contextResource = context.resourceResolver().getResource(contextPath);
        configManager.persistConfiguration(contextResource, configName, new ConfigurationPersistData(values));
    }

    public static void writeConfiguration(AemContext context, String contextPath, String configName, Object ... values) {
        PersistenceTestUtils.writeConfiguration(context, contextPath, configName, MapUtil.toMap((Object[])values));
    }

    public static void writeConfigurationCollection(AemContext context, String contextPath, String configName, Collection<Map<String, Object>> values) {
        PersistenceTestUtils.writeConfigurationCollection(context, contextPath, configName, values, null);
    }

    public static void writeConfigurationCollection(AemContext context, String contextPath, String configName, Collection<Map<String, Object>> values, Map<String, Object> collectionProperties) {
        ConfigurationManager configManager = (ConfigurationManager)context.getService(ConfigurationManager.class);
        Resource contextResource = context.resourceResolver().getResource(contextPath);
        ArrayList<ConfigurationPersistData> items = new ArrayList<ConfigurationPersistData>();
        int index = 0;
        for (Map<String, Object> map : values) {
            items.add(new ConfigurationPersistData(map).collectionItemName("item" + index++));
        }
        configManager.persistConfigurationCollection(contextResource, configName, new ConfigurationCollectionPersistData(items).properties(collectionProperties));
    }
}

