/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.extensions.references.impl;

import com.day.cq.wcm.api.Page;
import com.google.common.collect.ImmutableMap;
import io.wcm.caconfig.extensions.references.impl.ConfigurationA;
import io.wcm.caconfig.extensions.references.impl.ConfigurationB;
import io.wcm.caconfig.extensions.references.impl.ConfigurationReferenceProvider;
import io.wcm.caconfig.extensions.references.impl.TestUtils;
import io.wcm.testing.mock.aem.junit5.AemContext;
import io.wcm.testing.mock.aem.junit5.AemContextBuilder;
import io.wcm.testing.mock.aem.junit5.AemContextCallback;
import io.wcm.testing.mock.aem.junit5.AemContextExtension;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.testing.mock.caconfig.ContextPlugins;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.osgi.context.ContextCallback;
import org.apache.sling.testing.mock.osgi.context.ContextPlugin;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.osgi.framework.BundleContext;

@ExtendWith(value={AemContextExtension.class})
class ConfigurationReferenceProviderTest {
    private final AemContext context = new AemContextBuilder().beforeSetUp(new ContextCallback[]{new AemContextCallback(){

        public void execute(@NotNull AemContext ctx) {
            MockOsgi.setConfigForPid((BundleContext)ctx.bundleContext(), (String)"org.apache.sling.caconfig.resource.impl.def.DefaultContextPathStrategy", (Object[])new Object[]{"configRefResourceNames", new String[]{"jcr:content", "."}});
        }
    }}).plugin(new ContextPlugin[]{ContextPlugins.CACONFIG}).build();
    private static final ValueMap CONFIGURATION_A = new ValueMapDecorator((Map)ImmutableMap.of((Object)"key", (Object)"foo"));
    private static final ValueMap CONFIGURATION_B = new ValueMapDecorator((Map)ImmutableMap.of((Object)"key", (Object)"bar"));
    private static final Calendar TIMESTAMP = Calendar.getInstance();
    private Resource site1PageResource;
    private Resource site2PageResource;

    ConfigurationReferenceProviderTest() {
    }

    @BeforeEach
    void setup() {
        this.context.create().resource("/conf");
        this.context.create().page("/content/region1", null, (Map)ImmutableMap.of((Object)"sling:configRef", (Object)"/conf/region1"));
        this.context.create().page("/content/region1/site1", null, (Map)ImmutableMap.of((Object)"sling:configRef", (Object)"/conf/region1/site1"));
        this.context.create().page("/content/region1/site2", null, (Map)ImmutableMap.of((Object)"sling:configRef", (Object)"/conf/region1/site2"));
        Page region1Page = this.context.create().page("/content/region1/page");
        Page site1Page = this.context.create().page("/content/region1/site1/page");
        Page site2Page = this.context.create().page("/content/region1/site2/page");
        this.site1PageResource = (Resource)site1Page.adaptTo(Resource.class);
        this.site2PageResource = (Resource)site2Page.adaptTo(Resource.class);
        TestUtils.registerConfigurations(this.context, ConfigurationA.class, ConfigurationB.class);
        this.context.create().resource("/conf/global/sling:configs/configB", new Object[]{"key", "fallback", "jcr:lastModified", TIMESTAMP});
        TestUtils.applyConfig(this.context, region1Page, "configA", CONFIGURATION_A);
        TestUtils.applyConfig(this.context, site1Page, "configA", CONFIGURATION_A);
        TestUtils.applyConfig(this.context, site2Page, "configA", CONFIGURATION_A);
        TestUtils.applyConfig(this.context, site2Page, "configB", CONFIGURATION_B);
    }

    @Test
    void testReferencesOfPage1() {
        ConfigurationReferenceProvider referenceProvider = new ConfigurationReferenceProvider();
        this.context.registerInjectActivateService((Object)referenceProvider);
        List references = referenceProvider.findReferences(this.site1PageResource);
        Assertions.assertTrue((boolean)references.isEmpty());
    }

    @Test
    void testReferencesOfPage2() {
        ConfigurationReferenceProvider referenceProvider = new ConfigurationReferenceProvider();
        this.context.registerInjectActivateService((Object)referenceProvider);
        List references = referenceProvider.findReferences(this.site2PageResource);
        Assertions.assertTrue((boolean)references.isEmpty());
    }

    @Test
    void testDisabled() {
        ConfigurationReferenceProvider referenceProvider = new ConfigurationReferenceProvider();
        this.context.registerInjectActivateService((Object)referenceProvider, new Object[]{"enabled", false});
        List references = referenceProvider.findReferences(this.site1PageResource);
        Assertions.assertTrue((boolean)references.isEmpty(), (String)"no references");
    }
}

