/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.extensions.references.impl;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.reference.Reference;
import io.wcm.testing.mock.aem.junit5.AemContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.caconfig.impl.metadata.AnnotationClassParser;
import org.apache.sling.caconfig.management.ConfigurationManager;
import org.apache.sling.caconfig.spi.ConfigurationMetadataProvider;
import org.apache.sling.caconfig.spi.ConfigurationPersistData;
import org.apache.sling.caconfig.spi.metadata.ConfigurationMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;

final class TestUtils {
    private TestUtils() {
    }

    public static void applyConfig(AemContext context, Page page, String name, ValueMap props) {
        ConfigurationManager configManager = (ConfigurationManager)context.getService(ConfigurationManager.class);
        Resource contextResource = (Resource)page.adaptTo(Resource.class);
        if (contextResource == null) {
            throw new RuntimeException("No page resource: " + page.getPath());
        }
        configManager.persistConfiguration(contextResource, name, new ConfigurationPersistData((Map)props));
    }

    public static void assetReferences(List<Reference> references, String ... paths) {
        Assertions.assertEquals((int)paths.length, (int)references.size(), (String)"number of references");
        for (int i = 0; i < paths.length; ++i) {
            Assertions.assertEquals((Object)paths[i], (Object)references.get(i).getResource().getPath(), (String)("reference #" + i));
        }
    }

    public static void registerConfigurations(AemContext context, Class<?> ... configurationClasses) {
        DummyConfigurationMetadataProvider metadataProvider = new DummyConfigurationMetadataProvider();
        for (Class<?> clazz : configurationClasses) {
            metadataProvider.addConfigurationClass(clazz);
        }
        context.registerService(ConfigurationMetadataProvider.class, (Object)metadataProvider);
    }

    private static class DummyConfigurationMetadataProvider
    implements ConfigurationMetadataProvider {
        private final Map<String, ConfigurationMetadata> metadata = new HashMap<String, ConfigurationMetadata>();

        private DummyConfigurationMetadataProvider() {
        }

        void addConfigurationClass(Class<?> cls) {
            this.metadata.put(AnnotationClassParser.getConfigurationName(cls), AnnotationClassParser.buildConfigurationMetadata(cls));
        }

        @NotNull
        public SortedSet<String> getConfigurationNames() {
            return new TreeSet<String>(this.metadata.keySet());
        }

        @Nullable
        public ConfigurationMetadata getConfigurationMetadata(String s) {
            return this.metadata.get(s);
        }
    }
}

