/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.extensions.persistence.impl;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import io.wcm.caconfig.extensions.persistence.impl.PropertiesFilterUtil;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.caconfig.management.ConfigurationManagementSettings;
import org.apache.sling.caconfig.spi.ConfigurationCollectionPersistData;
import org.apache.sling.caconfig.spi.ConfigurationPersistenceAccessDeniedException;
import org.apache.sling.caconfig.spi.ConfigurationPersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PersistenceUtils {
    private static final String DEFAULT_FOLDER_NODE_TYPE = "sling:Folder";
    private static final String DEFAULT_FOLDER_NODE_TYPE_IN_PAGE = "nt:unstructured";
    private static final Pattern PAGE_PATH_PATTERN = Pattern.compile("^(.*?)/" + Pattern.quote("jcr:content") + "(/.*)?$");
    private static final Pattern JCR_CONTENT_PATTERN = Pattern.compile("^(.*/)?" + Pattern.quote("jcr:content") + "(/.*)?$");
    private static final Logger log = LoggerFactory.getLogger(PersistenceUtils.class);

    private PersistenceUtils() {
    }

    public static boolean containsJcrContent(String path) {
        if (path == null) {
            return false;
        }
        return JCR_CONTENT_PATTERN.matcher(path).matches();
    }

    public static void ensureContainingPage(ResourceResolver resolver, String configResourcePath, String resourceType, ConfigurationManagementSettings configurationManagementSettings) {
        PersistenceUtils.ensureContainingPage(resolver, configResourcePath, null, resourceType, null, configurationManagementSettings);
    }

    public static void ensureContainingPage(ResourceResolver resolver, String configResourcePath, String template, String resourceType, String parentTemplate, ConfigurationManagementSettings configurationManagementSettings) {
        Matcher matcher = PAGE_PATH_PATTERN.matcher(configResourcePath);
        if (!matcher.matches()) {
            return;
        }
        String pagePath = matcher.group(1);
        PersistenceUtils.ensurePage(resolver, pagePath, template, resourceType, parentTemplate, configurationManagementSettings);
    }

    public static Resource ensurePageIfNotContainingPage(ResourceResolver resolver, String pagePath, String resourceType, ConfigurationManagementSettings configurationManagementSettings) {
        Matcher matcher = PAGE_PATH_PATTERN.matcher(pagePath);
        if (matcher.matches()) {
            String detectedPagePath = matcher.group(1);
            PersistenceUtils.ensurePage(resolver, detectedPagePath, null, resourceType, null, configurationManagementSettings);
            return PersistenceUtils.getOrCreateResource(resolver, pagePath, DEFAULT_FOLDER_NODE_TYPE_IN_PAGE, null, configurationManagementSettings);
        }
        return PersistenceUtils.ensurePage(resolver, pagePath, null, resourceType, null, configurationManagementSettings);
    }

    private static Resource ensurePage(ResourceResolver resolver, String pagePath, String template, String resourceType, String parentTemplate, ConfigurationManagementSettings configurationManagementSettings) {
        Resource resource = resolver.getResource(pagePath);
        if (resource != null) {
            return resource;
        }
        String parentPath = ResourceUtil.getParent((String)pagePath);
        String pageName = ResourceUtil.getName((String)pagePath);
        Resource parentResource = StringUtils.isNotEmpty((CharSequence)parentTemplate) ? PersistenceUtils.ensurePage(resolver, parentPath, parentTemplate, null, parentTemplate, configurationManagementSettings) : PersistenceUtils.getOrCreateResource(resolver, parentPath, DEFAULT_FOLDER_NODE_TYPE, null, configurationManagementSettings);
        return PersistenceUtils.createPage(resolver, parentResource, pageName, template, resourceType);
    }

    private static Resource createPage(ResourceResolver resolver, Resource parentResource, String pageName, String template, String resourceType) {
        String pagePath = parentResource.getPath() + "/" + pageName;
        log.trace("! Create cq:Page node at {}", (Object)pagePath);
        try {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("jcr:primaryType", "cq:Page");
            Resource pageResource = resolver.create(parentResource, pageName, props);
            props = new HashMap();
            props.put("jcr:primaryType", "cq:PageContent");
            if (StringUtils.isNotEmpty((CharSequence)template)) {
                PersistenceUtils.applyPageTemplate(resolver, props, pageName, template);
            }
            if (StringUtils.isNotEmpty((CharSequence)resourceType) && props.get("sling:resourceType") == null) {
                props.put("sling:resourceType", resourceType);
            }
            resolver.create(pageResource, "jcr:content", props);
            return pageResource;
        }
        catch (PersistenceException ex) {
            throw PersistenceUtils.convertPersistenceException("Unable to create config page at " + pagePath, ex);
        }
    }

    private static void applyPageTemplate(ResourceResolver resolver, Map<String, Object> props, String pageName, String template) {
        props.put("cq:template", template);
        props.put("jcr:title", pageName);
        Resource templateContentResource = resolver.getResource(template + "/" + "jcr:content");
        if (templateContentResource != null) {
            props.put("sling:resourceType", templateContentResource.getValueMap().get("sling:resourceType", String.class));
        }
    }

    public static Resource getOrCreateResource(ResourceResolver resolver, String path, String defaultNodeType, Map<String, Object> properties, ConfigurationManagementSettings configurationManagementSettings) {
        try {
            Resource resource = ResourceUtil.getOrCreateResource((ResourceResolver)resolver, (String)path, (String)defaultNodeType, (String)defaultNodeType, (boolean)false);
            if (properties != null) {
                PersistenceUtils.replaceProperties(resource, properties, configurationManagementSettings);
            }
            return resource;
        }
        catch (PersistenceException ex) {
            throw PersistenceUtils.convertPersistenceException("Unable to create resource at " + path, ex);
        }
    }

    public static void deleteChildrenNotInCollection(Resource resource, ConfigurationCollectionPersistData data) {
        Set collectionItemNames = data.getItems().stream().map(item -> item.getCollectionItemName()).collect(Collectors.toSet());
        for (Resource child : resource.getChildren()) {
            if (collectionItemNames.contains(child.getName()) || StringUtils.equals((CharSequence)"jcr:content", (CharSequence)child.getName())) continue;
            PersistenceUtils.deletePageOrResource(child);
        }
    }

    public static void replaceProperties(Resource resource, Map<String, Object> properties, ConfigurationManagementSettings configurationManagementSettings) {
        ModifiableValueMap modValueMap;
        if (log.isTraceEnabled()) {
            log.trace("! Store properties for resource {}: {}", (Object)resource.getPath(), properties);
        }
        if ((modValueMap = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class)) == null) {
            throw new ConfigurationPersistenceAccessDeniedException("No write access: Unable to store configuration data to " + resource.getPath() + ".");
        }
        HashSet<String> propertyNamesToRemove = new HashSet<String>(modValueMap.keySet());
        PropertiesFilterUtil.removeIgnoredProperties(propertyNamesToRemove, configurationManagementSettings);
        for (String propertyName : propertyNamesToRemove) {
            modValueMap.remove((Object)propertyName);
        }
        modValueMap.putAll(properties);
    }

    public static void updatePageLastMod(ResourceResolver resolver, PageManager pageManager, String configResourcePath) {
        Page page = pageManager.getContainingPage(configResourcePath);
        if (page == null) {
            return;
        }
        Resource contentResource = page.getContentResource();
        if (contentResource != null) {
            ModifiableValueMap contentProps = (ModifiableValueMap)contentResource.adaptTo(ModifiableValueMap.class);
            if (contentProps == null) {
                throw new ConfigurationPersistenceAccessDeniedException("No write access: Unable to update page " + configResourcePath + ".");
            }
            Object user = resolver.getAttribute("user.name");
            Calendar now = Calendar.getInstance();
            contentProps.put((Object)"jcr:lastModified", (Object)now);
            contentProps.put((Object)"jcr:lastModifiedBy", user);
            if (contentProps.containsKey((Object)"cq:lastModified")) {
                contentProps.put((Object)"cq:lastModified", (Object)now);
                contentProps.put((Object)"cq:lastModifiedBy", user);
            }
        }
    }

    public static void commit(ResourceResolver resourceResolver, String relatedResourcePath) {
        try {
            resourceResolver.commit();
        }
        catch (PersistenceException ex) {
            throw PersistenceUtils.convertPersistenceException("Unable to persist configuration changes to " + relatedResourcePath, ex);
        }
    }

    public static void deletePageOrResource(Resource resource) {
        Page configPage = (Page)resource.adaptTo(Page.class);
        if (configPage != null) {
            try {
                log.trace("! Delete page {}", (Object)configPage.getPath());
                PageManager pageManager = configPage.getPageManager();
                pageManager.delete(configPage, false);
            }
            catch (WCMException ex) {
                throw PersistenceUtils.convertWCMException("Unable to delete configuration page at " + resource.getPath(), ex);
            }
        }
        try {
            log.trace("! Delete resource {}", (Object)resource.getPath());
            resource.getResourceResolver().delete(resource);
        }
        catch (PersistenceException ex) {
            throw PersistenceUtils.convertPersistenceException("Unable to delete configuration resource at " + resource.getPath(), ex);
        }
    }

    private static ConfigurationPersistenceException convertWCMException(String message, WCMException ex) {
        String causeClsName = ex.getCause().getClass().getName();
        if (StringUtils.equals((CharSequence)causeClsName, (CharSequence)"com.day.cq.replication.AccessDeniedException") || StringUtils.equals((CharSequence)causeClsName, (CharSequence)"javax.jcr.AccessDeniedException")) {
            return new ConfigurationPersistenceAccessDeniedException("No write access: " + message, (Throwable)ex);
        }
        return new ConfigurationPersistenceException(message, (Throwable)ex);
    }

    private static ConfigurationPersistenceException convertPersistenceException(String message, PersistenceException ex) {
        if (StringUtils.equals((CharSequence)ex.getCause().getClass().getName(), (CharSequence)"javax.jcr.AccessDeniedException")) {
            return new ConfigurationPersistenceAccessDeniedException("No write access: " + message, (Throwable)ex);
        }
        return new ConfigurationPersistenceException(message, (Throwable)ex);
    }
}

