/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.extensions.persistence.impl;

import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.PageManagerFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.caconfig.extensions.persistence.impl.PersistenceUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.PredicateUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.iterators.FilterIterator;
import org.apache.commons.collections4.iterators.TransformIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.caconfig.management.ConfigurationManagementSettings;
import org.apache.sling.caconfig.management.multiplexer.ContextPathStrategyMultiplexer;
import org.apache.sling.caconfig.resource.spi.ConfigurationResourceResolvingStrategy;
import org.apache.sling.caconfig.resource.spi.ContextResource;
import org.apache.sling.caconfig.spi.ConfigurationCollectionPersistData;
import org.apache.sling.caconfig.spi.ConfigurationPersistData;
import org.apache.sling.caconfig.spi.ConfigurationPersistenceStrategy2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ConfigurationPersistenceStrategy2.class, ConfigurationResourceResolvingStrategy.class})
@Designate(ocd=Config.class)
public class ToolsConfigPagePersistenceStrategy
implements ConfigurationPersistenceStrategy2,
ConfigurationResourceResolvingStrategy {
    private static final String RELATIVE_CONFIG_PATH = "/tools/config/jcr:content";
    private static final Pattern CONFIG_PATH_PATTERN = Pattern.compile("^.*" + Pattern.quote("/tools/config/jcr:content") + "(/.*)?$");
    private static final String DEFAULT_CONFIG_NODE_TYPE = "nt:unstructured";
    private static final String PROPERTY_CONFIG_COLLECTION_INHERIT = "sling:configCollectionInherit";
    private static final Logger log = LoggerFactory.getLogger(ToolsConfigPagePersistenceStrategy.class);
    private boolean enabled;
    private Config config;
    @Reference
    private ContextPathStrategyMultiplexer contextPathStrategy;
    @Reference
    private ConfigurationManagementSettings configurationManagementSettings;
    @Reference
    private PageManagerFactory pageManagerFactory;

    @Activate
    void activate(Config value) {
        this.enabled = value.enabled();
        this.config = value;
    }

    public Resource getResource(@NotNull Resource resource) {
        if (!this.enabled || !this.isConfigPagePath(resource.getPath())) {
            return null;
        }
        return resource;
    }

    public Resource getCollectionParentResource(@NotNull Resource resource) {
        return this.getResource(resource);
    }

    public Resource getCollectionItemResource(@NotNull Resource resource) {
        return this.getResource(resource);
    }

    public String getResourcePath(@NotNull String resourcePath) {
        if (!this.enabled || !this.isConfigPagePath(resourcePath)) {
            return null;
        }
        return resourcePath;
    }

    public String getCollectionParentResourcePath(@NotNull String resourcePath) {
        return this.getResourcePath(resourcePath);
    }

    public String getCollectionItemResourcePath(@NotNull String resourcePath) {
        return this.getResourcePath(resourcePath);
    }

    public String getConfigName(@NotNull String configName, @Nullable String relatedConfigPath) {
        if (!this.enabled || relatedConfigPath != null && !this.isConfigPagePath(relatedConfigPath)) {
            return null;
        }
        return configName;
    }

    public String getCollectionParentConfigName(@NotNull String configName, @Nullable String relatedConfigPath) {
        return this.getConfigName(configName, relatedConfigPath);
    }

    public String getCollectionItemConfigName(@NotNull String configName, @Nullable String relatedConfigPath) {
        return this.getConfigName(configName, relatedConfigPath);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public boolean persistConfiguration(@NotNull ResourceResolver resolver, @NotNull String configResourcePath, @NotNull ConfigurationPersistData data) {
        if (!this.enabled || !this.isConfigPagePath(configResourcePath)) {
            return false;
        }
        String path = this.getResourcePath(configResourcePath);
        PersistenceUtils.ensureContainingPage(resolver, path, this.config.configPageTemplate(), null, this.config.structurePageTemplate(), this.configurationManagementSettings);
        PersistenceUtils.getOrCreateResource(resolver, path, DEFAULT_CONFIG_NODE_TYPE, data.getProperties(), this.configurationManagementSettings);
        PageManager pageManager = this.pageManagerFactory.getPageManager(resolver);
        PersistenceUtils.updatePageLastMod(resolver, pageManager, path);
        PersistenceUtils.commit(resolver, configResourcePath);
        return true;
    }

    public boolean persistConfigurationCollection(@NotNull ResourceResolver resolver, @NotNull String configResourceCollectionParentPath, @NotNull ConfigurationCollectionPersistData data) {
        if (!this.enabled || !this.isConfigPagePath(configResourceCollectionParentPath)) {
            return false;
        }
        PersistenceUtils.ensureContainingPage(resolver, configResourceCollectionParentPath, this.config.configPageTemplate(), null, this.config.structurePageTemplate(), this.configurationManagementSettings);
        Resource configResourceParent = PersistenceUtils.getOrCreateResource(resolver, configResourceCollectionParentPath, DEFAULT_CONFIG_NODE_TYPE, (Map<String, Object>)ValueMap.EMPTY, this.configurationManagementSettings);
        PersistenceUtils.deleteChildrenNotInCollection(configResourceParent, data);
        for (ConfigurationPersistData item : data.getItems()) {
            String path = configResourceParent.getPath() + "/" + item.getCollectionItemName();
            PersistenceUtils.getOrCreateResource(resolver, path, DEFAULT_CONFIG_NODE_TYPE, item.getProperties(), this.configurationManagementSettings);
        }
        if (data.getProperties() != null) {
            PersistenceUtils.replaceProperties(configResourceParent, data.getProperties(), this.configurationManagementSettings);
        }
        PageManager pageManager = this.pageManagerFactory.getPageManager(resolver);
        PersistenceUtils.updatePageLastMod(resolver, pageManager, configResourceCollectionParentPath);
        PersistenceUtils.commit(resolver, configResourceCollectionParentPath);
        return true;
    }

    public boolean deleteConfiguration(@NotNull ResourceResolver resolver, @NotNull String configResourcePath) {
        if (!this.enabled || !this.isConfigPagePath(configResourcePath)) {
            return false;
        }
        Resource resource = resolver.getResource(configResourcePath);
        if (resource != null) {
            PersistenceUtils.deletePageOrResource(resource);
        }
        PageManager pageManager = this.pageManagerFactory.getPageManager(resolver);
        PersistenceUtils.updatePageLastMod(resolver, pageManager, configResourcePath);
        PersistenceUtils.commit(resolver, configResourcePath);
        return true;
    }

    private boolean isConfigPagePath(String configPath) {
        return CONFIG_PATH_PATTERN.matcher(configPath).matches();
    }

    private Iterator<String> findConfigRefs(@NotNull Resource startResource, final @NotNull Collection<String> bucketNames) {
        FilterIterator contextResources = new FilterIterator(this.contextPathStrategy.findContextResources(startResource), new Predicate(){

            public boolean evaluate(Object object) {
                ContextResource contextResource = (ContextResource)object;
                return StringUtils.isNotBlank((CharSequence)contextResource.getConfigRef());
            }
        });
        TransformIterator configPaths = new TransformIterator((Iterator)contextResources, new Transformer(){

            public Object transform(Object input) {
                ContextResource contextResource = (ContextResource)input;
                String val = ToolsConfigPagePersistenceStrategy.this.checkPath(contextResource, contextResource.getConfigRef(), bucketNames);
                if (val != null) {
                    log.trace("+ Found reference for context path {}: {}", (Object)contextResource.getResource().getPath(), (Object)val);
                }
                return val;
            }
        });
        return new FilterIterator((Iterator)configPaths, PredicateUtils.notNullPredicate());
    }

    private String checkPath(ContextResource contextResource, String checkRef, Collection<String> bucketNames) {
        String ref = ResourceUtil.normalize((String)checkRef);
        for (String bucketName : bucketNames) {
            String notAllowedPostfix = "/" + bucketName;
            if (ref == null || !ref.endsWith(notAllowedPostfix)) continue;
            log.warn("Ignoring reference to {} from {} - Probably misconfigured as it ends with '{}'", new Object[]{contextResource.getConfigRef(), contextResource.getResource().getPath(), notAllowedPostfix});
            ref = null;
        }
        return ref;
    }

    private boolean isEnabledAndParamsValid(Resource contentResource, Collection<String> bucketNames, String configName) {
        return this.enabled && contentResource != null;
    }

    private String buildResourcePath(String path, String name) {
        return ResourceUtil.normalize((String)(path + "/" + name));
    }

    public Resource getResource(@NotNull Resource contentResource, @NotNull Collection<String> bucketNames, @NotNull String configName) {
        Iterator<Resource> resources = this.getResourceInheritanceChain(contentResource, bucketNames, configName);
        if (resources != null && resources.hasNext()) {
            return resources.next();
        }
        return null;
    }

    private Iterator<Resource> getResourceInheritanceChainInternal(final Collection<String> bucketNames, final String configName, Iterator<String> paths, final ResourceResolver resourceResolver) {
        Iterator matchingResources = IteratorUtils.transformedIterator(paths, (Transformer)new Transformer(){

            public Object transform(Object input) {
                String path = (String)input;
                for (String bucketName : bucketNames) {
                    String name = bucketName + "/" + configName;
                    String configPath = ToolsConfigPagePersistenceStrategy.this.buildResourcePath(path, name);
                    Resource resource = resourceResolver.getResource(configPath);
                    if (resource != null) {
                        log.trace("+ Found matching config resource for inheritance chain: {}", (Object)configPath);
                        return resource;
                    }
                    log.trace("- No matching config resource for inheritance chain: {}", (Object)configPath);
                }
                return null;
            }
        });
        Iterator result = IteratorUtils.filteredIterator((Iterator)matchingResources, (Predicate)PredicateUtils.notNullPredicate());
        if (result.hasNext()) {
            return result;
        }
        return null;
    }

    public Iterator<Resource> getResourceInheritanceChain(@NotNull Resource contentResource, @NotNull Collection<String> bucketNames, @NotNull String configName) {
        if (!this.isEnabledAndParamsValid(contentResource, bucketNames, configName)) {
            return null;
        }
        ResourceResolver resourceResolver = contentResource.getResourceResolver();
        Iterator<String> paths = this.findConfigRefs(contentResource, bucketNames);
        return this.getResourceInheritanceChainInternal(bucketNames, configName, paths, resourceResolver);
    }

    private Collection<Resource> getResourceCollectionInternal(Collection<String> bucketNames, String configName, Iterator<String> paths, ResourceResolver resourceResolver) {
        LinkedHashMap<String, Resource> result = new LinkedHashMap<String, Resource>();
        boolean inherit = false;
        while (paths.hasNext()) {
            ValueMap valueMap;
            String bucketName;
            String name;
            String configPath;
            String path = paths.next();
            Resource item = null;
            Iterator<String> iterator = bucketNames.iterator();
            while (iterator.hasNext() && (item = resourceResolver.getResource(configPath = this.buildResourcePath(path, name = (bucketName = iterator.next()) + "/" + configName))) == null) {
                log.trace("- No collection parent resource found: {}", (Object)configPath);
            }
            if (item == null) continue;
            log.trace("o Check children of collection parent resource: {}", (Object)item.getPath());
            if (item.hasChildren()) {
                for (Resource child : item.getChildren()) {
                    if (!this.isValidResourceCollectionItem(child) || result.containsKey(child.getName())) continue;
                    log.trace("+ Found collection resource item {}", (Object)child.getPath());
                    result.put(child.getName(), child);
                }
            }
            if (inherit = ((Boolean)(valueMap = item.getValueMap()).get(PROPERTY_CONFIG_COLLECTION_INHERIT, (Object)false)).booleanValue()) continue;
            break;
        }
        return result.values();
    }

    public Collection<Resource> getResourceCollection(@NotNull Resource contentResource, @NotNull Collection<String> bucketNames, @NotNull String configName) {
        if (!this.isEnabledAndParamsValid(contentResource, bucketNames, configName)) {
            return null;
        }
        Iterator<String> paths = this.findConfigRefs(contentResource, bucketNames);
        Collection<Resource> result = this.getResourceCollectionInternal(bucketNames, configName, paths, contentResource.getResourceResolver());
        if (!result.isEmpty()) {
            return result;
        }
        return null;
    }

    public Collection<Iterator<Resource>> getResourceCollectionInheritanceChain(@NotNull Resource contentResource, final @NotNull Collection<String> bucketNames, final @NotNull String configName) {
        if (!this.isEnabledAndParamsValid(contentResource, bucketNames, configName)) {
            return null;
        }
        final ResourceResolver resourceResolver = contentResource.getResourceResolver();
        final List paths = IteratorUtils.toList(this.findConfigRefs(contentResource, bucketNames));
        Collection<Resource> resourceCollection = this.getResourceCollectionInternal(bucketNames, configName, paths.iterator(), resourceResolver);
        Iterator result = IteratorUtils.transformedIterator(resourceCollection.iterator(), (Transformer)new Transformer(){

            public Object transform(Object input) {
                Resource item = (Resource)input;
                return ToolsConfigPagePersistenceStrategy.this.getResourceInheritanceChainInternal(bucketNames, configName + "/" + item.getName(), paths.iterator(), resourceResolver);
            }
        });
        if (result.hasNext()) {
            return IteratorUtils.toList((Iterator)result);
        }
        return null;
    }

    private boolean isValidResourceCollectionItem(Resource resource) {
        return !StringUtils.equals((CharSequence)resource.getName(), (CharSequence)"jcr:content");
    }

    public String getResourcePath(@NotNull Resource contentResource, @NotNull String bucketName, @NotNull String configName) {
        if (!this.isEnabledAndParamsValid(contentResource, Collections.singleton(bucketName), configName)) {
            return null;
        }
        String name = bucketName + "/" + configName;
        Iterator<String> configPaths = this.findConfigRefs(contentResource, Collections.singleton(bucketName));
        if (configPaths.hasNext()) {
            String configPath = this.buildResourcePath(configPaths.next(), name);
            log.trace("+ Building configuration path for name '{}' for resource {}: {}", new Object[]{name, contentResource.getPath(), configPath});
            return configPath;
        }
        log.trace("- No configuration path for name '{}' found for resource {}", (Object)name, (Object)contentResource.getPath());
        return null;
    }

    public String getResourceCollectionParentPath(@NotNull Resource contentResource, @NotNull String bucketName, @NotNull String configName) {
        return this.getResourcePath(contentResource, bucketName, configName);
    }

    @ObjectClassDefinition(name="wcm.io Context-Aware Configuration Persistence Strategy: Tools Config Page", description="Stores Context-Aware Configuration in a single AEM content page at /tools/config.")
    static @interface Config {
        @AttributeDefinition(name="Enabled", description="Enable this persistence strategy.")
        public boolean enabled() default false;

        @AttributeDefinition(name="Config Template", description="Template that is used for a configuration page.")
        public String configPageTemplate();

        @AttributeDefinition(name="Structure Template", description="Template that is used for the tools page.")
        public String structurePageTemplate();

        @AttributeDefinition(name="Service Ranking", description="Priority of persistence strategy (higher = higher priority).")
        public int service_ranking() default 2000;
    }
}

