/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.extensions.references.impl;

import com.day.cq.commons.Filter;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageFilter;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.PageManagerFactory;
import com.day.cq.wcm.api.reference.ReferenceProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.management.ConfigurationManager;
import org.apache.sling.caconfig.management.ConfigurationResourceResolverConfig;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationResourceResolvingStrategyMultiplexer;
import org.apache.sling.caconfig.spi.metadata.ConfigurationMetadata;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ReferenceProvider.class})
@Designate(ocd=Config.class)
public class ConfigurationReferenceProvider
implements ReferenceProvider {
    static final String REFERENCE_TYPE = "caconfig";
    @Reference
    private ConfigurationManager configurationManager;
    @Reference
    private ConfigurationResourceResolvingStrategyMultiplexer configurationResourceResolvingStrategy;
    @Reference
    private ConfigurationResourceResolverConfig configurationResourceResolverConfig;
    private boolean enabled;
    private static final Logger log = LoggerFactory.getLogger(ConfigurationReferenceProvider.class);
    @Reference
    private PageManagerFactory pageManagerFactory;

    @Activate
    protected void activate(Config config) {
        this.enabled = config.enabled();
    }

    @Deactivate
    protected void deactivate() {
        this.enabled = false;
    }

    public List<com.day.cq.wcm.api.reference.Reference> findReferences(Resource resource) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        PageManager pageManager = this.pageManagerFactory.getPageManager(resource.getResourceResolver());
        if (pageManager == null) {
            throw new RuntimeException("No page manager.");
        }
        Page contextPage = pageManager.getContainingPage(resource);
        if (contextPage == null) {
            return Collections.emptyList();
        }
        TreeMap<String, ConfigurationMetadata> configurationMetadatas = new TreeMap<String, ConfigurationMetadata>(this.configurationManager.getConfigurationNames().stream().collect(Collectors.toMap(configName -> configName, configName -> this.configurationManager.getConfigurationMetadata(configName))));
        ArrayList<com.day.cq.wcm.api.reference.Reference> references = new ArrayList<com.day.cq.wcm.api.reference.Reference>();
        LinkedHashSet configurationBuckets = new LinkedHashSet(this.configurationResourceResolverConfig.configBucketNames());
        for (String configurationName : configurationMetadatas.keySet()) {
            Iterator configurationInheritanceChain = this.configurationResourceResolvingStrategy.getResourceInheritanceChain(resource, configurationBuckets, configurationName);
            LinkedHashMap<String, Page> referencePages = new LinkedHashMap<String, Page>();
            while (configurationInheritanceChain != null && configurationInheritanceChain.hasNext()) {
                Resource configurationResource = (Resource)configurationInheritanceChain.next();
                Page configPage = pageManager.getContainingPage(configurationResource);
                if (configPage == null) continue;
                referencePages.put(configPage.getPath(), configPage);
                Iterator deepChildren = configPage.listChildren((Filter)new PageFilter(false, true), true);
                while (deepChildren.hasNext()) {
                    Page configChildPage = (Page)deepChildren.next();
                    referencePages.put(configChildPage.getPath(), configChildPage);
                }
            }
            referencePages.values().stream().filter(item -> !StringUtils.equals((CharSequence)contextPage.getPath(), (CharSequence)item.getPath())).forEach(item -> references.add(this.toReference(resource, (Page)item, (Map<String, ConfigurationMetadata>)configurationMetadatas, configurationBuckets)));
        }
        log.debug("Found {} references for resource {}", (Object)references.size(), (Object)resource.getPath());
        return references;
    }

    private com.day.cq.wcm.api.reference.Reference toReference(Resource resource, Page configPage, Map<String, ConfigurationMetadata> configurationMetadatas, Set<String> configurationBuckets) {
        log.trace("Found configuration reference {} for resource {}", (Object)configPage.getPath(), (Object)resource.getPath());
        return new com.day.cq.wcm.api.reference.Reference(ConfigurationReferenceProvider.getType(), ConfigurationReferenceProvider.getReferenceName(configPage, configurationMetadatas, configurationBuckets), (Resource)configPage.adaptTo(Resource.class), ConfigurationReferenceProvider.getLastModifiedOf(configPage));
    }

    private static String getReferenceName(Page configPage, Map<String, ConfigurationMetadata> configurationMetadatas, Set<String> configurationBuckets) {
        List<String> pathParts = Arrays.asList(StringUtils.split((String)configPage.getPath(), (String)"/"));
        return pathParts.stream().filter(name -> !configurationBuckets.contains(name)).map(name -> {
            ConfigurationMetadata configMetadata = (ConfigurationMetadata)configurationMetadatas.get(name);
            if (configMetadata != null && configMetadata.getLabel() != null) {
                return configMetadata.getLabel();
            }
            return name;
        }).collect(Collectors.joining(" / "));
    }

    private static long getLastModifiedOf(Page page) {
        Calendar lastModified = page.getLastModified();
        return lastModified != null ? lastModified.getTimeInMillis() : 0L;
    }

    private static String getType() {
        return REFERENCE_TYPE;
    }

    @ObjectClassDefinition(name="wcm.io Context-Aware Configuration Reference Provider", description="Allows to resolve references from resources to their Context-Aware configurations, for example during page activation.")
    static @interface Config {
        @AttributeDefinition(name="Enabled", description="Enable this reference provider.")
        public boolean enabled() default true;
    }
}

