/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.dam.assetservice.impl;

import io.wcm.dam.assetservice.impl.AssetRequest;
import io.wcm.sling.commons.request.RequestParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.sling.api.SlingHttpServletRequest;

final class AssetRequestParser {
    static final String RP_MEDIAFORMAT = "mediaFormat";
    static final String RP_WIDTH = "width";
    static final String RP_HEIGHT = "height";

    private AssetRequestParser() {
    }

    public static List<AssetRequest> getAssetRequests(String assetPath, SlingHttpServletRequest request) {
        List<AssetRequest> requests = AssetRequestParser.getAssetRequestsFromSuffix(assetPath, request);
        if (requests.isEmpty()) {
            requests = AssetRequestParser.getAssetRequestsFromUrlParams(assetPath, request);
        }
        if (requests.isEmpty()) {
            requests.add(new AssetRequest(assetPath, null, 0L, 0L));
        }
        return requests;
    }

    private static List<AssetRequest> getAssetRequestsFromSuffix(String assetPath, SlingHttpServletRequest request) {
        ArrayList<AssetRequest> requests = new ArrayList<AssetRequest>();
        String suffixWithoutExtension = StringUtils.substringBefore((String)request.getRequestPathInfo().getSuffix(), (String)".");
        String[] suffixParts = StringUtils.split((String)suffixWithoutExtension, (String)"/");
        if (suffixParts != null) {
            for (String suffixPart : suffixParts) {
                Map<String, String> params = AssetRequestParser.parseSuffixPart(suffixPart);
                String mediaFormat = params.get(RP_MEDIAFORMAT);
                long width = NumberUtils.toLong((String)params.get(RP_WIDTH));
                long height = NumberUtils.toLong((String)params.get(RP_HEIGHT));
                if (!StringUtils.isNotEmpty((CharSequence)mediaFormat) && width <= 0L && height <= 0L) continue;
                requests.add(new AssetRequest(assetPath, mediaFormat, width, height));
            }
        }
        return requests;
    }

    private static Map<String, String> parseSuffixPart(String suffixPart) {
        HashMap<String, String> params = new HashMap<String, String>();
        String[] paramPairParts = StringUtils.split((String)suffixPart, (String)",");
        if (paramPairParts != null) {
            for (String paramPairPart : paramPairParts) {
                String[] paramParts = StringUtils.split((String)paramPairPart, (String)"=");
                if (paramParts == null || paramParts.length != 2) continue;
                params.put(paramParts[0], paramParts[1]);
            }
        }
        return params;
    }

    private static List<AssetRequest> getAssetRequestsFromUrlParams(String assetPath, SlingHttpServletRequest request) {
        String[] mediaFormats = (String[])ObjectUtils.defaultIfNull((Object)RequestParam.getMultiple((ServletRequest)request, (String)RP_MEDIAFORMAT), (Object)new String[0]);
        String[] widthStrings = (String[])ObjectUtils.defaultIfNull((Object)RequestParam.getMultiple((ServletRequest)request, (String)RP_WIDTH), (Object)new String[0]);
        String[] heightStrings = (String[])ObjectUtils.defaultIfNull((Object)RequestParam.getMultiple((ServletRequest)request, (String)RP_HEIGHT), (Object)new String[0]);
        int maxParamIndex = NumberUtils.max((int)mediaFormats.length, (int)widthStrings.length, (int)heightStrings.length);
        ArrayList<AssetRequest> requests = new ArrayList<AssetRequest>();
        for (int i = 0; i < maxParamIndex; ++i) {
            String mediaFormat = mediaFormats.length > i ? mediaFormats[i] : null;
            long width = widthStrings.length > i ? NumberUtils.toLong((String)widthStrings[i]) : 0L;
            long height = heightStrings.length > i ? NumberUtils.toLong((String)heightStrings[i]) : 0L;
            requests.add(new AssetRequest(assetPath, mediaFormat, width, height));
        }
        return requests;
    }
}

