/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.dam.assetservice.impl;

import io.wcm.dam.assetservice.impl.AssetRequest;
import io.wcm.dam.assetservice.impl.AssetRequestParser;
import io.wcm.dam.assetservice.impl.DamPathHandler;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaHandler;
import io.wcm.handler.media.Rendition;
import io.wcm.wcm.commons.contenttype.ContentType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AssetRequestServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1L;
    private final DamPathHandler damPathHandler;
    private static final Logger log = LoggerFactory.getLogger(AssetRequestServlet.class);

    AssetRequestServlet(DamPathHandler damPathHandler) {
        this.damPathHandler = damPathHandler;
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String assetPath = request.getResource().getPath();
        if (!this.damPathHandler.isAllowedAssetPath(assetPath)) {
            log.debug("Asset path not allowed {}", (Object)assetPath);
            response.sendError(404);
            return;
        }
        MediaHandler mediaHandler = (MediaHandler)request.getResource().adaptTo(MediaHandler.class);
        if (mediaHandler == null) {
            log.debug("Unable to get media handler for {}", (Object)assetPath);
            response.sendError(404);
            return;
        }
        List<AssetRequest> requests = AssetRequestParser.getAssetRequests(assetPath, request);
        List<Media> mediaList = this.resolveMedia(requests, mediaHandler);
        if (mediaList.isEmpty()) {
            log.debug("No matching assets/renditions found for {}; requests: {}", (Object)assetPath, requests);
            response.sendError(404);
            return;
        }
        try {
            JSONArray resultJson = this.toResultJson(mediaList);
            response.setContentType(ContentType.JSON);
            response.setCharacterEncoding("UTF-8");
            response.getWriter().write(resultJson.toString());
        }
        catch (JSONException ex) {
            throw new ServletException("Unable to generate JSON.", (Throwable)ex);
        }
    }

    private List<Media> resolveMedia(List<AssetRequest> requests, MediaHandler mediaHandler) {
        ArrayList<Media> result = new ArrayList<Media>();
        for (AssetRequest request : requests) {
            Media media = request.resolve(mediaHandler);
            if (!media.isValid()) continue;
            result.add(media);
        }
        return result;
    }

    private JSONArray toResultJson(List<Media> mediaList) throws JSONException {
        JSONArray array = new JSONArray();
        for (Media media : mediaList) {
            Rendition rendition = media.getRendition();
            JSONObject mediaObject = new JSONObject();
            mediaObject.put("assetPath", (Object)media.getAsset().getPath());
            mediaObject.put("url", (Object)media.getUrl());
            if (rendition.getWidth() > 0L && rendition.getHeight() > 0L) {
                mediaObject.put("width", rendition.getWidth());
                mediaObject.put("height", rendition.getHeight());
            }
            if (rendition.getFileSize() > 0L) {
                mediaObject.put("fileSize", rendition.getFileSize());
            }
            mediaObject.putOpt("fileExtension", (Object)rendition.getFileExtension());
            mediaObject.putOpt("mimeType", (Object)rendition.getMimeType());
            array.put((Object)mediaObject);
        }
        return array;
    }
}

