/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.dam.assetservice.impl;

import com.day.cq.dam.api.DamEvent;
import io.wcm.dam.assetservice.impl.AssetRequestServlet;
import io.wcm.dam.assetservice.impl.DamPathHandler;
import io.wcm.dam.assetservice.impl.DataVersionServlet;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={AssetService.class, EventHandler.class}, property={"event.topics=com/day/cq/dam"})
@Designate(ocd=Config.class)
public class AssetService
implements EventHandler {
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    private DamPathHandler damPathHandler;
    private BundleContext bundleContext;
    private ServiceRegistration<Servlet> assetRequestServletReg;
    private ServiceRegistration<Servlet> dataVersionServletReg;
    private static final Logger log = LoggerFactory.getLogger(AssetService.class);

    @Activate
    protected void activate(BundleContext context, Config config) {
        log.info("Start wcm.io DAM Asset Service.");
        this.bundleContext = context;
        String assetServletSelector = config.assetServletSelector();
        String dataVersionServletSelector = config.dataVersionServletSelector();
        int dataVersionUpdateIntervalSec = config.dataVersionUpdateIntervalSec();
        String[] damPaths = config.damPaths();
        String dataVersionStrategyId = config.dataVersionStrategy();
        this.damPathHandler = new DamPathHandler(damPaths, dataVersionStrategyId, dataVersionUpdateIntervalSec, this.resourceResolverFactory);
        this.assetRequestServletReg = AssetService.registerServlet(context, new AssetRequestServlet(this.damPathHandler), "dam:Asset", assetServletSelector);
        this.dataVersionServletReg = AssetService.registerServlet(context, new DataVersionServlet(this.damPathHandler), "sling:OrderedFolder", dataVersionServletSelector);
    }

    @Deactivate
    protected void deactivate() {
        log.info("Shutdown wcm.io DAM Asset Service.");
        this.assetRequestServletReg.unregister();
        this.dataVersionServletReg.unregister();
        this.damPathHandler.shutdown();
    }

    public void handleEvent(Event event) {
        if (!StringUtils.equals((CharSequence)event.getTopic(), (CharSequence)"com/day/cq/dam")) {
            return;
        }
        DamEvent damEvent = DamEvent.fromEvent((Event)event);
        this.damPathHandler.handleDamEvent(damEvent);
    }

    AssetRequestServlet getAssetRequestServlet() {
        return (AssetRequestServlet)((Object)this.bundleContext.getService(this.assetRequestServletReg.getReference()));
    }

    DataVersionServlet getDataVersionServlet() {
        return (DataVersionServlet)((Object)this.bundleContext.getService(this.dataVersionServletReg.getReference()));
    }

    private static <T extends Servlet> ServiceRegistration<Servlet> registerServlet(BundleContext bundleContext, T servletInstance, String resourceType, String selector) {
        if (StringUtils.isEmpty((CharSequence)selector)) {
            throw new IllegalArgumentException("No selector defined for " + servletInstance.getClass().getName() + " - skipping servlet registration.");
        }
        Hashtable<String, String> config = new Hashtable<String, String>();
        ((Dictionary)config).put("sling.servlet.resourceTypes", resourceType);
        ((Dictionary)config).put("sling.servlet.selectors", selector);
        ((Dictionary)config).put("sling.servlet.extensions", "json");
        return bundleContext.registerService(Servlet.class, servletInstance, config);
    }

    @ObjectClassDefinition(name="wcm.io DAM Asset Service", description="A RESTful service for resolving URLs to DAM assets and renditions.")
    static @interface Config {
        @AttributeDefinition(name="Asset Selector", description="Selector for attaching REST service to DAM asset paths.")
        public String assetServletSelector() default "wcm-io-asset-service";

        @AttributeDefinition(name="Data Version Selector", description="Selector for attaching REST service to DAM folder for getting data version.")
        public String dataVersionServletSelector() default "wcm-io-asset-service-dataversion";

        @AttributeDefinition(name="Data Version Strategy", description="Strategy for building the data versions. See documentation for details.", options={@Option(label="timestamp: Timestamp of last DAM event", value="timestamp"), @Option(label="checksum: Aggregated checksum of DAM assets", value="checksum")})
        public String dataVersionStrategy() default "timestamp";

        @AttributeDefinition(name="Update Interval (sec)", description="Updating interval for calculating data versions in seconds. If multiple changes to the DAM folders contents are detected within this interval they are collected. This is only used by the 'aggregated checksum' strategy.")
        public int dataVersionUpdateIntervalSec() default 60;

        @AttributeDefinition(name="DAM paths", description="List of DAM paths for which the asset service should be active. If not set, the service is active for all paths.")
        public String[] damPaths();
    }
}

