/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.dam.assetservice.impl;

import com.day.cq.dam.api.DamEvent;
import io.wcm.dam.assetservice.impl.dataversion.ChecksumDataVersionStrategy;
import io.wcm.dam.assetservice.impl.dataversion.DataVersionStrategy;
import io.wcm.dam.assetservice.impl.dataversion.TimestampDataVersionStrategy;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DamPathHandler {
    private static final String DEFAULT_DAM_PATH = "/content/dam";
    private final Set<String> damPaths;
    private final Pattern damPathsPattern;
    private final ScheduledExecutorService executor;
    private final Map<String, DataVersionStrategy> dataVersionStrategies;
    private static final Logger log = LoggerFactory.getLogger(DamPathHandler.class);

    public DamPathHandler(String[] configuredDamPaths, String dataVersionStrategyId, int dataVersionUpdateIntervalSec, ResourceResolverFactory resourceResolverFactory) {
        this.damPaths = DamPathHandler.validateDamPaths(configuredDamPaths);
        this.damPathsPattern = DamPathHandler.buildDamPathsPattern(this.damPaths);
        log.debug("Start executor for DamPathHandler");
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.dataVersionStrategies = new HashMap<String, DataVersionStrategy>();
        for (String damPath : this.damPaths) {
            DataVersionStrategy dataVersionStrategy = DamPathHandler.getDataVersionStrategy(damPath, dataVersionStrategyId, dataVersionUpdateIntervalSec, resourceResolverFactory, this.executor);
            this.dataVersionStrategies.put(damPath, dataVersionStrategy);
        }
    }

    private static DataVersionStrategy getDataVersionStrategy(String damPath, String dataVersionStrategyId, int dataVersionUpdateIntervalSec, ResourceResolverFactory resourceResolverFactory, ScheduledExecutorService executor) {
        if (StringUtils.equals((CharSequence)dataVersionStrategyId, (CharSequence)"timestamp")) {
            return new TimestampDataVersionStrategy(damPath);
        }
        if (StringUtils.equals((CharSequence)dataVersionStrategyId, (CharSequence)"checksum")) {
            return new ChecksumDataVersionStrategy(damPath, dataVersionUpdateIntervalSec, resourceResolverFactory, executor);
        }
        throw new IllegalArgumentException("Invalid data version strategy: " + dataVersionStrategyId);
    }

    public void shutdown() {
        log.debug("Shutdown executor for DamPathHandler");
        this.executor.shutdownNow();
    }

    private static Set<String> validateDamPaths(String[] damPaths) {
        HashSet<String> paths = new HashSet<String>();
        if (damPaths != null) {
            for (String path : damPaths) {
                if (!StringUtils.isNotBlank((CharSequence)path)) continue;
                paths.add(path);
            }
        }
        if (paths.isEmpty()) {
            paths.add(DEFAULT_DAM_PATH);
        }
        return Collections.unmodifiableSet(paths);
    }

    private static Pattern buildDamPathsPattern(Set<String> damPaths) {
        StringBuilder pattern = new StringBuilder();
        pattern.append("^(");
        Iterator<String> paths = damPaths.iterator();
        while (paths.hasNext()) {
            pattern.append(Pattern.quote(paths.next()));
            pattern.append("/.*");
            if (!paths.hasNext()) continue;
            pattern.append("|");
        }
        pattern.append(")$");
        return Pattern.compile(pattern.toString());
    }

    public boolean isAllowedAssetPath(String assetPath) {
        if (assetPath == null) {
            return false;
        }
        return this.damPathsPattern.matcher(assetPath).matches();
    }

    public boolean isAllowedDataVersionPath(String path) {
        return this.damPaths.contains(path);
    }

    public String getDataVersion(String damPath) {
        DataVersionStrategy dataVersionStrategy = this.dataVersionStrategies.get(damPath);
        if (dataVersionStrategy != null) {
            return dataVersionStrategy.getDataVersion();
        }
        return null;
    }

    public void handleDamEvent(DamEvent event) {
        DataVersionStrategy dataVersionStrategy;
        if (this.isAllowedAssetPath(event.getAssetPath()) && (dataVersionStrategy = this.getMatchingDataVersionStrategy(event.getAssetPath())) != null) {
            dataVersionStrategy.handleDamEvent(event);
        }
    }

    private DataVersionStrategy getMatchingDataVersionStrategy(String path) {
        if (this.dataVersionStrategies.size() == 1) {
            return this.dataVersionStrategies.values().iterator().next();
        }
        for (DataVersionStrategy dataVersionStrategy : this.dataVersionStrategies.values()) {
            if (!dataVersionStrategy.matches(path)) continue;
            return dataVersionStrategy;
        }
        return null;
    }
}

