/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.dam.assetservice.impl;

import io.wcm.dam.assetservice.impl.DamPathHandler;
import io.wcm.wcm.commons.caching.CacheHeader;
import io.wcm.wcm.commons.contenttype.ContentType;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataVersionServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1L;
    private final DamPathHandler damPathHandler;
    private static final Logger log = LoggerFactory.getLogger(DataVersionServlet.class);

    DataVersionServlet(DamPathHandler damPathHandler) {
        this.damPathHandler = damPathHandler;
    }

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        String path = request.getResource().getPath();
        if (!this.damPathHandler.isAllowedDataVersionPath(path)) {
            log.debug("Path not allowed to get data version {}", (Object)path);
            response.sendError(404);
            return;
        }
        try {
            JSONObject jsonResponse = new JSONObject();
            jsonResponse.put("dataVersion", (Object)this.damPathHandler.getDataVersion(path));
            response.setContentType(ContentType.JSON);
            response.setCharacterEncoding("UTF-8");
            response.getWriter().write(jsonResponse.toString());
            CacheHeader.setNonCachingHeaders((HttpServletResponse)response);
        }
        catch (JSONException ex) {
            throw new ServletException("Unable to generate JSON.", (Throwable)ex);
        }
    }
}

