/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.dam.assetservice.impl.dataversion;

import com.day.cq.dam.api.DamEvent;
import io.wcm.dam.assetservice.impl.dataversion.DataVersionStrategy;
import io.wcm.sling.commons.adapter.AdaptTo;
import java.util.Calendar;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;

public class ChecksumDataVersionStrategy
extends DataVersionStrategy {
    public static final String STRATEGY = "checksum";
    private static final String DATAVERSION_NOT_CALCULATED = "unknown";
    private static final String LAST_MODIFIED_PROPERTY = "jcr:content/jcr:lastModified";
    private final long dataVersionUpdateIntervalMs;
    private final String dataVersionQueryString;
    private final ResourceResolverFactory resourceResolverFactory;
    private volatile String dataVersion;
    private volatile long dataVersionLastUpdate;
    private volatile long damEventLastOccurence;

    public ChecksumDataVersionStrategy(String damPath, int dataVersionUpdateIntervalSec, ResourceResolverFactory resourceResolverFactory, ScheduledExecutorService executor) {
        super(damPath);
        this.dataVersionUpdateIntervalMs = (long)dataVersionUpdateIntervalSec * 1000L;
        this.resourceResolverFactory = resourceResolverFactory;
        this.dataVersionQueryString = ChecksumDataVersionStrategy.buildDataVersionQueryString(damPath);
        this.dataVersion = DATAVERSION_NOT_CALCULATED;
        if (dataVersionUpdateIntervalSec <= 0) {
            this.log.warn("{} - Invalid data version update interval: {} sec", (Object)damPath, (Object)dataVersionUpdateIntervalSec);
        } else {
            UpdateDataVersionTask task = new UpdateDataVersionTask();
            executor.scheduleWithFixedDelay(task, 0L, dataVersionUpdateIntervalSec, TimeUnit.SECONDS);
        }
    }

    private static String buildDataVersionQueryString(String damPath) {
        return "select [jcr:path], [jcr:content/jcr:lastModified] from [dam:Asset] as a where isdescendantnode(a, '" + damPath + "') order by [jcr:path]";
    }

    @Override
    public void handleDamEvent(DamEvent damEvent) {
        this.damEventLastOccurence = System.currentTimeMillis();
    }

    @Override
    public String getDataVersion() {
        return this.dataVersion;
    }

    private class UpdateDataVersionTask
    implements Runnable {
        private UpdateDataVersionTask() {
        }

        @Override
        public void run() {
            if (!this.isDataVersionStale()) {
                ChecksumDataVersionStrategy.this.log.debug("{} - Data version '{}' is not stale, skip generation of new data version.", (Object)ChecksumDataVersionStrategy.this.damPath, (Object)ChecksumDataVersionStrategy.this.dataVersion);
                return;
            }
            try {
                ChecksumDataVersionStrategy.this.log.debug("{} - Data version '{}' is stale, start generation of new data version.", (Object)ChecksumDataVersionStrategy.this.damPath, (Object)ChecksumDataVersionStrategy.this.dataVersion);
                this.generateDataVersion();
            }
            catch (LoginException ex) {
                ChecksumDataVersionStrategy.this.log.error("{} - Unable to get service resource resolver, please check service user configuration: {}", (Object)ChecksumDataVersionStrategy.this.damPath, (Object)ex.getMessage());
            }
            catch (Exception ex) {
                ChecksumDataVersionStrategy.this.log.error("{} - Error generating data version: {}", new Object[]{ChecksumDataVersionStrategy.this.damPath, ex.getMessage(), ex});
            }
        }

        private boolean isDataVersionStale() {
            if (ChecksumDataVersionStrategy.this.dataVersionLastUpdate == 0L) {
                return true;
            }
            return ChecksumDataVersionStrategy.this.dataVersionLastUpdate < ChecksumDataVersionStrategy.this.damEventLastOccurence + ChecksumDataVersionStrategy.this.dataVersionUpdateIntervalMs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void generateDataVersion() throws LoginException, RepositoryException {
            ChecksumDataVersionStrategy.this.log.trace("{} - Start data version generation.", (Object)ChecksumDataVersionStrategy.this.damPath);
            try (ResourceResolver resourceResolver = ChecksumDataVersionStrategy.this.resourceResolverFactory.getServiceResourceResolver(null);){
                Session session = (Session)AdaptTo.notNull((Adaptable)resourceResolver, Session.class);
                QueryManager queryManager = session.getWorkspace().getQueryManager();
                Query query = queryManager.createQuery(ChecksumDataVersionStrategy.this.dataVersionQueryString, "JCR-SQL2");
                QueryResult result = query.execute();
                RowIterator rows = result.getRows();
                HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
                int assetCount = 0;
                StopWatch stopwatch = new StopWatch();
                stopwatch.start();
                while (rows.hasNext()) {
                    Row row = rows.nextRow();
                    String path = this.getStringValue(row, "jcr:path");
                    Calendar lastModified = this.getCalendarValue(row, ChecksumDataVersionStrategy.LAST_MODIFIED_PROPERTY);
                    ChecksumDataVersionStrategy.this.log.trace("{} - Found sha-1 at {}: {}", new Object[]{ChecksumDataVersionStrategy.this.damPath, path, lastModified});
                    hashCodeBuilder.append((Object)path);
                    if (lastModified != null) {
                        hashCodeBuilder.append((Object)lastModified);
                    } else {
                        ChecksumDataVersionStrategy.this.log.debug("{} - No last modified date found for {}", (Object)ChecksumDataVersionStrategy.this.damPath, (Object)path);
                    }
                    ++assetCount;
                }
                ChecksumDataVersionStrategy.this.dataVersion = Integer.toString(hashCodeBuilder.build());
                ChecksumDataVersionStrategy.this.dataVersionLastUpdate = System.currentTimeMillis();
                stopwatch.stop();
                ChecksumDataVersionStrategy.this.log.info("{} - Generated new data version {} for {} assets (duration: {}ms).", new Object[]{ChecksumDataVersionStrategy.this.damPath, ChecksumDataVersionStrategy.this.dataVersion, assetCount, stopwatch.getTime()});
            }
        }

        private String getStringValue(Row row, String property) throws RepositoryException {
            Value value = row.getValue(property);
            if (value != null) {
                return value.getString();
            }
            return null;
        }

        private Calendar getCalendarValue(Row row, String property) throws RepositoryException {
            Value value = row.getValue(property);
            if (value != null) {
                return value.getDate();
            }
            return null;
        }
    }
}

