/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.commons.dom;

import io.wcm.handler.commons.dom.AbstractHtmlElementFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Content;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public class HtmlElement<T extends HtmlElement>
extends AbstractHtmlElementFactory<T> {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_STYLE = "style";
    private static final String ATTRIBUTE_TITLE = "title";
    private static final String ATTRIBUTE_DATA_PREFIX = "data-";

    public HtmlElement(String name) {
        super(name);
    }

    @Override
    public final <HtmlElementType extends HtmlElement> HtmlElementType add(HtmlElementType element) {
        this.addContent((Content)element);
        return element;
    }

    protected final boolean getEmptyAttributeValueAsBoolean(String attributeName) {
        return attributeName.equalsIgnoreCase(this.getAttributeValue(attributeName));
    }

    protected final T setEmptyAttributeValueAsBoolean(String attributeName, boolean value) {
        if (value) {
            this.setAttribute(attributeName, attributeName.toLowerCase());
        } else {
            this.removeAttribute(attributeName);
        }
        return (T)((Object)this);
    }

    public final String getId() {
        return this.getAttributeValue(ATTRIBUTE_ID);
    }

    public final T setId(String value) {
        this.setAttribute(ATTRIBUTE_ID, value);
        return (T)((Object)this);
    }

    public final String getCssClass() {
        return this.getAttributeValue(ATTRIBUTE_CLASS);
    }

    public final T setCssClass(String value) {
        this.setAttribute(ATTRIBUTE_CLASS, value);
        return (T)((Object)this);
    }

    public final T addCssClass(String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return this.setCssClass((String)(StringUtils.isNotEmpty((CharSequence)this.getCssClass()) ? this.getCssClass() + " " + value : value));
        }
        return (T)((Object)this);
    }

    public final String getStyleString() {
        return this.getAttributeValue(ATTRIBUTE_STYLE);
    }

    public final Map<String, String> getStyles() {
        HashMap<String, String> styleMap = new HashMap<String, String>();
        String styleString = this.getStyleString();
        if (styleString != null) {
            String[] styles;
            for (String styleSubString : styles = StringUtils.split((String)styleString, (String)";")) {
                String[] styleParts = StringUtils.split((String)styleSubString, (String)":");
                if (styleParts.length <= 1) continue;
                styleMap.put(styleParts[0].trim(), styleParts[1].trim());
            }
        }
        return styleMap;
    }

    public final String getStyle(String styleAttribute) {
        return this.getStyles().get(styleAttribute);
    }

    public final T setStyleString(String value) {
        this.setAttribute(ATTRIBUTE_STYLE, value);
        return (T)((Object)this);
    }

    public final T setStyle(String styleAttribute, String styleValue) {
        Map<String, String> styleMap = this.getStyles();
        styleMap.put(styleAttribute, styleValue);
        StringBuilder styleString = new StringBuilder();
        for (Map.Entry<String, String> style : styleMap.entrySet()) {
            styleString.append(style.getKey());
            styleString.append(':');
            styleString.append(style.getValue());
            styleString.append(';');
        }
        this.setStyleString(styleString.toString());
        return (T)((Object)this);
    }

    public final String getTitle() {
        return this.getAttributeValue(ATTRIBUTE_TITLE);
    }

    public final T setTitle(String value) {
        this.setAttribute(ATTRIBUTE_TITLE, value);
        return (T)((Object)this);
    }

    public final String getData(String attributeName) {
        return this.getAttributeValue(ATTRIBUTE_DATA_PREFIX + attributeName);
    }

    public final T setData(String attributeName, String value) {
        this.setAttribute(ATTRIBUTE_DATA_PREFIX + attributeName, value);
        return (T)((Object)this);
    }
}

