/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.commons.dom;

import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.XMLOutputter;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public abstract class AbstractElement
extends Element {
    private static final long serialVersionUID = 1L;
    private static final Pattern CONTROL_CHARS = Pattern.compile("[\\p{Cntrl}]");

    protected AbstractElement(String name) {
        super(name);
    }

    public final int getAttributeValueAsInteger(String attributeName) {
        Attribute attribute = this.getAttribute(attributeName);
        if (attribute == null) {
            return 0;
        }
        try {
            return attribute.getIntValue();
        }
        catch (DataConversionException ex) {
            return 0;
        }
    }

    public AbstractElement setAttributeValueAsLong(String name, long value) {
        this.setAttribute(name, Long.toString(value));
        return this;
    }

    public final long getAttributeValueAsLong(String attributeName) {
        Attribute attribute = this.getAttribute(attributeName);
        if (attribute == null) {
            return 0L;
        }
        try {
            return attribute.getLongValue();
        }
        catch (DataConversionException ex) {
            return 0L;
        }
    }

    public final AbstractElement setAttributeValueAsInteger(String name, int value) {
        this.setAttribute(name, Integer.toString(value));
        return this;
    }

    public final Element addContent(Content content) {
        if (content == null) {
            return null;
        }
        return super.addContent(content);
    }

    public final Element addContent(int index, Content content) {
        if (content == null) {
            return null;
        }
        return super.addContent(index, content);
    }

    public final Element addContent(String text) {
        if (text == null) {
            return null;
        }
        return super.addContent(this.cleanUpString(text));
    }

    public final Element addContent(Collection collection) {
        if (collection == null) {
            return null;
        }
        return super.addContent(collection);
    }

    public final Element addContent(int index, Collection collection) {
        if (collection == null) {
            return null;
        }
        return super.addContent(index, collection);
    }

    public final <T extends AbstractElement> T add(T element) {
        this.addContent((Content)element);
        return element;
    }

    public Element setText(String text) {
        return super.setText(this.cleanUpString(StringUtils.defaultString((String)text)));
    }

    public final Element setAttribute(String name, String value, Namespace ns) {
        if (value == null) {
            super.removeAttribute(name, ns);
            return this;
        }
        return super.setAttribute(name, this.cleanUpString(value), ns);
    }

    public final Element setAttribute(String name, String value) {
        if (value == null) {
            super.removeAttribute(name);
            return this;
        }
        return super.setAttribute(name, this.cleanUpString(value));
    }

    private String cleanUpString(String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return text;
        }
        return CONTROL_CHARS.matcher(text).replaceAll("");
    }

    public final String toString() {
        return new XMLOutputter().outputString((Element)this);
    }

    public final String toStringContentOnly() {
        return new XMLOutputter().outputElementContentString((Element)this);
    }
}

