/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.commons.dom;

import io.wcm.handler.commons.dom.HtmlElement;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class Image
extends HtmlElement {
    private static final long serialVersionUID = 1L;
    private static final String ELEMENT_NAME = "img";
    private static final String ATTRIBUTE_SRC = "src";
    private static final String ATTRIBUTE_SRCSET = "srcset";
    private static final String ATTRIBUTE_SIZES = "sizes";
    private static final String ATTRIBUTE_ALT = "alt";
    private static final String ATTRIBUTE_WIDTH = "width";
    private static final String ATTRIBUTE_HEIGHT = "height";
    private static final String ATTRIBUTE_BORDER = "border";
    private static final String ATTRIBUTE_HSPACE = "hspace";
    private static final String ATTRIBUTE_VSPACE = "vspace";
    private static final String ATTRIBUTE_USEMAP = "usemap";

    public Image() {
        super(ELEMENT_NAME);
    }

    public Image(String src) {
        this();
        this.setSrc(src);
    }

    public Image(String src, String alt) {
        this();
        this.setSrc(src);
        this.setAlt(alt);
    }

    public Image(String src, long width, long height) {
        this();
        this.setSrc(src);
        this.setWidth(width);
        this.setHeight(height);
    }

    public Image(String src, String alt, long width, long height) {
        this();
        this.setSrc(src);
        this.setAlt(alt);
        this.setWidth(width);
        this.setHeight(height);
    }

    public String getSrc() {
        return this.getAttributeValue(ATTRIBUTE_SRC);
    }

    public Image setSrc(String value) {
        this.setAttribute(ATTRIBUTE_SRC, value);
        return this;
    }

    public String getSrcSet() {
        return this.getAttributeValue(ATTRIBUTE_SRCSET);
    }

    public Image setSrcSet(String value) {
        this.setAttribute(ATTRIBUTE_SRCSET, value);
        return this;
    }

    public String getSizes() {
        return this.getAttributeValue(ATTRIBUTE_SIZES);
    }

    public Image setSizes(String value) {
        this.setAttribute(ATTRIBUTE_SIZES, value);
        return this;
    }

    public String getAlt() {
        return this.getAttributeValue(ATTRIBUTE_ALT);
    }

    public Image setAlt(String value) {
        this.setAttribute(ATTRIBUTE_ALT, value);
        return this;
    }

    public long getWidth() {
        return this.getAttributeValueAsLong(ATTRIBUTE_WIDTH);
    }

    public Image setWidth(long value) {
        this.setAttributeValueAsLong(ATTRIBUTE_WIDTH, value);
        return this;
    }

    public long getHeight() {
        return this.getAttributeValueAsLong(ATTRIBUTE_HEIGHT);
    }

    public Image setHeight(long value) {
        this.setAttributeValueAsLong(ATTRIBUTE_HEIGHT, value);
        return this;
    }

    public int getBorder() {
        return this.getAttributeValueAsInteger(ATTRIBUTE_BORDER);
    }

    public Image setBorder(int value) {
        this.setAttributeValueAsInteger(ATTRIBUTE_BORDER, value);
        return this;
    }

    public int getHSpace() {
        return this.getAttributeValueAsInteger(ATTRIBUTE_HSPACE);
    }

    public Image setHSpace(int value) {
        this.setAttributeValueAsInteger(ATTRIBUTE_HSPACE, value);
        return this;
    }

    public int getVSpace() {
        return this.getAttributeValueAsInteger(ATTRIBUTE_VSPACE);
    }

    public Image setVSpace(int value) {
        this.setAttributeValueAsInteger(ATTRIBUTE_VSPACE, value);
        return this;
    }

    public String getUseMap() {
        return this.getAttributeValue(ATTRIBUTE_USEMAP);
    }

    public Image setUseMap(String value) {
        this.setAttribute(ATTRIBUTE_USEMAP, value);
        return this;
    }

    @Override
    protected Image setEmptyAttributeValueAsBoolean(String attributeName, boolean value) {
        return (Image)super.setEmptyAttributeValueAsBoolean(attributeName, value);
    }

    @Override
    public Image setId(String value) {
        return (Image)super.setId(value);
    }

    @Override
    public Image setCssClass(String value) {
        return (Image)super.setCssClass(value);
    }

    @Override
    public Image addCssClass(String value) {
        return (Image)super.addCssClass(value);
    }

    @Override
    public Image setStyleString(String value) {
        return (Image)super.setStyleString(value);
    }

    @Override
    public Image setStyle(String styleAttribute, String styleValue) {
        return (Image)super.setStyle(styleAttribute, styleValue);
    }

    @Override
    public Image setTitle(String value) {
        return (Image)super.setTitle(value);
    }

    @Override
    public Image setData(String attributeName, String value) {
        return (Image)super.setData(attributeName, value);
    }

    @Override
    public Image setAttributeValueAsLong(String name, long value) {
        return (Image)super.setAttributeValueAsLong(name, value);
    }

    @Override
    public Image setText(String text) {
        return (Image)super.setText(text);
    }
}

