/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.commons.editcontext;

import com.day.cq.wcm.api.components.DropTarget;
import java.util.Collections;
import java.util.Map;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class DropTargetImpl
implements DropTarget {
    private final String name;
    private final String id;
    private final String propertyName;
    private String[] groups = new String[0];
    private String[] accept = new String[]{"*"};
    private Map<String, String> parameters = Collections.emptyMap();

    public DropTargetImpl(@NotNull String name, @NotNull String propertyName) {
        this.name = name;
        this.id = "cq-dd-" + this.name;
        this.propertyName = propertyName;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public DropTargetImpl setGroups(String @NotNull [] values) {
        this.groups = values;
        return this;
    }

    public String[] getAccept() {
        return this.accept;
    }

    public DropTargetImpl setAccept(String @NotNull [] values) {
        this.accept = values;
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public DropTargetImpl setParameters(@NotNull Map<String, String> value) {
        this.parameters = value;
        return this;
    }

    public void write(JSONWriter out) throws JSONException {
        out.object();
        out.key("id").value((Object)this.name);
        out.key("name").value((Object)this.propertyName);
        out.key("accept").array();
        for (String a : this.accept) {
            out.value((Object)a);
        }
        out.endArray();
        out.key("groups").array();
        for (String group : this.groups) {
            out.value((Object)group);
        }
        out.endArray();
        if (!this.parameters.isEmpty()) {
            out.key("params");
            out.object();
            for (Map.Entry entry : this.parameters.entrySet()) {
                out.key((String)entry.getKey()).value(entry.getValue());
            }
            out.endObject();
        }
        out.endObject();
    }
}

