/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.commons.servlets.impl;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, configurationPolicy=ConfigurationPolicy.REQUIRE)
@SlingServletResourceTypes(resourceTypes={"cq:Page"}, methods={"GET"}, extensions={"htx"})
@Designate(ocd=Config.class)
public class HtxPageExtensionMapper
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(HtxPageExtensionMapper.class);
    private boolean enabled;

    protected void activate(Config config) {
        this.enabled = config.enabled();
    }

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        RequestDispatcher requestDispatcher;
        if (!this.enabled) {
            response.sendError(404);
            return;
        }
        RequestPathInfo info = request.getRequestPathInfo();
        StringBuilder url = new StringBuilder();
        url.append(info.getResourcePath());
        if (info.getSelectorString() != null) {
            url.append('.').append(info.getSelectorString());
        }
        url.append('.').append("html");
        if (info.getSuffix() != null) {
            url.append('/').append(info.getSuffix());
        }
        if (log.isDebugEnabled()) {
            log.debug("Dispatch request {} to {}", (Object)request.getRequestURI(), (Object)url);
        }
        if ((requestDispatcher = request.getRequestDispatcher(url.toString())) == null) {
            throw new ServletException("No Request Dispatcher.");
        }
        requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
    }

    @ObjectClassDefinition(name="wcm.io htx Page Extension Mapper", description="Mapps all *.htx requests on Pages to *.html view.")
    static @interface Config {
        @AttributeDefinition(name="Enabled", description="Enable mapping.")
        public boolean enabled() default false;
    }
}

