/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.link;

import com.day.cq.wcm.api.Page;
import io.wcm.handler.commons.dom.Anchor;
import io.wcm.handler.link.LinkRequest;
import io.wcm.handler.link.spi.LinkType;
import io.wcm.handler.media.Asset;
import io.wcm.handler.media.Rendition;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jdom2.Attribute;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class Link {
    private final LinkType linkType;
    private LinkRequest linkRequest;
    private boolean linkReferenceInvalid;
    private Anchor anchor;
    private String url;
    private Page targetPage;
    private Asset targetAsset;
    private Rendition targetRendition;

    public Link(LinkType linkType, LinkRequest linkRequest) {
        this.linkRequest = linkRequest;
        this.linkType = linkType;
    }

    public LinkType getLinkType() {
        return this.linkType;
    }

    public LinkRequest getLinkRequest() {
        return this.linkRequest;
    }

    public void setLinkRequest(LinkRequest linkRequest) {
        this.linkRequest = linkRequest;
    }

    public boolean isLinkReferenceInvalid() {
        return this.linkReferenceInvalid;
    }

    public void setLinkReferenceInvalid(boolean linkReferenceInvalid) {
        this.linkReferenceInvalid = linkReferenceInvalid;
    }

    public Anchor getAnchor() {
        return this.anchor;
    }

    public Map<String, String> getAnchorAttributes() {
        if (this.getAnchor() == null) {
            return null;
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Attribute attribute : this.getAnchor().getAttributes()) {
            attributes.put(attribute.getName(), attribute.getValue());
        }
        return attributes;
    }

    public void setAnchor(Anchor anchor) {
        this.anchor = anchor;
    }

    public String getMarkup() {
        if (this.anchor != null) {
            return StringUtils.removeEnd((String)this.anchor.toString(), (String)"</a>");
        }
        return null;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Page getTargetPage() {
        return this.targetPage;
    }

    public void setTargetPage(Page targetPage) {
        this.targetPage = targetPage;
    }

    public Asset getTargetAsset() {
        return this.targetAsset;
    }

    public void setTargetAsset(Asset targetAsset) {
        this.targetAsset = targetAsset;
    }

    public Rendition getTargetRendition() {
        return this.targetRendition;
    }

    public void setTargetRendition(Rendition targetRendition) {
        this.targetRendition = targetRendition;
    }

    public boolean isValid() {
        return this.getLinkType() != null && this.getUrl() != null && !StringUtils.equals((CharSequence)this.getUrl(), (CharSequence)"/invalid///link");
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)io.wcm.wcm.commons.util.ToStringStyle.SHORT_PREFIX_OMIT_NULL_STYLE);
    }
}

