/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.link.impl;

import com.day.cq.wcm.api.Page;
import io.wcm.handler.commons.dom.Anchor;
import io.wcm.handler.link.Link;
import io.wcm.handler.link.LinkArgs;
import io.wcm.handler.link.LinkBuilder;
import io.wcm.handler.link.LinkRequest;
import io.wcm.handler.link.impl.LinkHandlerImpl;
import io.wcm.handler.url.UrlMode;
import org.apache.sling.api.resource.Resource;

final class LinkBuilderImpl
implements LinkBuilder {
    private final LinkHandlerImpl linkHandler;
    private final Resource resource;
    private final Page page;
    private LinkArgs linkArgs = new LinkArgs();

    LinkBuilderImpl(Resource resource, LinkHandlerImpl linkHandler) {
        this.resource = resource;
        this.page = null;
        this.linkHandler = linkHandler;
    }

    LinkBuilderImpl(Page page, LinkHandlerImpl linkHandler) {
        this.resource = null;
        this.page = page;
        this.linkHandler = linkHandler;
    }

    LinkBuilderImpl(LinkRequest linkRequest, LinkHandlerImpl linkHandler) {
        if (linkRequest == null) {
            throw new IllegalArgumentException("Link request is null.");
        }
        this.resource = linkRequest.getResource();
        this.page = linkRequest.getPage();
        this.linkHandler = linkHandler;
        this.linkArgs = linkRequest.getLinkArgs().clone();
    }

    @Override
    public LinkBuilder args(LinkArgs value) {
        if (value == null) {
            throw new IllegalArgumentException("LinkArgs is null.");
        }
        this.linkArgs = value.clone();
        return this;
    }

    @Override
    public LinkBuilder urlMode(UrlMode value) {
        this.linkArgs.urlMode(value);
        return this;
    }

    @Override
    public LinkBuilder dummyLink(boolean value) {
        this.linkArgs.dummyLink(value);
        return this;
    }

    @Override
    public LinkBuilder dummyLinkUrl(String value) {
        this.linkArgs.dummyLinkUrl(value);
        return this;
    }

    @Override
    public LinkBuilder selectors(String value) {
        this.linkArgs.selectors(value);
        return this;
    }

    @Override
    public LinkBuilder extension(String value) {
        this.linkArgs.extension(value);
        return this;
    }

    @Override
    public LinkBuilder suffix(String value) {
        this.linkArgs.suffix(value);
        return this;
    }

    @Override
    public LinkBuilder queryString(String value) {
        this.linkArgs.queryString(value);
        return this;
    }

    @Override
    public LinkBuilder fragment(String value) {
        this.linkArgs.fragment(value);
        return this;
    }

    @Override
    public Link build() {
        LinkRequest request = new LinkRequest(this.resource, this.page, this.linkArgs);
        return this.linkHandler.processRequest(request);
    }

    @Override
    public String buildMarkup() {
        return this.build().getMarkup();
    }

    @Override
    public Anchor buildAnchor() {
        return this.build().getAnchor();
    }

    @Override
    public String buildUrl() {
        return this.build().getUrl();
    }
}

