/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.link.impl;

import com.day.cq.wcm.api.Page;
import io.wcm.handler.link.Link;
import io.wcm.handler.link.LinkBuilder;
import io.wcm.handler.link.LinkHandler;
import io.wcm.handler.link.LinkRequest;
import io.wcm.handler.link.impl.LinkBuilderImpl;
import io.wcm.handler.link.spi.LinkHandlerConfig;
import io.wcm.handler.link.spi.LinkMarkupBuilder;
import io.wcm.handler.link.spi.LinkProcessor;
import io.wcm.handler.link.spi.LinkType;
import io.wcm.sling.commons.adapter.AdaptTo;
import io.wcm.sling.models.annotations.AemObject;
import java.util.List;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.Self;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class}, adapters={LinkHandler.class})
public final class LinkHandlerImpl
implements LinkHandler {
    @Self
    private Adaptable adaptable;
    @Self
    private LinkHandlerConfig linkHandlerConfig;
    @AemObject(injectionStrategy=InjectionStrategy.OPTIONAL)
    private Page currentPage;

    @Override
    public LinkBuilder get(Resource resource) {
        return new LinkBuilderImpl(resource, this);
    }

    @Override
    public LinkBuilder get(Page page) {
        return new LinkBuilderImpl(page, this);
    }

    @Override
    public LinkBuilder get(LinkRequest linkRequest) {
        return new LinkBuilderImpl(linkRequest, this);
    }

    Link processRequest(LinkRequest linkRequest) {
        List<Class<? extends LinkProcessor>> list;
        LinkType linkType = null;
        List<Class<? extends LinkType>> linkTypes = this.linkHandlerConfig.getLinkTypes();
        if (linkTypes == null || linkTypes.isEmpty()) {
            throw new RuntimeException("No link types defined.");
        }
        for (Class<? extends LinkType> candidateLinkTypeClass : linkTypes) {
            LinkType candidateLinkType = (LinkType)AdaptTo.notNull((Adaptable)this.adaptable, candidateLinkTypeClass);
            if (!candidateLinkType.accepts(linkRequest)) continue;
            linkType = candidateLinkType;
            break;
        }
        Link link = new Link(linkType, linkRequest);
        List<Class<? extends LinkProcessor>> linkPreProcessors = this.linkHandlerConfig.getPreProcessors();
        if (linkPreProcessors != null) {
            for (Class clazz : linkPreProcessors) {
                LinkProcessor linkProcessor = (LinkProcessor)AdaptTo.notNull((Adaptable)this.adaptable, (Class)clazz);
                link = linkProcessor.process(link);
                if (link != null) continue;
                throw new RuntimeException("LinkPreProcessor '" + linkProcessor + "' returned null, page '" + (this.currentPage != null ? this.currentPage.getPath() : "-") + "'.");
            }
        }
        if (linkType != null && (link = linkType.resolveLink(link)) == null) {
            throw new RuntimeException("LinkType '" + linkType + "' returned null, page '" + (this.currentPage != null ? this.currentPage.getPath() : "-") + "'.");
        }
        List<Class<? extends LinkMarkupBuilder>> linkMarkupBuilders = this.linkHandlerConfig.getMarkupBuilders();
        if (linkMarkupBuilders != null) {
            for (Class<? extends LinkMarkupBuilder> clazz : linkMarkupBuilders) {
                LinkMarkupBuilder linkMarkupBuilder = (LinkMarkupBuilder)AdaptTo.notNull((Adaptable)this.adaptable, clazz);
                if (!linkMarkupBuilder.accepts(link)) continue;
                link.setAnchor(linkMarkupBuilder.build(link));
                break;
            }
        }
        if ((list = this.linkHandlerConfig.getPostProcessors()) != null) {
            for (Class<? extends LinkProcessor> processorClass : list) {
                LinkProcessor processor = (LinkProcessor)AdaptTo.notNull((Adaptable)this.adaptable, processorClass);
                link = processor.process(link);
                if (link != null) continue;
                throw new RuntimeException("LinkPostProcessor '" + processor + "' returned null, page '" + (this.currentPage != null ? this.currentPage.getPath() : "-") + "'.");
            }
        }
        return link;
    }
}

