/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.link.markup;

import io.wcm.handler.commons.dom.Anchor;
import io.wcm.handler.link.Link;
import io.wcm.handler.link.spi.LinkMarkupBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.osgi.annotation.versioning.ProviderType;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class})
@ProviderType
public final class SimpleLinkMarkupBuilder
implements LinkMarkupBuilder {
    @Override
    public boolean accepts(Link link) {
        return link.isValid() && StringUtils.isNotEmpty((CharSequence)link.getUrl());
    }

    @Override
    public Anchor build(Link link) {
        ValueMap props = link.getLinkRequest().getResourceProperties();
        Anchor anchor = new Anchor(link.getUrl());
        String target = (String)props.get("linkWindowTarget", String.class);
        if (StringUtils.isNotEmpty((CharSequence)target) && !"_self".equals(target)) {
            anchor.setTarget(target);
        }
        return anchor;
    }
}

