/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.link.processor;

import io.wcm.handler.link.Link;
import io.wcm.handler.link.spi.LinkProcessor;
import io.wcm.handler.url.UrlHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.osgi.annotation.versioning.ConsumerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConsumerType
public abstract class AbstractInternalLinkInheritUrlParamLinkPostProcessor
implements LinkProcessor {
    @Self
    private UrlHandler urlHandler;
    private final Set<String> inheritUrlParameterNames;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    protected AbstractInternalLinkInheritUrlParamLinkPostProcessor(Set<String> inheritUrlParameterNames) {
        this.inheritUrlParameterNames = inheritUrlParameterNames;
    }

    @Override
    public final Link process(Link link) {
        if (link.isValid() && link.getLinkType().getId() == "internal") {
            String url = link.getUrl();
            try {
                URI uri = new URI(url);
                String path = uri.getPath();
                if (uri.getScheme() != null && uri.getHost() != null) {
                    path = uri.getScheme() + "://" + uri.getHost() + path;
                }
                url = this.urlHandler.get(path).queryString(uri.getRawQuery(), this.inheritUrlParameterNames).fragment(uri.getFragment()).build();
                link.setUrl(url);
                if (link.getAnchor() != null) {
                    link.getAnchor().setAttribute("href", url);
                }
            }
            catch (URISyntaxException ex) {
                this.log.warn("Skipping post-processing or URL: " + url, (Throwable)ex);
            }
        }
        return link;
    }
}

